package com.xdja.pki.ldap.sdk.ca.bean;


public enum RequestType {
    HTTP_REQUEST(0, "http请求"),

    HTTPS_REQUEST(1, "https请求");


    public int id;
    public String describe;

    private RequestType(int id, String describe) {
        this.id = id;
        this.describe = describe;
    }

    public static String getValueFromId(int id) {
        for (RequestType t : RequestType.values()) {
            if (t.id == id) {
                return t.describe;
            }
        }
        throw new IllegalArgumentException(String.format("RequestType 枚举转换异常[id=%d]", id));
    }
}
