package com.xdja.pki.ldap.sdk.user;

import com.xdja.pki.ldap.utils.LDAPUserUtils;
import sun.security.provider.certpath.X509CertificatePair;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class LDAPUserTemplate {

    //CRL       ?certificateRevocationList;binary
    public static X509CRL searchCrlByUserCert(X509Certificate certificate) throws Exception {
        String url = LDAPUserUtils.getCRLURLWithCert(certificate);
        return LDAPUserUtils.searchCRL(url);
    }

    //ARL       ?authorityRevocationList;binary
    public static X509CRL searchArlByCACert(X509Certificate certificate) throws Exception {
        String url = LDAPUserUtils.getCRLURLWithCert(certificate);
        return LDAPUserUtils.searchARL(url);
    }

    //DRL       ?deltaRevocationList;binary
    public static X509CRL searchDrlByCert(X509Certificate certificate) throws Exception {
        //  String url = "ldap://11.12.85.57:389/cn=crl0,o=rootCAcrl,O=XDJA,C=CN?deltaRevocationList;binary";
        String url = LDAPUserUtils.getDRLURLWithCert(certificate);
        return LDAPUserUtils.searchDRL(url);
    }

    //?CACertificate,CrossCertificatePair  CASubject
    public static Map searchCASubCertByCert(X509Certificate certificate) throws Exception {
        String url = LDAPUserUtils.getSubjectURLWithCert(certificate);
        return searchIssue(url);
    }

    //userCertificate;binary  UserSubject
    public static List<X509Certificate> searchUserSubCertByCert(X509Certificate certificate) throws Exception {
        String url = LDAPUserUtils.getSubjectURLWithCert(certificate);
        return LDAPUserUtils.searchCert(url);
    }

    //?CACertificate,CrossCertificatePair  Issue
    public static Map searchIssueCertByCert(X509Certificate certificate) throws Exception {
        String url = LDAPUserUtils.getIssueURLWithCert(certificate);
        return searchIssue(url);
    }

    //?CACertificate,CrossCertificatePair  Issue
    public static Map searchIssueCertByCRL(X509CRL crl) throws Exception {
        String url = LDAPUserUtils.getIssueURLWithCRL(crl);
        return searchIssue(url);
    }

    private static Map searchIssue(String url) throws Exception {
        List<X509Certificate> certificates = LDAPUserUtils.searchCert(url);
        List<X509CertificatePair> pairs = LDAPUserUtils.searchCrossCert(url);
        Map map = new HashMap();
        map.put("CACertificate", certificates);
        map.put("CrossCertificatePair", pairs);
        return map;
    }
}

