/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.sdk.user;

import com.xdja.pki.ldap.utils.LDAPUserUtils;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.provider.certpath.X509CertificatePair;

public class LDAPUserTemplate {
    private static Logger logger = LoggerFactory.getLogger(LDAPUserTemplate.class);

    public static X509CRL searchCrlByUserCert(X509Certificate certificate) throws Exception {
        logger.debug("----------------\u6839\u636e\u7528\u6237\u8bc1\u4e66\u67e5\u8be2CRL---------------");
        String url = LDAPUserUtils.getCRLURLWithCert(certificate);
        return LDAPUserUtils.searchCRL(url);
    }

    public static X509CRL searchArlByCACert(X509Certificate certificate) throws Exception {
        logger.debug("----------------\u6839\u636eCA\u8bc1\u4e66\u67e5\u8be2ARL---------------");
        String url = LDAPUserUtils.getCRLURLWithCert(certificate);
        return LDAPUserUtils.searchARL(url);
    }

    public static X509CRL searchDrlByCert(X509Certificate certificate) throws Exception {
        logger.debug("----------------\u6839\u636e\u8bc1\u4e66\u67e5\u8be2DRL---------------");
        String url = LDAPUserUtils.getDRLURLWithCert(certificate);
        return LDAPUserUtils.searchDRL(url);
    }

    public static Map searchCASubCertByCACert(X509Certificate certificate) throws Exception {
        logger.debug("----------------\u6839\u636eCA\u8bc1\u4e66\u67e5\u8be2CA\u8bc1\u4e66\u4e3b\u4f53\u4fe1\u606f---------------");
        String url = LDAPUserUtils.getSubjectURLWithCert(certificate);
        return LDAPUserTemplate.searchIssue(url);
    }

    public static List<X509Certificate> searchUserSubCertByCert(X509Certificate certificate) throws Exception {
        logger.debug("----------------\u6839\u636e\u7528\u6237\u8bc1\u4e66\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u4e3b\u4f53\u4fe1\u606f---------------");
        String url = LDAPUserUtils.getSubjectURLWithCert(certificate);
        return LDAPUserUtils.searchCert(url, false);
    }

    public static Map searchIssueCertByCert(X509Certificate certificate) throws Exception {
        logger.debug("----------------\u6839\u636e\u8bc1\u4e66\u67e5\u8be2\u8bc1\u4e66\u6388\u6743\u673a\u6784\u4fe1\u606f---------------");
        String url = LDAPUserUtils.getIssueURLWithCert(certificate);
        return LDAPUserTemplate.searchIssue(url);
    }

    public static Map searchIssueCertByCRL(X509CRL crl) throws Exception {
        logger.debug("----------------\u6839\u636eCRL\u67e5\u8be2\u8bc1\u4e66\u6388\u6743\u673a\u6784\u4fe1\u606f---------------");
        String url = LDAPUserUtils.getIssueURLWithCRL(crl);
        return LDAPUserTemplate.searchIssue(url);
    }

    private static Map searchIssue(String url) throws Exception {
        List<X509Certificate> certificates = LDAPUserUtils.searchCert(url, true);
        List<X509CertificatePair> pairs = LDAPUserUtils.searchCrossCert(url);
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        map.put("CACertificate", certificates);
        map.put("CrossCertificatePair", pairs);
        return map;
    }
}

