/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.utils;

import com.sun.jndi.ldap.LdapURL;
import com.xdja.pki.asn1.x509.SubjectInformationAccess;
import com.xdja.pki.ldap.X509Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertPairParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.query.LdapQueryBuilder;
import sun.security.provider.certpath.X509CertificatePair;

public class LDAPUserUtils {
    private static CertificateFactory certificateFactory;
    private static Logger logger;

    private static Attributes search(String url) throws Exception {
        LdapTemplate ldapTemplate;
        LdapURL ldapURL = new LdapURL(url);
        String[] attrs = ldapURL.getAttributes().split(",");
        LdapContextSource lcs = new LdapContextSource();
        lcs.setUrl("ldap://" + ldapURL.getHost() + ":" + ldapURL.getPort());
        lcs.setDirObjectFactory(DefaultDirObjectFactory.class);
        lcs.afterPropertiesSet();
        try {
            ldapTemplate = new LdapTemplate((ContextSource)lcs);
            logger.info("\u8fde\u63a5\u670d\u52a1\u5668\u6210\u529f\uff0c\u5f00\u59cb\u67e5\u8be2\u76f8\u5173\u5185\u5bb9");
        }
        catch (Exception e) {
            logger.error("\u4e0d\u80fd\u8fde\u63a5\u5230\u670d\u52a1\u5668");
            throw new Exception("can't connect server");
        }
        Attributes attributes = (Attributes)ldapTemplate.searchForObject(LdapQueryBuilder.query().base(ldapURL.getDN()).attributes(attrs).filter("(objectClass=*)"), (ContextMapper)new ContextMapper<Attributes>(){

            public Attributes mapFromContext(Object ctx) {
                return ((DirContextAdapter)ctx).getAttributes();
            }
        });
        return attributes;
    }

    public static List<X509Certificate> searchCert(String url, boolean isCA) throws Exception {
        String search = isCA ? "cACertificate;binary" : "userCertificate;binary";
        Attributes attributes = LDAPUserUtils.search(url);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        NamingEnumeration<String> iDs = attributes.getIDs();
        while (iDs.hasMore()) {
            String id = iDs.next();
            if (!id.equalsIgnoreCase(search)) continue;
            NamingEnumeration<?> all = attributes.get(id).getAll();
            while (all.hasMore()) {
                X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream((byte[])all.next()));
                certificates.add(certificate);
            }
        }
        return certificates;
    }

    public static X509CRL searchX509CRL(Attributes attributes, String flag) throws Exception {
        NamingEnumeration<String> iDs = attributes.getIDs();
        while (iDs.hasMore()) {
            NamingEnumeration<?> all;
            String id = iDs.next();
            if (!id.equalsIgnoreCase(flag) || !(all = attributes.get(id).getAll()).hasMore()) continue;
            return (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream((byte[])all.next()));
        }
        logger.error("\u6ca1\u6709\u67e5\u5230\u76f8\u5173 " + flag);
        throw new Exception("\u6ca1\u6709\u67e5\u5230\u76f8\u5173" + flag);
    }

    public static X509CRL searchCRL(String url) throws Exception {
        Attributes attributes = LDAPUserUtils.search(url);
        return LDAPUserUtils.searchX509CRL(attributes, "certificateRevocationList;binary");
    }

    public static X509CRL searchDRL(String url) throws Exception {
        Attributes attributes = LDAPUserUtils.search(url);
        return LDAPUserUtils.searchX509CRL(attributes, "deltaRevocationList;binary");
    }

    public static X509CRL searchARL(String url) throws Exception {
        Attributes attributes = LDAPUserUtils.search(url);
        return LDAPUserUtils.searchX509CRL(attributes, "authorityRevocationList;binary");
    }

    public static List<X509CertificatePair> searchCrossCert(String url) throws Exception {
        Attributes attributes = LDAPUserUtils.search(url);
        ArrayList<X509CertificatePair> pairs = new ArrayList<X509CertificatePair>();
        NamingEnumeration<String> iDs = attributes.getIDs();
        while (iDs.hasMore()) {
            String id = iDs.next();
            if (!id.equalsIgnoreCase("crossCertificatePair;binary")) continue;
            NamingEnumeration<?> all = attributes.get(id).getAll();
            while (all.hasMore()) {
                X509CertPairParser pairParser = new X509CertPairParser();
                pairParser.engineInit((InputStream)new ByteArrayInputStream((byte[])all.next()));
                X509CertificatePair pair = X509Utils.convertCertificatePair((org.bouncycastle.x509.X509CertificatePair)((org.bouncycastle.x509.X509CertificatePair)pairParser.engineRead()));
                pairs.add(pair);
            }
        }
        return pairs;
    }

    public static String getSubjectURLWithCert(X509Certificate certificate) throws Exception {
        TBSCertificate tbs = TBSCertificate.getInstance((Object)certificate.getTBSCertificate());
        Extensions extensions = tbs.getExtensions();
        return LDAPUserUtils.subjectCertCommon(extensions, "1.3.6.1.5.5.7.48.5");
    }

    public static String getIssueURLWithCert(X509Certificate certificate) throws Exception {
        TBSCertificate tbs = TBSCertificate.getInstance((Object)certificate.getTBSCertificate());
        Extensions extensions = tbs.getExtensions();
        return LDAPUserUtils.issueCertCommon(extensions, AccessDescription.id_ad_caIssuers.getId());
    }

    public static String getCRLURLWithCert(X509Certificate certificate) throws Exception {
        byte[] extensionValue = certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        logger.debug("\u5f00\u59cb\u67e5\u8be2\u8bc1\u4e66\u4e2dcRLDistributionPoints\u6269\u5c55\u9879");
        return LDAPUserUtils.CrlCommon(extensionValue);
    }

    public static String getDRLURLWithCert(X509Certificate certificate) throws Exception {
        byte[] extensionValue = certificate.getExtensionValue(Extension.freshestCRL.getId());
        logger.debug("\u5f00\u59cb\u67e5\u8be2\u8bc1\u4e66\u4e2dfreshestCRL\u6269\u5c55\u9879");
        return LDAPUserUtils.CrlCommon(extensionValue);
    }

    public static String getIssueURLWithCRL(X509CRL crl) throws Exception {
        TBSCertList tbs = TBSCertList.getInstance((Object)crl.getTBSCertList());
        Extensions extensions = tbs.getExtensions();
        return LDAPUserUtils.issueCertCommon(extensions, AccessDescription.id_ad_caIssuers.getId());
    }

    private static String CrlCommon(byte[] extensionValue) throws Exception {
        DistributionPoint[] distributionPoints;
        CRLDistPoint crlDistPoint = CRLDistPoint.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionValue));
        for (DistributionPoint distributionPoint : distributionPoints = crlDistPoint.getDistributionPoints()) {
            GeneralName[] names;
            DistributionPointName distributionPoint1 = distributionPoint.getDistributionPoint();
            GeneralNames instance = GeneralNames.getInstance((Object)distributionPoint1.getName().toASN1Primitive());
            for (GeneralName generalName : names = instance.getNames()) {
                if (generalName.getTagNo() != 6) continue;
                DERIA5String str = DERIA5String.getInstance((Object)generalName.getName());
                return new String(str.getOctets(), "utf-8");
            }
        }
        logger.error("\u8fd9\u4e2a\u8bc1\u4e66\u6ca1\u6709\u76f8\u5173\u6269\u5c55\u9879");
        throw new Exception("this cert is not contains cRLDistributionPoints");
    }

    private static String issueCertCommon(Extensions extensions, String id) throws Exception {
        AccessDescription[] descs;
        AuthorityInformationAccess access = AuthorityInformationAccess.fromExtensions((Extensions)extensions);
        for (AccessDescription desc : descs = access.getAccessDescriptions()) {
            if (!desc.getAccessMethod().getId().equalsIgnoreCase(id)) continue;
            GeneralName generalName = GeneralName.getInstance((Object)desc.getAccessLocation());
            DERIA5String instance = DERIA5String.getInstance((Object)generalName.getName());
            return new String(instance.getOctets(), "utf-8");
        }
        logger.error("\u8fd9\u4e2a\u8bc1\u4e66\u6ca1\u6709Authority Information Access\u6269\u5c55\u9879");
        throw new Exception("this cert is not contains Authority Information Access");
    }

    private static String subjectCertCommon(Extensions extensions, String id) throws Exception {
        AccessDescription[] descs;
        SubjectInformationAccess access = SubjectInformationAccess.fromExtensions((Extensions)extensions);
        for (AccessDescription desc : descs = access.getAccessDescriptions()) {
            if (!desc.getAccessMethod().getId().equalsIgnoreCase(id)) continue;
            GeneralName generalName = GeneralName.getInstance((Object)desc.getAccessLocation());
            DERIA5String instance = DERIA5String.getInstance((Object)generalName.getName());
            return new String(instance.getOctets(), "utf-8");
        }
        logger.error("\u8fd9\u4e2a\u8bc1\u4e66\u6ca1\u6709Subject Information Accesss\u6269\u5c55\u9879");
        throw new Exception("this cert is not contains Subject Information Access");
    }

    static {
        logger = LoggerFactory.getLogger(LDAPUserUtils.class);
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException | CertificateException e) {
            e.printStackTrace();
        }
    }
}

