/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.config;

import com.xdja.pki.ldap.X509Utils;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="ldap.server")
public class LDAPConfiguration {
    private String caCert;
    private String signCert;
    private String signKey;
    private String encCert;
    private String encKey;
    private int privateKeyIndex;
    private String privateKeyPassword;
    private String isVerifyByBc;
    private String isVerifyByYunhsm;
    private String isVerifyByPcie;
    private String caCertByYunhsm;
    private String signCertByYunhsm;

    public boolean isVerifyByBc() {
        return this.isVerifyByBc.equalsIgnoreCase("T");
    }

    public void setIsVerifyByBc(String isVerifyByBc) {
        this.isVerifyByBc = isVerifyByBc;
    }

    public boolean isVerifyByYunhsm() {
        return this.isVerifyByYunhsm.equalsIgnoreCase("T");
    }

    public void setIsVerifyByYunhsm(String isVerifyByYunhsm) {
        this.isVerifyByYunhsm = isVerifyByYunhsm;
    }

    public boolean isVerifyByPcie() {
        return this.isVerifyByPcie.equalsIgnoreCase("T");
    }

    public void setIsVerifyByPcie(String isVerifyByPcie) {
        this.isVerifyByPcie = isVerifyByPcie;
    }

    public int getPrivateKeyIndex() {
        return this.privateKeyIndex;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setPrivateKeyIndex(int privateKeyIndex) {
        this.privateKeyIndex = privateKeyIndex;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public X509Certificate getCaCert() throws Exception {
        return X509Utils.getX509CertificateFromPEM((String)this.caCert);
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public void updateCaCert(X509Certificate certificate) throws Exception {
        X509Utils.writeCertificatePem((String)this.caCert.replace("ca.pem", ""), (String)"ca", (X509Certificate)certificate);
    }

    public X509Certificate getSignCert() throws Exception {
        return X509Utils.getX509CertificateFromPEM((String)this.signCert);
    }

    public void setSignCert(String signCert) {
        this.signCert = signCert;
    }

    public KeyPair getSignKey() throws Exception {
        return X509Utils.getKeyPairFromPEM((String)this.signKey);
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public X509Certificate getEncCert() throws Exception {
        return X509Utils.getX509CertificateFromPEM((String)this.encCert);
    }

    public void setEncCert(String encCert) {
        this.encCert = encCert;
    }

    public KeyPair getEncKey() throws Exception {
        return X509Utils.getKeyPairFromPEM((String)this.signKey);
    }

    public void setEncKey(String encKey) {
        this.encKey = encKey;
    }

    public X509Certificate getCaCertByYunhsm() throws Exception {
        return X509Utils.getX509CertificateFromPEM((String)this.caCertByYunhsm);
    }

    public void setCaCertByYunhsm(String caCertByYunhsm) {
        this.caCertByYunhsm = caCertByYunhsm;
    }

    public X509Certificate getSignCertByYunhsm() throws Exception {
        return X509Utils.getX509CertificateFromPEM((String)this.signCertByYunhsm);
    }

    public void setSignCertByYunhsm(String signCertByYunhsm) {
        this.signCertByYunhsm = signCertByYunhsm;
    }
}

