package com.xdja.pki.ldap.config;

import com.xdja.pki.ldap.X509Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;

@Component
@ConfigurationProperties(prefix = "ldap.server")
public class LDAPConfiguration {
    private Logger logger = LoggerFactory.getLogger(LDAPConfiguration.class);
    private String caCert;
    private String signCert;
    private String signKey;
    private String encCert;
    private String encKey;
    private int privateKeyIndex;
    private String privateKeyPassword;
    private String cryptoType;

    public String getCryptoType() {
        if (StringUtils.isEmpty(cryptoType)) {
            this.cryptoType = "YUNHSM";
        }
        return cryptoType;
    }

    public void setCryptoType(String cryptoType) throws Exception {
        this.cryptoType = cryptoType;
        if (!("YUNHSM".equalsIgnoreCase(this.cryptoType) ||
                "PCIE".equalsIgnoreCase(this.cryptoType) ||
                "BC".equalsIgnoreCase(this.cryptoType))) {
            logger.error("请配置正确的签名验签方式");
            throw new Exception("请配置正确的签名验签方式");
        }
        logger.info("签名验签方式为  " + this.cryptoType);
    }


    public int getPrivateKeyIndex() {
        return privateKeyIndex;
    }

    public String getPrivateKeyPassword() {
        return privateKeyPassword;
    }

    public void setPrivateKeyIndex(int privateKeyIndex) {
        this.privateKeyIndex = privateKeyIndex;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }
//
//    public List<X509Certificate> getCaCert() throws Exception {
//        return X509Utils.getX509CertificateFromPEM(caCert);
//    }
//
//    public void setCaCert(String caCert) {
//        this.caCert = caCert;
//    }

    public List<X509Certificate> getCaCerts() throws Exception {
        return X509Utils.getX509CertificateListFromFile(caCert);
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public void updateCaCert(X509Certificate certificate) throws Exception {
        X509Utils.appendCertificateToPem(caCert, certificate);
    }

    public X509Certificate getSignCert() throws Exception {
        return X509Utils.getX509CertificateFromPEM(signCert);
    }

    public void setSignCert(String signCert) {
        this.signCert = signCert;
    }

    public KeyPair getSignKey() throws Exception {
        return X509Utils.getKeyPairFromPEM(signKey);
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public X509Certificate getEncCert() throws Exception {
        return X509Utils.getX509CertificateFromPEM(encCert);
    }

    public void setEncCert(String encCert) {
        this.encCert = encCert;
    }

    public KeyPair getEncKey() throws Exception {
        return X509Utils.getKeyPairFromPEM(signKey);
    }

    public void setEncKey(String encKey) {
        this.encKey = encKey;
    }


}
