/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.service;

import com.xdja.pki.issue.PkixIssueCRL;
import com.xdja.pki.issue.PkixIssueReq;
import com.xdja.pki.issue.PkixIssueRespBuilder;
import com.xdja.pki.issue.TBSIssueResponseStatus;
import com.xdja.pki.ldap.X509Utils;
import com.xdja.pki.ldap.config.LDAPConfiguration;
import com.xdja.pki.ldap.dao.IDAO;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import sun.security.provider.certpath.X509CertificatePair;

@Service
public class OpenLDAPService {
    @Autowired
    private LDAPConfiguration ldapConfiguration;
    @Autowired
    private IDAO idao;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public byte[] pkixIssue(PkixIssueReq req, PkixIssueRespBuilder respBuilder) throws Exception {
        switch (req.getTBSIssueType()) {
            case UPDATE_ROOT_CERTIFICATE: {
                List list = req.getCertificateList();
                this.logger.debug("UPDATE_ROOT_CERTIFICATE LENGTH " + list.size());
                if (list.size() != 3) {
                    this.logger.error("\u66f4\u65b0\u6839\u8bc1\u4e66\u4f20\u9012\u6570\u91cf\u6709\u8bef");
                    return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                }
                try {
                    this.idao.updateRootCACertificate((X509Certificate)req.getCertificateList().get(0), (X509Certificate)req.getCertificateList().get(1), (X509Certificate)req.getCertificateList().get(2));
                }
                catch (Exception e) {
                    this.logger.error("\u66f4\u65b0\u6839\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
                    return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                }
                X509Certificate caNew = (X509Certificate)req.getCertificateList().get(2);
                this.ldapConfiguration.updateCaCert(caNew);
                this.logger.info("\u66f4\u65b0\u6839\u8bc1\u4e66\u6210\u529f");
                break;
            }
            case SEND_CERTIFICATE: {
                List list = req.getCertificateList();
                this.logger.debug("SEND_CERTIFICATE LENGTH " + list.size());
                for (X509Certificate cert : list) {
                    try {
                        if (X509Utils.isCACertificate((X509Certificate)cert)) {
                            this.ldapConfiguration.updateCaCert(cert);
                        }
                        this.idao.sendCertificate(cert);
                    }
                    catch (Exception e) {
                        this.logger.error("\u53d1\u5e03\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
                        return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                    }
                }
                this.logger.info("\u53d1\u5e03\u8bc1\u4e66\u6210\u529f");
                break;
            }
            case SEND_CRL: {
                List list = req.getCRLList();
                this.logger.debug("SEND_CRL " + list.size());
                for (PkixIssueCRL pkixIssueCRL : list) {
                    try {
                        this.idao.sendCRL(pkixIssueCRL.getCrlSegment(), pkixIssueCRL.getCrl());
                    }
                    catch (Exception e) {
                        this.logger.error("\u53d1\u5e03CRL\u5931\u8d25", (Throwable)e);
                        return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                    }
                }
                this.logger.info("\u53d1\u5e03crl\u6210\u529f");
                break;
            }
            case SEND_CROSS_CERTIFICATE: {
                List list = req.getCertificateList();
                this.logger.debug("SEND_CROSS_CERTIFICATE LENGTH " + list.size());
                List<X509Certificate> caCerts = this.ldapConfiguration.getCaCerts();
                if (list.size() == 1) {
                    if (X509Utils.verifyCert(caCerts, (X509Certificate)((X509Certificate)list.get(0)))) {
                        try {
                            this.logger.debug("\u53d1\u5e03IssueByThisCA");
                            this.idao.sendCrossCertificate(new X509CertificatePair(null, (X509Certificate)list.get(0)));
                            break;
                        }
                        catch (Exception e) {
                            this.logger.error("\u53d1\u5e03\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
                            return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                        }
                    }
                    try {
                        this.logger.debug("\u53d1\u5e03IssueByToCA");
                        this.idao.sendCrossCertificate(new X509CertificatePair((X509Certificate)list.get(0), null));
                        break;
                    }
                    catch (Exception e) {
                        this.logger.error("\u53d1\u5e03\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
                        return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                    }
                }
                if (list.size() == 2) {
                    X509CertificatePair pair;
                    try {
                        pair = new X509CertificatePair((X509Certificate)list.get(0), (X509Certificate)list.get(1));
                    }
                    catch (CertificateException e) {
                        this.logger.error("\u53d1\u5e03\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25\uff0c\u65e0\u6cd5\u901a\u8fc7\u8fd9\u4e24\u4e2a\u8bc1\u4e66\u6784\u5efa\u4ea4\u53c9\u8bc1\u4e66\u5bf9", (Throwable)e);
                        return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                    }
                    try {
                        this.idao.sendCrossCertificate(pair);
                        break;
                    }
                    catch (Exception e) {
                        this.logger.error("\u53d1\u5e03\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
                        return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                    }
                }
                this.logger.error("\u53d1\u5e03\u4ea4\u53c9\u8bc1\u4e66\u5931\u8d25");
                return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
            }
            case SEND_CERTIFICATE_STATUS: {
                List certStatusList = req.getCertStatusList();
                break;
            }
            default: {
                this.logger.error("\u672a\u77e5\u7684PkixIssue\u7c7b\u578b");
                throw new Exception("bad request unknown type " + req.getTBSIssueType());
            }
        }
        return respBuilder.build(req, TBSIssueResponseStatus.Normal, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
    }
}

