/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.config;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.ldap.X509Utils;
import java.io.File;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConfigurationProperties(prefix="ldap.server")
public class LDAPConfiguration {
    private Logger logger = LoggerFactory.getLogger(LDAPConfiguration.class);
    private String caCert;
    private String signCert;
    private String signKey;
    private int privateKeyIndex;
    private String privateKeyPassword;
    private String cryptoType;

    public String getCryptoType() {
        if (StringUtils.isEmpty((Object)this.cryptoType)) {
            this.cryptoType = "YUNHSM";
        }
        return this.cryptoType;
    }

    public void setCryptoType(String cryptoType) throws Exception {
        this.cryptoType = cryptoType;
        if (!("YUNHSM".equalsIgnoreCase(this.cryptoType) || "PCIE".equalsIgnoreCase(this.cryptoType) || "BC".equalsIgnoreCase(this.cryptoType))) {
            this.logger.error("\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f");
            throw new Exception("\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f");
        }
        this.logger.info("\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f\u4e3a  " + this.cryptoType);
    }

    public int getPrivateKeyIndex() {
        return this.privateKeyIndex;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setPrivateKeyIndex(int privateKeyIndex) {
        this.privateKeyIndex = privateKeyIndex;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public List<X509Certificate> getCaCerts() throws Exception {
        String caPem = this.getCaPem();
        if (this.isCaPemExist()) {
            return X509Utils.getX509CertificateListFromFile((String)caPem);
        }
        X509Utils.convertP7BToCaPemJson((String)this.caCert, (String)caPem);
        return X509Utils.getX509CertificateListFromP7B((String)this.caCert);
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public String getCaPem() {
        String name = "ca.pem";
        int lastSlashPos = this.caCert.lastIndexOf("/");
        return this.caCert.substring(0, lastSlashPos) + "/" + name;
    }

    private boolean isCaPemExist() {
        String caPem = this.getCaPem();
        File file = new File(caPem);
        return file.exists();
    }

    public void updateCaCert(X509Certificate certificate) throws Exception {
        String caPem = this.getCaPem();
        if (!this.isCaPemExist()) {
            X509Utils.convertP7BToCaPemJson((String)this.caCert, (String)caPem);
        }
        X509Utils.appendCertificateToPem((String)caPem, (X509Certificate)certificate);
    }

    public X509Certificate getSignCert() throws Exception {
        if (this.cryptoType.equalsIgnoreCase("YUNHSM")) {
            return X509Utils.getX509CertificateFromPEM((String)this.signCert);
        }
        String sign = "sign";
        KeyStore keyStore = LDAPConfiguration.readKeyStoreFromPath(this.signKey, "password".toCharArray());
        return (X509Certificate)GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)keyStore, (String)sign);
    }

    public void setSignCert(String signCert) {
        this.signCert = signCert;
    }

    public KeyPair getSignKey() throws Exception {
        String sign = "sign";
        KeyStore keyStore = LDAPConfiguration.readKeyStoreFromPath(this.signKey, "password".toCharArray());
        PrivateKey privateKey = GMSSLKeyStoreUtils.readPrivateKeyFromKeyStore((KeyStore)keyStore, (char[])"password".toCharArray(), (String)sign);
        Certificate certificate = GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)keyStore, (String)sign);
        return new KeyPair(certificate.getPublicKey(), privateKey);
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public static KeyStore readKeyStoreFromPath(String filename, char[] pw) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)filename);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(in, pw);
            return keyStore;
        }
        catch (Exception e) {
            boolean flag = false;
            System.out.println(flag);
            if (!flag) {
                InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)filename);
                KeyStore keyStore = KeyStore.getInstance("BKS", "BC");
                keyStore.load(in, pw);
                return keyStore;
            }
            return null;
        }
    }
}

