/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.config;

import com.xdja.pki.gmssl.core.utils.GMSSLECUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECKeyUtils;
import com.xdja.pki.gmssl.keystore.utils.GMSSLKeyStoreUtils;
import com.xdja.pki.ldap.X509Utils;
import java.io.File;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConfigurationProperties(prefix="ldap.server")
public class LDAPConfiguration {
    private Logger logger = LoggerFactory.getLogger(LDAPConfiguration.class);
    private String caCert;
    private String signCert;
    private String signKey;
    private int privateKeyIndex;
    private String privateKeyPassword;
    private String cryptoType;
    private String privateKey;
    private static final String EMPTY = "";

    public String getCryptoType() {
        if (StringUtils.isEmpty((Object)this.cryptoType)) {
            this.cryptoType = "YUNHSM";
        }
        return this.cryptoType;
    }

    public void setCryptoType(String cryptoType) throws Exception {
        this.cryptoType = cryptoType;
        if (!("YUNHSM".equalsIgnoreCase(this.cryptoType) || "PCIE".equalsIgnoreCase(this.cryptoType) || "BC".equalsIgnoreCase(this.cryptoType))) {
            this.logger.error("\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f");
            throw new Exception("\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f");
        }
        this.logger.info("\u7b7e\u540d\u9a8c\u7b7e\u65b9\u5f0f\u4e3a {}", (Object)this.cryptoType);
    }

    public int getPrivateKeyIndex() {
        return this.privateKeyIndex;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setPrivateKeyIndex(int privateKeyIndex) {
        this.privateKeyIndex = privateKeyIndex;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public List<String> getPrivateKey() {
        ArrayList<String> privateKeys = new ArrayList<String>();
        if (null == this.privateKey || EMPTY.equals(this.privateKey)) {
            return privateKeys;
        }
        String[] indexPwd = this.privateKey.split(",");
        for (int i = 0; i < indexPwd.length; ++i) {
            privateKeys.add(indexPwd[i]);
        }
        return privateKeys;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public List<X509Certificate> getCaCerts() throws Exception {
        String caPem = this.getCaPem();
        if (this.isCaPemExist()) {
            return X509Utils.getX509CertificateListFromFile((String)caPem);
        }
        X509Utils.convertP7BToCaPemJson((String)this.caCert, (String)caPem);
        return X509Utils.convertNestListToList((List)X509Utils.getX509CertificateListFromAllP7B((String)this.caCert));
    }

    public void setCaCert(String caCert) {
        this.caCert = caCert;
    }

    public String getCaCert() {
        return this.caCert;
    }

    public String getCaPem() {
        String name = "ca.pem";
        return this.caCert + "/" + name;
    }

    private boolean isCaPemExist() {
        String caPem = this.getCaPem();
        File file = new File(caPem);
        return file.exists();
    }

    public void updateCaCert(X509Certificate certificate) throws Exception {
        String caPem = this.getCaPem();
        if (!this.isCaPemExist()) {
            X509Utils.convertP7BToCaPemJson((String)this.caCert, (String)caPem);
        }
        X509Utils.appendCertificateToPem((String)caPem, (X509Certificate)certificate);
    }

    public void updateCaCert(X509Certificate certificate, List<X509Certificate> caCerts) throws Exception {
        String caPemPath = this.getCaPemPathByCaCerts(caCerts, this.caCert);
        List pemCertList = X509Utils.getX509CertificateListFromFile((String)caPemPath);
        if (!pemCertList.contains(certificate)) {
            X509Utils.appendCertificateToPem((String)caPemPath, (X509Certificate)certificate);
        }
    }

    public X509Certificate getSignCert() throws Exception {
        this.initInstance();
        if (this.cryptoType.equalsIgnoreCase("YUNHSM") && this.privateKeyPassword != null) {
            return X509Utils.getX509CertificateFromPEM((String)this.signCert);
        }
        String sign = "sign";
        KeyStore keyStore = X509Utils.readKeyStoreFromPath((String)this.signKey, (char[])"password".toCharArray());
        return (X509Certificate)GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)keyStore, (String)sign);
    }

    public List<X509Certificate> getAllSignCert() throws Exception {
        ArrayList<X509Certificate> certificateList = new ArrayList();
        certificateList = X509Utils.getX509CertificateFromAllPEM((String)this.signCert);
        String sign = "sign";
        List keyStores = X509Utils.readAllKeyStoreFromPath((String)this.signKey, (char[])"password".toCharArray());
        if (keyStores != null && keyStores.size() > 0) {
            for (int i = 0; i < keyStores.size(); ++i) {
                certificateList.add((X509Certificate)GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)((KeyStore)keyStores.get(i)), (String)sign));
            }
        }
        return certificateList;
    }

    public void setSignCert(String signCert) {
        this.signCert = signCert;
    }

    public KeyPair getSignKey() throws Exception {
        String sign = "sign";
        KeyStore keyStore = X509Utils.readKeyStoreFromPath((String)this.signKey, (char[])"password".toCharArray());
        PrivateKey privateKey = GMSSLKeyStoreUtils.readPrivateKeyFromKeyStore((KeyStore)keyStore, (char[])"password".toCharArray(), (String)sign);
        Certificate certificate = GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)keyStore, (String)sign);
        return new KeyPair(certificate.getPublicKey(), privateKey);
    }

    public List<KeyPair> getAllSignKey() throws Exception {
        ArrayList<KeyPair> keyPairList = new ArrayList<KeyPair>();
        String sign = "sign";
        List keyStores = X509Utils.readAllKeyStoreFromPath((String)this.signKey, (char[])"password".toCharArray());
        if (keyStores != null && keyStores.size() > 0) {
            for (int i = 0; i < keyStores.size(); ++i) {
                PrivateKey privateKey = GMSSLKeyStoreUtils.readPrivateKeyFromKeyStore((KeyStore)((KeyStore)keyStores.get(i)), (char[])"password".toCharArray(), (String)sign);
                Certificate certificate = GMSSLKeyStoreUtils.readCertificateFromKeyStore((KeyStore)((KeyStore)keyStores.get(i)), (String)sign);
                KeyPair keyPair = new KeyPair(certificate.getPublicKey(), privateKey);
                keyPairList.add(keyPair);
            }
        }
        return keyPairList;
    }

    public void setSignKey(String signKey) {
        this.signKey = signKey;
    }

    public void initInstance() {
        if ("YUNHSM".equalsIgnoreCase(this.cryptoType)) {
            if (this.privateKeyPassword == null) {
                try {
                    GMSSLPkiCryptoInit.getSancHsmInstance();
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6Sanc hsm instance\u5f02\u5e38");
                }
            } else {
                GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            }
        }
        if ("PCIE".equalsIgnoreCase(this.cryptoType)) {
            GMSSLPkiCryptoInit.getPcieInstance();
        }
        if ("BC".equalsIgnoreCase(this.cryptoType)) {
            GMSSLPkiCryptoInit.getBCInstance();
        }
    }

    public void initInstance(String cryptoType) {
        if ("YUNHSM".equalsIgnoreCase(cryptoType)) {
            if (this.privateKeyPassword == null) {
                try {
                    GMSSLPkiCryptoInit.getSancHsmInstance();
                }
                catch (Exception e) {
                    this.logger.error("\u83b7\u53d6Sanc hsm instance\u5f02\u5e38");
                }
            } else {
                GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
            }
        }
        if ("PCIE".equalsIgnoreCase(cryptoType)) {
            GMSSLPkiCryptoInit.getPcieInstance();
        }
        if ("BC".equalsIgnoreCase(cryptoType)) {
            GMSSLPkiCryptoInit.getBCInstance();
        }
    }

    public Map<String, Object> getCAToLDAPMap(List<List<X509Certificate>> nestCaList) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5f00\u59cb\u83b7\u53d6\u914d\u7f6e\u7684CA\u8bc1\u4e66-\u670d\u52a1\u5668\u8bc1\u4e66-KeyPair\u6216\u8005\u79c1\u94a5\u7d22\u5f15\u6620\u5c04");
        }
        HashMap<String, Object> caLdapMap = new HashMap<String, Object>();
        List<List<X509Certificate>> caCertsList = nestCaList;
        List<X509Certificate> signCertList = this.getAllSignCert();
        List<KeyPair> keyPairs = this.getAllSignKey();
        List<String> privateKeys = this.getPrivateKey();
        for (int i = 0; i < caCertsList.size(); ++i) {
            ArrayList<Object> tempCALDAPList = new ArrayList<Object>();
            List<X509Certificate> x509Certificates = caCertsList.get(i);
            tempCALDAPList.add(x509Certificates);
            String keyStr = X509Utils.getKeyFromCertificate((X509Certificate)x509Certificates.get(x509Certificates.size() - 1));
            for (int m = x509Certificates.size() - 1; m >= 0; --m) {
                X509Certificate x509Cert = x509Certificates.get(m);
                String signAlg = x509Cert.getSigAlgName();
                Iterator<X509Certificate> iterSignCert = signCertList.iterator();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u83b7\u53d6\u670d\u52a1\u5668\u8bc1\u4e66\u6620\u5c04");
                }
                while (iterSignCert.hasNext()) {
                    X509Certificate serverCert = iterSignCert.next();
                    if (!X509Utils.verifyCert(x509Certificates, (X509Certificate)serverCert)) continue;
                    tempCALDAPList.add(serverCert);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u83b7\u53d6KeyPair\u6620\u5c04");
                    }
                    Iterator<KeyPair> iterKeyPair = keyPairs.iterator();
                    while (iterKeyPair.hasNext()) {
                        KeyPair keyPair = iterKeyPair.next();
                        if (!serverCert.getPublicKey().equals(keyPair.getPublic())) continue;
                        tempCALDAPList.add(keyPair);
                        iterKeyPair.remove();
                        iterSignCert.remove();
                    }
                    if (privateKeys == null || privateKeys.isEmpty() || !signAlg.contains("SM2") || !serverCert.getSigAlgName().contains("SM2")) continue;
                    BCECPublicKey bcecPublicKeyFromCert = (BCECPublicKey)serverCert.getPublicKey();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u83b7\u53d6\u79c1\u94a5\u7d22\u5f15\u6620\u5c04");
                    }
                    Iterator<String> iterPriKey = privateKeys.iterator();
                    while (iterPriKey.hasNext()) {
                        String privateKey = iterPriKey.next();
                        String[] privateKeyArr = privateKey.split("-");
                        if (privateKeyArr.length != 2) {
                            iterPriKey.remove();
                            continue;
                        }
                        BCECPublicKey bcecPublicKeyFromHsm = (BCECPublicKey)GMSSLECKeyUtils.getSignPublicKeyByYunhsm((int)Integer.parseInt(privateKeyArr[0]), (String)GMSSLECUtils.SM2p256);
                        if (!bcecPublicKeyFromCert.equals((Object)bcecPublicKeyFromHsm)) continue;
                        tempCALDAPList.add(privateKeyArr);
                        iterPriKey.remove();
                        iterSignCert.remove();
                    }
                }
                if (tempCALDAPList.size() != 3) continue;
                caLdapMap.put(keyStr, tempCALDAPList);
            }
        }
        return caLdapMap;
    }

    public List<List<X509Certificate>> getAllCAListFromPath(String path) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5f00\u59cb\u83b7\u53d6\u914d\u7f6e\u7684CA\u8bc1\u4e66\u94fe\u8868");
        }
        String[] allCaFiles = new File(path).list();
        ArrayList<List<X509Certificate>> caCerts = new ArrayList<List<X509Certificate>>();
        for (int i = 0; i < allCaFiles.length; ++i) {
            List singleCaCerts = new ArrayList();
            String singleCa = allCaFiles[i];
            String[] singleCaFiles = new File(path + "/" + singleCa).list();
            if (singleCaFiles.length == 1) {
                String p7bFilePath = path + "/" + singleCa + "/" + singleCaFiles[0];
                String pemFilePath = path + "/" + singleCa + "/ca.pem";
                X509Utils.convertP7BToCaPemJson((String)p7bFilePath, (String)pemFilePath);
                singleCaCerts = X509Utils.getX509CertificateListFromP7B((String)p7bFilePath);
            } else {
                String pemFilePath = path + "/" + singleCa + "/ca.pem";
                List oldSingleCaCerts = X509Utils.getX509CertificateListFromFile((String)pemFilePath);
                List tempCertList = new ArrayList();
                for (int j = 0; j < singleCaFiles.length; ++j) {
                    String p7bFilePath = null;
                    if (!"ca.pem".equalsIgnoreCase(singleCaFiles[j])) {
                        p7bFilePath = path + "/" + singleCa + "/" + singleCaFiles[j];
                        tempCertList = X509Utils.getX509CertificateListFromP7B((String)p7bFilePath);
                    }
                    if (oldSingleCaCerts.containsAll(tempCertList)) continue;
                    for (int k = 0; k < tempCertList.size(); ++k) {
                        X509Utils.appendCertificateToPem((String)pemFilePath, (X509Certificate)((X509Certificate)tempCertList.get(k)));
                    }
                }
                singleCaCerts = X509Utils.getX509CertificateListFromFile((String)pemFilePath);
            }
            caCerts.add(singleCaCerts);
        }
        return caCerts;
    }

    private String getCaPemPathByCaCerts(List<X509Certificate> caCertList, String path) throws Exception {
        String[] allCaFiles = new File(path).list();
        String pemFilePath = null;
        for (int i = 0; i < allCaFiles.length; ++i) {
            List singleCaCerts = new ArrayList();
            String singleCa = allCaFiles[i];
            String[] singleCaFiles = new File(path + "/" + singleCa).list();
            if (singleCaFiles.length == 1) {
                String p7bFilePath = path + "/" + singleCa + "/" + singleCaFiles[0];
                pemFilePath = path + "/" + singleCa + "/ca.pem";
                X509Utils.convertP7BToCaPemJson((String)p7bFilePath, (String)pemFilePath);
                singleCaCerts = X509Utils.getX509CertificateListFromP7B((String)p7bFilePath);
            } else {
                pemFilePath = path + "/" + singleCa + "/ca.pem";
                List oldSingleCaCerts = X509Utils.getX509CertificateListFromFile((String)pemFilePath);
                List tempCertList = new ArrayList();
                for (int j = 0; j < singleCaFiles.length; ++j) {
                    String p7bFilePath = null;
                    if (!"ca.pem".equalsIgnoreCase(singleCaFiles[j])) {
                        p7bFilePath = path + "/" + singleCa + "/" + singleCaFiles[j];
                        tempCertList = X509Utils.getX509CertificateListFromP7B((String)p7bFilePath);
                    }
                    if (oldSingleCaCerts.containsAll(tempCertList)) continue;
                    X509Utils.convertP7BToCaPemJson(p7bFilePath, (String)pemFilePath);
                }
                singleCaCerts = X509Utils.getX509CertificateListFromFile((String)pemFilePath);
            }
            if (!singleCaCerts.containsAll(caCertList)) continue;
            return pemFilePath;
        }
        return null;
    }
}

