/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.controller;

import com.xdja.pki.issue.PkixIssueReq;
import com.xdja.pki.issue.PkixIssueRespBuilder;
import com.xdja.pki.issue.TBSIssueResponseStatus;
import com.xdja.pki.ldap.config.LDAPConfiguration;
import com.xdja.pki.ldap.service.OpenLDAPService;
import java.security.PublicKey;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/ldapserver"})
public class LDAPController {
    @Autowired
    private LDAPConfiguration ldapConfiguration;
    @Autowired
    private OpenLDAPService openLDAPService;

    @PostMapping(value={"/pkixissue"})
    public byte[] pkixissue(@RequestBody byte[] body, HttpServletResponse response) {
        PkixIssueReq req;
        PkixIssueRespBuilder respBuilder;
        PublicKey publicKey;
        try {
            publicKey = this.ldapConfiguration.getCaCert().getPublicKey();
            respBuilder = new PkixIssueRespBuilder(this.ldapConfiguration.getSignKey(), this.ldapConfiguration.getSignCert());
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return new byte[0];
        }
        try {
            req = new PkixIssueReq(body);
            System.out.println(req.getTBSIssueType());
            if (!req.isSignatureValid(publicKey)) {
                System.out.println("signature is not valid");
                return respBuilder.build(req, TBSIssueResponseStatus.Error).getEncoded();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return new byte[0];
        }
        try {
            return this.openLDAPService.pkixIssue(req, respBuilder);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return new byte[0];
        }
    }
}

