package com.xdja.pki.ldap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.support.SpringBootServletInitializer;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.web.context.WebApplicationContext;

import java.io.IOException;
import java.util.Properties;

@SpringBootApplication
public class LDAPApplication  extends SpringBootServletInitializer {

    private static Logger logger = LoggerFactory.getLogger(LDAPApplication.class);

    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.sources(LDAPApplication.class);
    }

    @Override
    protected WebApplicationContext run(SpringApplication application) {
        try {
            String[] commandLines = getCommandLines();

            return (WebApplicationContext) application.run(commandLines);
        } catch (IOException e) {
            logger.error("加载系统配置文件失败", e);
        }

        return super.run(application);
    }

    public static void main(String[] args) {
        try {
            args = getCommandLines();
        } catch (Exception e) {
            logger.error("加载系统配置文件失败", e);
            System.exit(-1);
        }

        SpringApplication app = new SpringApplication(LDAPApplication.class);
//		app.setBannerMode(Banner.Mode.OFF);
//		app.setAddCommandLineProperties(false);
        app.run(args);
    }

    /**
     * 获取配置文件加载命令
     *
     * @return
     * @throws IOException
     */
    private static String[] getCommandLines() throws IOException {
        Properties pro = PropertiesLoaderUtils.loadAllProperties("application.properties", Thread.class.getClassLoader());

        String confPath = (String) pro.get("config.path");
        String fileNames = (String) pro.get("config.name");

        StringBuilder temp = new StringBuilder();
        temp.append("--spring.config.location=");

        for (String fileName : fileNames.split(",")) {
            temp.append(confPath).append(fileName).append(",");
        }

        String[] args = new String[1];
        args[0] = temp.substring(0, temp.length() - 1);

        logger.info("即将从{}目录加载[{}]配置文件", confPath, fileNames);

        return args;
    }
}
