/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.controller;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.issue.PkixIssueReq;
import com.xdja.pki.issue.PkixIssueRespBuilder;
import com.xdja.pki.issue.TBSIssueResponseStatus;
import com.xdja.pki.ldap.config.LDAPConfiguration;
import com.xdja.pki.ldap.service.OpenLDAPService;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/ldapserver"})
public class LDAPController {
    @Autowired
    private LDAPConfiguration ldapConfiguration;
    @Autowired
    private OpenLDAPService openLDAPService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostMapping(value={"/pkixissue"})
    public byte[] pkixissue(@RequestBody byte[] body, HttpServletResponse response) {
        PkixIssueReq req;
        PkixIssueRespBuilder respBuilder;
        List caCerts;
        block20: {
            this.logger.info("------------\u8bbf\u95ee\u670d\u52a1\u5668\u6210\u529f------------");
            try {
                caCerts = this.ldapConfiguration.getCaCerts();
                if ("YUNHSM".equalsIgnoreCase(this.ldapConfiguration.getCryptoType())) {
                    respBuilder = new PkixIssueRespBuilder(this.ldapConfiguration.getPrivateKeyIndex(), this.ldapConfiguration.getPrivateKeyPassword(), caCerts, SdfCryptoType.YUNHSM);
                    this.logger.debug("\u4f7f\u7528\u52a0\u5bc6\u673a\u9a8c\u7b7e");
                    break block20;
                }
                if ("SWXAHSM".equalsIgnoreCase(this.ldapConfiguration.getCryptoType())) {
                    respBuilder = new PkixIssueRespBuilder(this.ldapConfiguration.getPrivateKeyIndex(), caCerts);
                    this.logger.debug("\u4f7f\u7528\u52a0\u5bc6\u673a\u9a8c\u7b7e");
                    break block20;
                }
                if ("PCIE".equalsIgnoreCase(this.ldapConfiguration.getCryptoType())) {
                    respBuilder = new PkixIssueRespBuilder(this.ldapConfiguration.getPrivateKeyIndex(), this.ldapConfiguration.getPrivateKeyPassword(), caCerts, SdfCryptoType.PCIE);
                    this.logger.debug("\u4f7f\u7528PCIE\u5361\u9a8c\u7b7e");
                    break block20;
                }
                if ("BC".equalsIgnoreCase(this.ldapConfiguration.getCryptoType())) {
                    respBuilder = new PkixIssueRespBuilder(this.ldapConfiguration.getSignKey(), caCerts);
                    this.logger.debug("\u4f7f\u7528BC\u6a21\u5f0f\u9a8c\u7b7e");
                    break block20;
                }
                this.logger.error("\u914d\u7f6e\u6587\u4ef6\u9a8c\u7b7e\u65b9\u5f0f\u914d\u7f6e\u6709\u8bef");
                response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                return new byte[0];
            }
            catch (Exception e) {
                this.logger.error("\u8bfb\u53d6\u914d\u7f6e\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
                response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                return new byte[0];
            }
        }
        try {
            req = new PkixIssueReq(body);
            this.logger.info("\u8bf7\u6c42\u7ed3\u6784\u4f53\u7c7b\u578b\u4e3a " + req.getTBSIssueType());
            if ("PCIE".equalsIgnoreCase(this.ldapConfiguration.getCryptoType())) {
                if (!req.verifySignatureBySdf(caCerts, SdfCryptoType.PCIE)) {
                    this.logger.error("\u8bf7\u6c42\u7ed3\u6784\u4f53\u7b7e\u540d\u65e0\u6548");
                    return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                }
            } else if ("YUNHSM".equalsIgnoreCase(this.ldapConfiguration.getCryptoType())) {
                if (!req.verifySignatureBySdf(caCerts, SdfCryptoType.YUNHSM)) {
                    this.logger.error("\u8bf7\u6c42\u7ed3\u6784\u4f53\u7b7e\u540d\u65e0\u6548");
                    return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                }
            } else if ("SWXAHSM".equalsIgnoreCase(this.ldapConfiguration.getCryptoType())) {
                if (!req.verifySignatureBySdf(caCerts, SdfCryptoType.YUNHSM)) {
                    this.logger.error("\u8bf7\u6c42\u7ed3\u6784\u4f53\u7b7e\u540d\u65e0\u6548");
                    return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
                }
            } else if (!req.verifySignatureByBC(caCerts, ((X509Certificate)caCerts.get(0)).getSigAlgName())) {
                this.logger.error("\u8bf7\u6c42\u7ed3\u6784\u4f53\u7b7e\u540d\u65e0\u6548");
                return respBuilder.build(req, TBSIssueResponseStatus.Error, this.ldapConfiguration.getSignCert().getSigAlgName()).getEncoded();
            }
        }
        catch (Exception e) {
            this.logger.error("\u65e0\u6cd5\u89e3\u6790\u8bf7\u6c42\u7ed3\u6784\u4f53 ", (Throwable)e);
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            return new byte[0];
        }
        try {
            return this.openLDAPService.pkixIssue(req, respBuilder);
        }
        catch (Exception e) {
            this.logger.error("\u5411LDAP\u5b58\u50a8\u5931\u8d25 ", (Throwable)e);
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return new byte[0];
        }
    }
}

