/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.license.util;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.license.bean.DeviceLicense;
import com.xdja.pki.license.bean.LicenseResult;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptUtils {
    private static Logger logger = LoggerFactory.getLogger(DecryptUtils.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    public static void getDeviceSn() {
        String DEVICE_FLAG = "Serial";
        String[] cmd1 = new String[]{"/bin/sh", "-c", "hdparm -i /dev/sda | grep 'Serial'"};
        String[] cmd2 = new String[]{"/bin/sh", "-c", "smartctl -i /dev/sda | grep 'Serial'"};
        String cmd1Result = DecryptUtils.execShell(cmd1);
        String[] deviceInfo1 = cmd1Result.split(",");
        for (int i = 0; i < deviceInfo1.length; ++i) {
            if (!deviceInfo1[i].trim().startsWith(DEVICE_FLAG)) continue;
            System.out.println("#############################################################################################################");
            System.out.println("##  \u8bbe\u5907\u5e8f\u5217\u53f7\uff1a");
            System.out.println("##  " + deviceInfo1[i].trim());
            System.out.println("#############################################################################################################");
            System.exit(0);
        }
        String cmd2Result = DecryptUtils.execShell(cmd2);
        String[] deviceInfo2 = cmd2Result.split(":");
        for (int i = 0; i < deviceInfo2.length; ++i) {
            System.out.println(deviceInfo2[i].trim());
            if (!deviceInfo2[i].trim().startsWith(DEVICE_FLAG)) continue;
            System.out.println("#############################################################################################################");
            System.out.println("##  \u8bbe\u5907\u5e8f\u5217\u53f7\uff1a");
            System.out.println("##  " + deviceInfo2[i].trim());
            System.out.println("#############################################################################################################");
            System.exit(0);
        }
        System.err.println("\u83b7\u53d6\u8bbe\u5907sn\u5931\u8d25");
    }

    public static String getDeviceSn(String back) {
        String DEVICE_FLAG = "Serial";
        String[] cmd1 = new String[]{"/bin/sh", "-c", "hdparm -i /dev/sda | grep 'Serial'"};
        String[] cmd2 = new String[]{"/bin/sh", "-c", "smartctl -i /dev/sda | grep 'Serial'"};
        String cmd1Result = DecryptUtils.execShell(cmd1);
        String[] deviceInfo1 = cmd1Result.split(",");
        for (int i = 0; i < deviceInfo1.length; ++i) {
            if (!deviceInfo1[i].trim().startsWith(DEVICE_FLAG)) continue;
            String[] tempArr = deviceInfo1[i].trim().split("=");
            return tempArr[1];
        }
        String cmd2Result = DecryptUtils.execShell(cmd2);
        String[] deviceInfo2 = cmd2Result.split(":");
        for (int i = 0; i < deviceInfo2.length; ++i) {
            System.out.println(deviceInfo2[i].trim());
            if (!deviceInfo2[i].trim().startsWith(DEVICE_FLAG)) continue;
            return deviceInfo2[i].trim();
        }
        return back;
    }

    public static LicenseResult resolveLicense(String licensePath) {
        try {
            byte[] licBytes = DecryptUtils.readByBinary(licensePath);
            String licName = licensePath.substring(licensePath.lastIndexOf(File.separator) + 1);
            String licHash = DecryptUtils.md5(new File(licensePath));
            String certPath = DecryptUtils.getCertPath();
            X509Certificate certificate = DecryptUtils.getX509CertificateFromPath(certPath);
            String encry64 = GMSSLByteArrayUtils.base64Encode((byte[])licBytes);
            String decryStr = DecryptUtils.decryptWithSM4(encry64);
            int position = decryStr.lastIndexOf("|");
            String baseData = decryStr.substring(0, position);
            String signData = decryStr.substring(position + 1);
            boolean verifyResult = GMSSLSM2SignUtils.verifyByBC((PublicKey)certificate.getPublicKey(), (String)GMSSLByteArrayUtils.base64Encode((byte[])baseData.getBytes()), (String)signData);
            if (verifyResult) {
                String[] licInfo = decryStr.split("\\|");
                DeviceLicense deviceLicense = new DeviceLicense();
                deviceLicense.setMaxCertCount(Integer.parseInt(licInfo[0]));
                deviceLicense.setBeginTime(sdf.parse(licInfo[1]));
                deviceLicense.setEndTime(sdf.parse(licInfo[2]));
                deviceLicense.setDeviceSn(licInfo[3]);
                deviceLicense.setSignature(licInfo[4]);
                deviceLicense.setFileName(licName);
                deviceLicense.setFileHash(licHash);
                logger.debug(deviceLicense.toString());
                return LicenseResult.success(deviceLicense);
            }
            return LicenseResult.failure();
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790license\u5931\u8d25 {}", (Object)e.getMessage());
            return LicenseResult.failure();
        }
    }

    public static String getCertPath() {
        String certPath = Thread.currentThread().getContextClassLoader().getResource("server.cer").getPath();
        logger.debug("Cert Path: {} ", (Object)certPath);
        String[] filePath = certPath.split(":");
        return filePath[filePath.length - 1];
    }

    private static String execShell(String[] cmd) {
        Runtime runtime = Runtime.getRuntime();
        String deviceInfo = null;
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(runtime.exec(cmd).getInputStream()));){
            deviceInfo = buffer.readLine();
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format("\u6267\u884cshell\u547d\u4ee4\u5931\u8d25 {0}", e.getMessage()));
        }
        return deviceInfo;
    }

    public static byte[] readByBinary(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inputStream = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            inputStream = new FileInputStream(path);
            int c = 0;
            byte[] bytes = new byte[1024];
            while ((c = ((InputStream)inputStream).read(bytes)) != -1) {
                baos.write(bytes, 0, c);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u4e8c\u8fdb\u5236\u5185\u5bb9\u5f02\u5e38 {}", (Object)e.getMessage());
            throw new RuntimeException(MessageFormat.format("\u8bfb\u53d6\u6587\u4ef6\u4e8c\u8fdb\u5236\u5185\u5bb9\u5f02\u5e38 {}", e.getMessage()));
        }
        finally {
            try {
                if (null != inputStream) {
                    ((InputStream)inputStream).close();
                }
                if (null != baos) {
                    baos.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38 {}", (Object)e.getMessage());
            }
        }
    }

    public static String md5(File file) {
        return DecryptUtils.hash("MD5", file);
    }

    private static String hash(String algorithm, File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            return DecryptUtils.hash(algorithm, fileInputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String hash(String algorithm, FileInputStream fileInputStream) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = fileInputStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, length);
            }
            byte[] bytes = messageDigest.digest();
            String string = DecryptUtils.toHex(bytes);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String toHex(byte[] bytes) {
        StringBuilder ret = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(HEX_DIGITS[bytes[i] >> 4 & 0xF]);
            ret.append(HEX_DIGITS[bytes[i] & 0xF]);
        }
        return ret.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509Certificate getX509CertificateFromPath(String path) throws Exception {
        X509Certificate x509Certificate;
        File certF = DecryptUtils.getFileFromPath(path);
        FileInputStream is = null;
        try {
            X509Certificate certificate;
            is = new FileInputStream(certF);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
            x509Certificate = certificate = (X509Certificate)certificateFactory.generateCertificate(is);
        }
        catch (Exception e) {
            try {
                System.err.println(MessageFormat.format("\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38 {0}", e.getMessage()));
                throw new Exception("\u83b7\u53d6\u8bc1\u4e66\u5f02\u5e38", e);
            }
            catch (Throwable throwable) {
                try {
                    if (null == is) throw throwable;
                    ((InputStream)is).close();
                    throw throwable;
                }
                catch (Exception e2) {
                    System.err.println(MessageFormat.format("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38 {0}", e2.getMessage()));
                }
                throw throwable;
            }
        }
        try {
            if (null == is) return x509Certificate;
            ((InputStream)is).close();
            return x509Certificate;
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38 {0}", e.getMessage()));
        }
        return x509Certificate;
    }

    private static File getFileFromPath(String path) {
        URL systemResource = ClassLoader.getSystemResource(path);
        String filePath = systemResource != null ? systemResource.getPath() : path;
        return new File(filePath);
    }

    public static String decryptWithSM4(String data) {
        try {
            return new String(DecryptUtils.formatData(false, Base64.decode((String)data)));
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format("\u6570\u636e\u5e93\u672a\u91c7\u7528\u52a0\u5bc6\u65b9\u5f0f\u5b58\u50a8:{0}", e.getMessage()));
            return data;
        }
    }

    private static byte[] formatData(boolean isEncrypt, byte[] data) throws Exception {
        String SAFE_SECRET_STRING = "XDJA-PKI";
        String PADDING_NAME = "SM4/ECB/PKCS5Padding";
        String SM4_ALGORITHM = "SM4";
        Cipher cipher = Cipher.getInstance(PADDING_NAME, "BC");
        SecretKeySpec keySpec = new SecretKeySpec(DecryptUtils.getPassword().getBytes(), SM4_ALGORITHM);
        cipher.init(isEncrypt ? 1 : 2, keySpec);
        return cipher.doFinal(data);
    }

    private static String getPassword() {
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update("XDJA-PKI".getBytes(), 0, "XDJA-PKI".getBytes().length);
        byte[] out = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(out, 0);
        String p = Base64.toBase64String((byte[])out);
        return p.substring(0, 6) + p.substring(p.length() - 10);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

