/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.license.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeUtil {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeUtil.class);
    private static final String PATTERN_ONE = "yyyy-MM-dd HH:mm:ss";
    private static final String PATTERN_TWO = "yyyy-MM-dd";
    static final String pattern = "yyyyMMddHHmmss";
    public static final long ONE_DAY_TIME = 86400000L;
    public static final long SECONDS_PER_HOUR = 3600L;
    public static final long MILLS_PER_HOUR = 3600000L;

    public static int compare(Date date1, Date date2) {
        long compareResult = date1.getTime() - date2.getTime();
        if (compareResult > 0L) {
            return 1;
        }
        if (compareResult == 0L) {
            return 0;
        }
        return -1;
    }

    public static Date getPrevHour(int diff) {
        return DateTimeUtil.getPrevDate(DateTime.now(), diff);
    }

    public static Date getPrevDate(DateTime date, int diff) {
        if (null == date) {
            throw new IllegalArgumentException("\u53c2\u6570dateTime\u4e0d\u80fd\u4e3anull");
        }
        return date.minusHours(diff).toDate();
    }

    public static Date getPrevDate() {
        return DateTimeUtil.getPrevDate(DateTime.now().toDate());
    }

    public static Date getPrevDate(Date date) {
        if (null == date) {
            throw new IllegalArgumentException("\u53c2\u6570date\u4e0d\u80fd\u4e3anull");
        }
        return new DateTime((Object)date).minusDays(1).toDate();
    }

    public static Date getNextDate() {
        return DateTimeUtil.getNextDate(DateTime.now().toDate());
    }

    public static Date getNextDate(Date date) {
        if (null == date) {
            throw new IllegalArgumentException("\u53c2\u6570date\u4e0d\u80fd\u4e3anull");
        }
        return new DateTime((Object)date).plusDays(1).toDate();
    }

    public static String getWeek(Date date) {
        return new SimpleDateFormat("EEEE", Locale.CHINESE).format(date);
    }

    public static Date dateStrToDate(String dateStr) {
        return DateTime.parse((String)dateStr).toDate();
    }

    public static Date longToDate(long time) {
        return new DateTime(time).toDate();
    }

    public static String longToDateStr(long time) {
        return DateTimeUtil.longToDateStr(time, null);
    }

    public static String longToDateStr(long time, String pattern) {
        if (time == 0L) {
            return "\uff0d\uff0d";
        }
        return DateTimeUtil.dateToStr(DateTimeUtil.longToDate(time), pattern);
    }

    public static String dateToStr(Date date, String pattern) {
        return new SimpleDateFormat(StringUtils.isNotBlank((CharSequence)pattern) ? pattern : PATTERN_ONE).format(date);
    }

    public static String dateToZipStr(Date date) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String dateToStr(Date date) {
        return DateTimeUtil.dateToStr(date, PATTERN_ONE);
    }

    public static String dateToWebStr(Date date) {
        return DateTimeUtil.dateToStr(date, PATTERN_ONE);
    }

    public static long dateTimeStrToLong(String dateTimeStr, boolean isEndTime) {
        long result = DateTimeUtil.dateTimeStrToLong(dateTimeStr);
        return isEndTime ? result + 999L : result;
    }

    public static long dateTimeStrToLong(String dateTimeStr) {
        return DateTime.parse((String)dateTimeStr, (DateTimeFormatter)DateTimeFormat.forPattern((String)PATTERN_ONE)).getMillis();
    }

    public static long ymdDateTimeStrToLong(String dateTimeStr) {
        return DateTime.parse((String)dateTimeStr, (DateTimeFormatter)DateTimeFormat.forPattern((String)PATTERN_TWO)).getMillis();
    }

    public static long getStartTime(String startTime) {
        return DateTimeUtil.dateTimeStrToLong(startTime + " 00:00:00");
    }

    public static long getEndTime(String endTime) {
        return DateTimeUtil.dateTimeStrToLong(endTime + " 23:59:59", true);
    }

    public static Long getCurrentTime() {
        return DateTimeUtils.currentTimeMillis();
    }

    public static Date intToDate(int dateTime, String formatStr) {
        SimpleDateFormat simpledateformat = new SimpleDateFormat(formatStr);
        Date date = null;
        try {
            date = simpledateformat.parse(String.valueOf(dateTime));
        }
        catch (ParseException e) {
            logger.error("\u8f6c\u63628\u4f4dint\uff0820110101\uff09\u7684\u65f6\u95f4\u503c\u4e3a\u65e5\u671f\u578b\u51fa\u9519", (Throwable)e);
        }
        return date;
    }

    public static Date strToDate(String dateTime, String formatStr) {
        SimpleDateFormat simpledateformat = new SimpleDateFormat(formatStr);
        Date date = null;
        try {
            date = simpledateformat.parse(String.valueOf(dateTime));
        }
        catch (ParseException e) {
            logger.error("\u8f6c\u63628\u4f4dint\uff0820110101\uff09\u7684\u65f6\u95f4\u503c\u4e3a\u65e5\u671f\u578b\u51fa\u9519", (Throwable)e);
        }
        return date;
    }

    public static Date strToDate(String dateTime) {
        return DateTimeUtil.strToDate(dateTime, PATTERN_ONE);
    }
}

