/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.license.util;

import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.license.util.DateTimeUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.util.encoders.Base64;

public class EncryptUtils {
    public static void generateLicense(String certNum, String beginTime, String endTime, String deviceSn, String licensePath) throws Exception {
        StringBuffer licenseStr = new StringBuffer();
        long beginTimeL = DateTimeUtil.ymdDateTimeStrToLong(beginTime);
        long endTimeL = DateTimeUtil.ymdDateTimeStrToLong(endTime);
        if (endTimeL < beginTimeL) {
            System.err.println("Params Error\uff1a " + beginTime + " is not earlier than " + endTime);
            System.exit(-1);
        }
        licenseStr.append(certNum);
        licenseStr.append("|");
        licenseStr.append(beginTime);
        licenseStr.append("|");
        licenseStr.append(endTime);
        licenseStr.append("|");
        licenseStr.append(deviceSn);
        String content = GMSSLByteArrayUtils.base64Encode((byte[])licenseStr.toString().getBytes());
        String jksPath = EncryptUtils.getJksPath();
        String signature = GMSSLSM2SignUtils.signByBC((PrivateKey)EncryptUtils.readCaServerPrivateKey(jksPath), (String)content);
        licenseStr.append("|");
        licenseStr.append(signature);
        System.out.println("before encrypt: " + licenseStr.toString());
        String licStr = EncryptUtils.encryptWithSM4ToString(licenseStr.toString());
        System.out.println("after encrypt: " + licStr);
        EncryptUtils.saveFile(GMSSLByteArrayUtils.base64Decode((String)licStr), licensePath);
    }

    private static String getJksPath() {
        StringBuffer pathSb = new StringBuffer();
        String projectPath = System.getProperty("user.dir");
        System.out.println("user.dir : " + projectPath);
        pathSb.append(projectPath).append(File.separator).append("lib").append(File.separator).append("caServerSignCert.jks");
        return pathSb.toString();
    }

    private static PrivateKey readCaServerPrivateKey(String jksPath) throws Exception {
        String password = EncryptUtils.getCertJKSPassword();
        String aliasName = "server_sign";
        return EncryptUtils.getPriKeyByAliasFromP12(aliasName, jksPath, password);
    }

    private static String getCertJKSPassword() throws Exception {
        byte[] b = GMSSLSM3DigestUtils.digest((byte[])"XDJA-PKI".getBytes());
        String jksPWD = GMSSLByteArrayUtils.base64Encode((byte[])b);
        return jksPWD.substring(0, 2) + jksPWD.substring(jksPWD.length() - 8);
    }

    private static PrivateKey getPriKeyByAliasFromP12(String alias, String saveFilePath, String keyStorePwd) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("pkcs12", "BC");
        keyStore.load(new FileInputStream(saveFilePath), keyStorePwd.toCharArray());
        String alias1 = null;
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            alias1 = aliases.nextElement();
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias1, keyStorePwd.toCharArray());
        return privateKey;
    }

    private static String encryptWithSM4ToString(String sourceData) throws Exception {
        String SAFE_SECRET_STRING = "XDJA-PKI";
        String PADDING_NAME = "SM4/ECB/PKCS5Padding";
        String SM4_ALGORITHM = "SM4";
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(SAFE_SECRET_STRING.getBytes(), 0, SAFE_SECRET_STRING.getBytes().length);
        byte[] out = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(out, 0);
        String p = Base64.toBase64String((byte[])out);
        String password = p.substring(0, 6) + p.substring(p.length() - 10);
        Cipher cipher = Cipher.getInstance(PADDING_NAME, "BC");
        SecretKeySpec keySpec = new SecretKeySpec(password.getBytes(), SM4_ALGORITHM);
        String srcData = sourceData;
        cipher.init(1, keySpec);
        byte[] encryptDataBytes = cipher.doFinal(srcData.getBytes());
        String encryptData = Base64.toBase64String((byte[])encryptDataBytes);
        return encryptData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFile(byte[] content, String path) throws Exception {
        OutputStream out = null;
        try {
            File file = new File(path);
            File fileParent = file.getParentFile();
            if (!fileParent.exists() && !fileParent.mkdirs()) {
                System.err.println("\u521b\u5efa\u7236\u6587\u4ef6\u5f02\u5e38");
                throw new Exception("\u521b\u5efa\u7236\u6587\u4ef6\u5f02\u5e38");
            }
            if (file.exists() && !file.delete()) {
                System.err.println("\u5220\u9664\u6587\u4ef6\u5f02\u5e38");
                throw new Exception("\u5220\u9664\u6587\u4ef6\u5f02\u5e38");
            }
            if (!file.createNewFile()) {
                System.err.println("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38");
                throw new Exception("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38");
            }
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                out = new FileOutputStream(new File(path), false);
                ByteArrayInputStream is = new ByteArrayInputStream(content);
                byte[] buff = new byte[1024];
                int len = 0;
                while ((len = is.read(buff)) != -1) {
                    out.write(buff, 0, len);
                }
                ((InputStream)is).close();
                out.close();
                // ** MonitorExit[var5_7] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            System.err.println("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38");
            throw new Exception("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38");
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    System.err.println("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38");
                }
            }
        }
        {
            return;
        }
    }
}

