/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.location;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.distance.DistanceOp;

public class AreaCityQuery {
    public static final AreaCityQuery[] Instances = new AreaCityQuery[]{new AreaCityQuery(), new AreaCityQuery(), new AreaCityQuery(), new AreaCityQuery(), new AreaCityQuery(), new AreaCityQuery(), new AreaCityQuery(), new AreaCityQuery(), new AreaCityQuery(), new AreaCityQuery()};
    private static Pattern Exp_PointDistanceID = Pattern.compile("\"PointDistanceID[\\s\":]+(\\d+)");
    private static Pattern Exp_OkGeoCsv_Deep = Pattern.compile("\"deep[\\s\":]+(\\d+)");
    public static final String Version = "1.0";
    public int SetGridFactor = 100;
    public int SetInitUseThreadMax = 5;
    public boolean SetInitStoreInMemoryUseObject = false;
    public Func<QueryInitInfo, Boolean> OnInitProgress;
    private QueryInitInfo InitInfo;
    public static GeometryFactory Factory = new GeometryFactory(new PrecisionModel(), 4326);
    private int[] InitLock = new int[]{0};
    private boolean ReadFromMemory;
    private String WkbsFilePath;
    private STRtree EnvelopeSTRTree;
    private List<HashMap<String, Object>> WKTDataStores;
    private HashMap<String, ArrayList<Integer>> LineSubsPos;
    private static final String WKB_SP_Prop = "|Prop:";
    private static final String WKB_SP_Pos = "|Pos:";
    private static final String WKB_SP_WKB = "|WKB:";

    public QueryResult QueryPoint(double lng, double lat, Func<String, Boolean> where, QueryResult res) throws Exception {
        this.CheckInitIsOK();
        return this.QueryGeometry((Geometry)Factory.createPoint(new Coordinate(lng, lat)), where, res);
    }

    public QueryResult QueryPointWithTolerance(double lng, double lat, Func<String, Boolean> where, QueryResult res, int toleranceMetre) throws Exception {
        this.CheckInitIsOK();
        if (res != null && res.Result == null) {
            throw new Exception("\u4e0d\u652f\u6301\u65e0Result\u8c03\u7528");
        }
        int resLen0 = res == null ? 0 : res.Result.size();
        final Point point = Factory.createPoint(new Coordinate(lng, lat));
        QueryResult res1 = this.QueryGeometry((Geometry)point, where, res);
        if (res1.Result.size() > resLen0 || toleranceMetre == 0) {
            return res1;
        }
        Geometry geom = toleranceMetre > 0 ? AreaCityQuery.CreateSimpleCircle(lng, lat, toleranceMetre, 24) : AreaCityQuery.CreateRect(-180.0, -90.0, 180.0, 90.0);
        final HashMap propDists = new HashMap();
        final HashMap deepDists = new HashMap();
        final DecimalFormat df = new DecimalFormat("0.00");
        --res1.QueryCount;
        res1 = this.QueryGeometryProcess(geom, where, res1, new Func<Object[], Boolean>(){

            @Override
            public Boolean Exec(Object[] args) throws Exception {
                Matcher m;
                String deep;
                Object[] deepExists;
                boolean add = false;
                String prop = (String)args[0];
                Geometry geom = (Geometry)args[1];
                String lineNo = (String)args[2];
                Coordinate[] ps = DistanceOp.nearestPoints((Geometry)geom, (Geometry)point);
                double dist = AreaCityQuery.Distance(ps[0].x, ps[0].y, ps[1].x, ps[1].y);
                Double exists = (Double)propDists.get(lineNo);
                if ((exists == null || exists > dist) && ((deepExists = (Object[])deepDists.get(deep = (m = Exp_OkGeoCsv_Deep.matcher(prop)).find() ? m.group(1) : "")) == null || (Double)deepExists[0] > dist)) {
                    add = true;
                    propDists.put(lineNo, dist);
                    deepDists.put(deep, new Object[]{dist, lineNo});
                    prop = prop.substring(0, prop.length() - 1) + ", \"PointDistanceID\": " + lineNo + ", \"PointDistance\": " + df.format(dist) + "}";
                    args[0] = prop;
                }
                return add;
            }
        });
        HashSet<String> ids = new HashSet<String>();
        HashSet<String> exists = new HashSet<String>();
        for (Object[] o : deepDists.values()) {
            ids.add((String)o[1]);
        }
        for (int i = res1.Result.size() - 1; i >= resLen0; --i) {
            String prop = res1.Result.get(i);
            Matcher m = Exp_PointDistanceID.matcher(prop);
            m.find();
            String lineNo = m.group(1);
            if (!ids.contains(lineNo) || exists.contains(lineNo)) {
                res1.Result.remove(i);
                continue;
            }
            exists.add(lineNo);
        }
        return res1;
    }

    public QueryResult QueryGeometry(Geometry geom, Func<String, Boolean> where, QueryResult res) throws Exception {
        return this.QueryGeometryProcess(geom, where, res, null);
    }

    public QueryResult QueryGeometryProcess(Geometry geom, Func<String, Boolean> where, QueryResult res, Func<Object[], Boolean> process) throws Exception {
        boolean returnWkt;
        this.CheckInitIsOK();
        if (res == null) {
            res = new QueryResult();
        }
        ++res.QueryCount;
        long t_Start = System.nanoTime();
        if (res.StartTimeN == 0L) {
            res.StartTimeN = t_Start;
        }
        boolean bl = returnWkt = res.Set_ReturnWKTKey != null && res.Set_ReturnWKTKey.length() > 0;
        if (returnWkt && this.WkbsFilePath.length() == 0) {
            throw new Exception("Set_ReturnWKT\u9519\u8bef\uff0c\u521d\u59cb\u5316\u65f6\u5fc5\u987b\u4fdd\u5b58\u4e86wkbs\u7ed3\u6784\u5316\u6570\u636e\u6587\u4ef6\uff0c\u6216\u8005\u7528\u7684wkbs\u6587\u4ef6\u521d\u59cb\u5316\u7684\uff0c\u5426\u5219\u4e0d\u5141\u8bb8\u67e5\u8be2WKT\u6570\u636e");
        }
        List list = this.EnvelopeSTRTree.query(geom.getEnvelopeInternal());
        res.DurationN_EnvelopeHitQuery += System.nanoTime() - t_Start;
        res.EnvelopeHitCount += list.size();
        String matchLines = ",";
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            String prop;
            Map store = (Map)list.get(i);
            byte[] wkbSub = null;
            String[] wkbPos = this.getWkbPos(store);
            String lineNo = wkbPos[0];
            int fullPos = Integer.parseInt(wkbPos[1]);
            int subPos = Integer.parseInt(wkbPos[2]);
            if (process == null && matchLines.indexOf("," + lineNo + ",") != -1 || where != null && !where.Exec(this.getProp(store)).booleanValue()) continue;
            long t_IO = System.nanoTime();
            Geometry subGeom = null;
            if (this.ReadFromMemory) {
                if (this.SetInitStoreInMemoryUseObject) {
                    subGeom = (Geometry)store.get("wkb");
                } else {
                    wkbSub = (byte[])store.get("wkb");
                }
            } else {
                wkbSub = this.ReadWkbFromFile(subPos);
            }
            res.DurationN_IO += System.nanoTime() - t_IO;
            long t_GeometryParse = System.nanoTime();
            if (subGeom == null) {
                subGeom = new WKBReader(Factory).read(wkbSub);
            }
            res.DurationN_GeometryParse += System.nanoTime() - t_GeometryParse;
            long t_Exact = System.nanoTime();
            boolean isMatch = subGeom.intersects(geom);
            res.DurationN_ExactHitQuery += System.nanoTime() - t_Exact;
            if (isMatch) {
                prop = this.getProp(store);
                if (process != null) {
                    t_Exact = System.nanoTime();
                    Object[] args = new Object[]{prop, subGeom, lineNo};
                    if (!process.Exec(args).booleanValue()) {
                        isMatch = false;
                    } else {
                        prop = (String)args[0];
                    }
                    res.DurationN_ExactHitQuery += System.nanoTime() - t_Exact;
                }
                if (isMatch) {
                    if (returnWkt) {
                        t_IO = System.nanoTime();
                        byte[] wkbFull = this.ReadWkbFromFile(fullPos);
                        res.DurationN_IO += System.nanoTime() - t_IO;
                        t_GeometryParse = System.nanoTime();
                        Geometry fullGeom = new WKBReader(Factory).read(wkbFull);
                        res.DurationN_GeometryParse += System.nanoTime() - t_GeometryParse;
                        String wkt = new WKTWriter().write(fullGeom);
                        prop = prop.substring(0, prop.length() - 1) + ", \"" + res.Set_ReturnWKTKey + "\": \"" + wkt + "\"}";
                    }
                    if (res.Result != null) {
                        res.Result.add(prop);
                    }
                    ++res.ExactHitCount;
                    matchLines = matchLines + lineNo + ",";
                }
            }
            if (res.Set_EnvelopeHitResult == null) continue;
            prop = this.getProp(store);
            prop = "{\"_PolygonPointNum_\": " + subGeom.getNumPoints() + "," + prop.substring(1);
            res.Set_EnvelopeHitResult.add(prop);
        }
        res.EndTimeN = System.nanoTime();
        return res;
    }

    public QueryResult ReadWKT_FromWkbsFile(String wktKey, QueryResult res, Func<String, Boolean> where, Func<String[], Boolean> onFind) throws Exception {
        boolean returnWkt;
        this.CheckInitIsOK();
        if (res == null) {
            res = new QueryResult();
        }
        ++res.QueryCount;
        long t_Start = System.nanoTime();
        if (res.StartTimeN == 0L) {
            res.StartTimeN = t_Start;
        }
        res.Set_ReturnWKTKey = wktKey;
        boolean readWkt = returnWkt = res.Set_ReturnWKTKey != null && res.Set_ReturnWKTKey.length() > 0;
        if (onFind != null) {
            readWkt = true;
        }
        if (readWkt && this.WkbsFilePath.length() == 0) {
            throw new Exception("\u521d\u59cb\u5316\u65f6\u5fc5\u987b\u4fdd\u5b58\u4e86wkbs\u7ed3\u6784\u5316\u6570\u636e\u6587\u4ef6\uff0c\u6216\u8005\u7528\u7684wkbs\u6587\u4ef6\u521d\u59cb\u5316\u7684\uff0c\u5426\u5219\u4e0d\u5141\u8bb8\u67e5\u8be2WKT\u6570\u636e");
        }
        int iL = this.WKTDataStores.size();
        for (int i = 0; i < iL; ++i) {
            HashMap<String, Object> store = this.WKTDataStores.get(i);
            long t_Exact = System.nanoTime();
            String prop = this.getProp(store);
            boolean isFind = where.Exec(prop);
            res.DurationN_ExactHitQuery += System.nanoTime() - t_Exact;
            if (!isFind) continue;
            String wkt = null;
            if (readWkt) {
                byte[] wkbFull = null;
                if (!store.containsKey("empty")) {
                    String[] wkbPos = this.getWkbPos(store);
                    int fullPos = Integer.parseInt(wkbPos[1]);
                    long t_IO = System.nanoTime();
                    wkbFull = this.ReadWkbFromFile(fullPos);
                    res.DurationN_IO += System.nanoTime() - t_IO;
                }
                long t_GeometryParse = System.nanoTime();
                Object fullGeom = wkbFull != null ? new WKBReader(Factory).read(wkbFull) : Factory.createPolygon();
                wkt = new WKTWriter().write((Geometry)fullGeom);
                res.DurationN_GeometryParse += System.nanoTime() - t_GeometryParse;
            }
            boolean add = true;
            if (onFind != null) {
                add = onFind.Exec(new String[]{prop, wkt});
            }
            if (add && res.Result != null) {
                if (returnWkt) {
                    prop = prop.substring(0, prop.length() - 1) + ", \"" + res.Set_ReturnWKTKey + "\": \"" + wkt + "\"}";
                }
                res.Result.add(prop);
            }
            ++res.ExactHitCount;
        }
        res.EndTimeN = System.nanoTime();
        return res;
    }

    public QueryResult Debug_ReadGeometryGridSplitsWKT(String wktKey, QueryResult res, Func<String, Boolean> where, Func<String[], Boolean> onFind) throws Exception {
        boolean returnWkt;
        this.CheckInitIsOK();
        if (res == null) {
            res = new QueryResult();
        }
        ++res.QueryCount;
        long t_Start = System.nanoTime();
        if (res.StartTimeN == 0L) {
            res.StartTimeN = t_Start;
        }
        res.Set_ReturnWKTKey = wktKey;
        boolean readWkt = returnWkt = res.Set_ReturnWKTKey != null && res.Set_ReturnWKTKey.length() > 0;
        if (onFind != null) {
            readWkt = true;
        }
        if (readWkt && this.WkbsFilePath.length() == 0) {
            throw new Exception("\u521d\u59cb\u5316\u65f6\u5fc5\u987b\u4fdd\u5b58\u4e86wkbs\u7ed3\u6784\u5316\u6570\u636e\u6587\u4ef6\uff0c\u6216\u8005\u7528\u7684wkbs\u6587\u4ef6\u521d\u59cb\u5316\u7684\uff0c\u5426\u5219\u4e0d\u5141\u8bb8\u67e5\u8be2WKT\u6570\u636e");
        }
        int iL = this.WKTDataStores.size();
        for (int i = 0; i < iL; ++i) {
            HashMap<String, Object> store = this.WKTDataStores.get(i);
            long t_Exact = System.nanoTime();
            String prop = this.getProp(store);
            boolean isFind = where.Exec(prop);
            res.DurationN_ExactHitQuery += System.nanoTime() - t_Exact;
            if (!isFind) continue;
            String wkt = null;
            if (readWkt) {
                String[] wkbPos = this.getWkbPos(store);
                ArrayList<Integer> subs = this.LineSubsPos.get(wkbPos[0]);
                if (subs == null) continue;
                ArrayList<Polygon> pols = new ArrayList<Polygon>();
                int i2L = subs.size();
                for (int i2 = 0; i2 < i2L; ++i2) {
                    long t_IO = System.nanoTime();
                    byte[] wkb = this.ReadWkbFromFile(subs.get(i2));
                    res.DurationN_IO += System.nanoTime() - t_IO;
                    long t_GeometryParse = System.nanoTime();
                    Geometry subGeom = new WKBReader(Factory).read(wkb);
                    if (subGeom instanceof Polygon) {
                        pols.add((Polygon)subGeom);
                    } else {
                        int i3L = subGeom.getNumGeometries();
                        for (int i3 = 0; i3 < i3L; ++i3) {
                            pols.add((Polygon)subGeom.getGeometryN(i3));
                        }
                    }
                    res.DurationN_GeometryParse += System.nanoTime() - t_GeometryParse;
                }
                Object geom = pols.size() == 0 ? Factory.createPolygon() : Factory.createMultiPolygon(pols.toArray(new Polygon[0]));
                wkt = new WKTWriter().write((Geometry)geom);
            }
            boolean add = true;
            if (onFind != null) {
                add = onFind.Exec(new String[]{prop, wkt});
            }
            if (add && res.Result != null) {
                if (returnWkt) {
                    prop = prop.substring(0, prop.length() - 1) + ", \"" + res.Set_ReturnWKTKey + "\": \"" + wkt + "\"}";
                }
                res.Result.add(prop);
            }
            ++res.ExactHitCount;
        }
        res.EndTimeN = System.nanoTime();
        return res;
    }

    public void Init_StoreInMemory(String dataFilePath, String saveWkbsFilePath, boolean autoUseExistsWkbsFile) {
        this.__Init(autoUseExistsWkbsFile, dataFilePath, saveWkbsFilePath, true);
    }

    public void Init_StoreInWkbsFile(String dataFilePath, String saveWkbsFilePath, boolean autoUseExistsWkbsFile) {
        this.__Init(autoUseExistsWkbsFile, dataFilePath, saveWkbsFilePath, false);
    }

    public int GetInitStatus() {
        return this.InitLock[0];
    }

    public void CheckInitIsOK() throws Exception {
        if (this.InitLock[0] == 3) {
            throw new Exception(this.InitInfo.ErrMsg);
        }
        if (this.InitLock[0] != 2) {
            throw new Exception("\u9700\u8981\u5148Init\u5b8c\u6210\u540e\uff0c\u518d\u6765\u8fdb\u884c\u67e5\u8be2\u8c03\u7528");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ResetInitStatus() {
        int[] nArray = this.InitLock;
        synchronized (this.InitLock) {
            this.InitLock[0] = 0;
            this.EnvelopeSTRTree = null;
            this.WKTDataStores = null;
            this.LineSubsPos = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean IsStoreInMemory() {
        return this.GetInitStatus() == 2 && this.ReadFromMemory;
    }

    public boolean IsStoreInWkbsFile() {
        return this.GetInitStatus() == 2 && !this.ReadFromMemory;
    }

    public QueryInitInfo GetInitInfo() {
        return this.InitInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __Init(boolean autoUseExistsWkbsFile, String dataFilePath, String saveWkbsFilePath, boolean readFromMemory) {
        if (this.InitLock[0] >= 2) {
            return;
        }
        int[] nArray = this.InitLock;
        synchronized (this.InitLock) {
            if (this.InitLock[0] >= 2) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            FileOutputStream fw = null;
            FileInputStream fr = null;
            BufferedReader read = null;
            this.InitLock[0] = 1;
            try {
                this.InitInfo = new QueryInitInfo();
                this.InitInfo.StartTimeN = System.nanoTime();
                this.InitInfo.StartMemory_System = AreaCityQuery.GetMemory_System();
                this.InitInfo.StartMemory_JavaRuntime = AreaCityQuery.GetMemory_JavaRuntime();
                this.ReadFromMemory = readFromMemory;
                this.WkbsFilePath = "";
                dataFilePath = dataFilePath == null ? "" : dataFilePath;
                String string = saveWkbsFilePath = saveWkbsFilePath == null ? "" : saveWkbsFilePath;
                if (saveWkbsFilePath.length() > 0) {
                    this.WkbsFilePath = saveWkbsFilePath;
                } else if (AreaCityQuery.IsWkbsFilePath(dataFilePath)) {
                    this.WkbsFilePath = dataFilePath;
                } else if (!this.ReadFromMemory) {
                    throw new Exception("Init_StoreInWkbsFile\u4f20\u5165\u975ewkbs\u6587\u4ef6\u65f6\uff0c\u5fc5\u987b\u63d0\u4f9bsaveWkbsFilePath");
                }
                if (saveWkbsFilePath.length() > 0) {
                    if (!AreaCityQuery.IsWkbsFilePath(saveWkbsFilePath)) {
                        throw new Exception("saveWkbsFilePath\u5fc5\u987b\u662f.wkbs\u7ed3\u5c3e");
                    }
                    if (AreaCityQuery.IsWkbsFilePath(dataFilePath)) {
                        throw new Exception("dataFilePath\u662f.wkbs\u6587\u4ef6\u65f6\uff0c\u4e0d\u5141\u8bb8\u518d\u63d0\u4f9bsaveWkbsFilePath");
                    }
                    if (autoUseExistsWkbsFile && this.AvailableWkbsFile(saveWkbsFilePath)) {
                        dataFilePath = saveWkbsFilePath;
                        saveWkbsFilePath = "";
                    }
                }
                this.InitInfo.DataFromWkbsFile = AreaCityQuery.IsWkbsFilePath(dataFilePath);
                this.InitInfo.HasWkbsFile = this.WkbsFilePath.length() > 0;
                this.InitInfo.FilePath_Data = dataFilePath;
                this.InitInfo.FilePath_SaveWkbs = saveWkbsFilePath;
                fr = new FileInputStream(dataFilePath);
                read = new BufferedReader(new InputStreamReader((InputStream)fr, "utf-8"));
                if (saveWkbsFilePath.length() > 0) {
                    fw = new FileOutputStream(saveWkbsFilePath);
                }
                this.__InitProcess(dataFilePath, read, saveWkbsFilePath, fw);
                this.EnvelopeSTRTree.build();
                this.InitLock[0] = 2;
            }
            catch (Exception e) {
                this.InitInfo.ErrMsg = "\u521d\u59cb\u5316\u53d1\u751f\u5f02\u5e38\uff1a" + AreaCityQuery.ErrorStack(e);
                this.InitLock[0] = 3;
            }
            finally {
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (read != null) {
                        read.close();
                    }
                }
                catch (Exception e) {}
                long t_gc = System.nanoTime();
                System.gc();
                this.InitInfo.DurationN_JavaGC = System.nanoTime() - t_gc;
                this.InitInfo.CurrentLine_No = 0;
                this.InitInfo.CurrentLine_Text = "";
                this.InitInfo.CurrentLine_Prop = "";
                this.InitInfo.EndTimeN = System.nanoTime();
                this.InitInfo.EndMemory_System = AreaCityQuery.GetMemory_System();
                this.InitInfo.EndMemory_JavaRuntime = AreaCityQuery.GetMemory_JavaRuntime();
            }
            if (this.OnInitProgress != null) {
                try {
                    this.OnInitProgress.Exec(this.InitInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private void __InitProcess(final String dataFilePath, final BufferedReader dataFile, String saveWkbsFilePath, final FileOutputStream saveWkbsFile) throws Exception {
        int i2;
        final Exception[] threadError = new Exception[]{null};
        final STRtree rtree = new STRtree();
        final ArrayList<HashMap<String, Object>> wktDataStores = new ArrayList<HashMap<String, Object>>();
        final ArrayList emptyGeoms = new ArrayList();
        final HashMap lineSubsPos = new HashMap();
        final boolean isWkbsFile = AreaCityQuery.IsWkbsFilePath(dataFilePath);
        final String IsStartErrMsg = "\u672a\u8bc6\u522b\u5230geojson|wkbs\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u521d\u59cb\u5316\u4f20\u5165\u7684\u6587\u4ef6\u662f\u5426\u6b63\u786e\u3002\u6ce8\u610f\uff1a\u5982\u679c\u662fgeojson\u6587\u4ef6\uff0c\u8981\u6c42\u91cc\u9762\u6570\u636e\u5fc5\u987b\u662f\u4e00\u884c\u4e00\u6761\u6570\u636e\uff0c\u7b2c\u4e00\u6761\u6570\u636e\u7684\u4e0a\u4e00\u884c\u5fc5\u987b\u662f`\"features\": [`\uff0c\u6700\u540e\u4e00\u6761\u6570\u636e\u7684\u4e0b\u4e00\u884c\u5fc5\u987b\u662f`]`\u6253\u5934\uff0c\u5426\u5219\u4e0d\u652f\u6301\u89e3\u6790\uff0c\u53ef\u5c1d\u8bd5\u7528\u6587\u672c\u7f16\u8f91\u5668\u6279\u91cf\u66ff\u6362\u6dfb\u52a0\u6362\u884c\u7b26\u3002";
        final boolean[] IsStart = new boolean[]{false};
        final boolean[] IsEnd = new boolean[]{false};
        final int[] LineNo = new int[]{0};
        final HashMap Strings = new HashMap();
        final int[] saveWkbsFileLength = new int[]{0};
        final Func<String, Object> SaveWkbsWrite = new Func<String, Object>(){

            @Override
            public Object Exec(String val) throws Exception {
                byte[] bs = val.getBytes("utf-8");
                saveWkbsFileLength[0] = saveWkbsFileLength[0] + bs.length;
                saveWkbsFile.write(bs);
                return null;
            }
        };
        final Func<Object, Object> ThreadExec = new Func<Object, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String Exec(Object val) throws Exception {
                while (true) {
                    Geometry geomSrc;
                    String[] propStrPtr;
                    String propStr;
                    int i0;
                    int lineNo;
                    String line;
                    BufferedReader bufferedReader = dataFile;
                    synchronized (bufferedReader) {
                        if (threadError[0] != null) {
                            throw threadError[0];
                        }
                        if (IsEnd[0]) {
                            break;
                        }
                        long t_fr = System.nanoTime();
                        line = dataFile.readLine();
                        ((AreaCityQuery)AreaCityQuery.this).InitInfo.DurationN_FileRead += System.nanoTime() - t_fr;
                        if (line == null) {
                            if (!IsStart[0]) {
                                throw new Exception(IsStartErrMsg);
                            }
                            if (!IsEnd[0]) {
                                throw new Exception("\u521d\u59cb\u5316\u4f20\u5165\u7684\u6587\u4ef6\u672a\u53d1\u73b0\u7ed3\u675f\u4f4d\u7f6e\uff0c\u53ef\u80fd\u6587\u4ef6\u5df2\u635f\u574f");
                            }
                            break;
                        }
                        lineNo = LineNo[0] = LineNo[0] + 1;
                        if ((line = line.trim()).length() == 0) {
                            continue;
                        }
                        if (IsStart[0] && line.charAt(0) == ']') {
                            IsEnd[0] = true;
                            break;
                        }
                        if (!IsStart[0]) {
                            int fIdx = line.indexOf("\"features\"");
                            if (fIdx == 0 || fIdx > 0 && fIdx >= line.length() - 14) {
                                if (!line.endsWith("[")) {
                                    throw new Exception("\u521d\u59cb\u5316\u4f20\u5165\u7684\u6587\u4ef6\u7b2c" + lineNo + "\u884c\u98ce\u683c\u4e0d\u5bf9\uff0c\u4e0d\u652f\u6301\u5904\u7406\u6b64\u6587\u4ef6");
                                }
                                IsStart[0] = true;
                                if (saveWkbsFile != null) {
                                    SaveWkbsWrite.Exec("/*******************\n\u672cwkbs\u6587\u4ef6\u662f\u7531 " + AreaCityQuery.class.getTypeName() + " \u751f\u6210\uff0c\u4e3a\u4e13\u7528\u7684\u7ed3\u6784\u5316\u6570\u636e\u6587\u4ef6\uff0c\u7528\u4e8e\u8fb9\u754c\u56fe\u5f62\u6570\u636e\u52a0\u901f\u89e3\u6790\u3002\n@Version: " + AreaCityQuery.Version + "\n@GridFactor: " + AreaCityQuery.this.SetGridFactor + "\n@\u6570\u636e\u6587\u4ef6: " + dataFilePath + "\n@\u751f\u6210\u65f6\u95f4: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\n\nGitHub: https://github.com/xiangyuecn/AreaCity-Query-Geometry \uff08github\u53ef\u6362\u6210gitee\uff09\n\u7701\u5e02\u533a\u53bf\u4e61\u9547\u533a\u5212\u8fb9\u754c\u6570\u636e: https://github.com/xiangyuecn/AreaCity-JsSpider-StatsGov \uff08github\u53ef\u6362\u6210gitee\uff09\n*******************/\n\n\"features\": [");
                                }
                            }
                            continue;
                        }
                    }
                    long r_t1 = System.nanoTime();
                    String wkbPosStr = lineNo + ":0:0";
                    boolean wkbTypeIsParent = false;
                    boolean wkbTypeIsSub = false;
                    boolean wkbTypeIsEmpty = false;
                    int wkbIdx = 0;
                    if (isWkbsFile) {
                        i0 = line.indexOf(AreaCityQuery.WKB_SP_Pos);
                        String wkbType = line.substring(0, i0);
                        if (wkbType.equals("Sub")) {
                            wkbTypeIsSub = true;
                        } else if (!wkbType.equals("Full")) {
                            if (wkbType.equals("Parent")) {
                                wkbTypeIsParent = true;
                            } else if (wkbType.equals("Empty")) {
                                wkbTypeIsEmpty = true;
                            }
                        }
                        int i1 = line.indexOf(AreaCityQuery.WKB_SP_Prop, i0 += AreaCityQuery.WKB_SP_Pos.length());
                        wkbPosStr = line.substring(i0, i1);
                        int i2 = line.indexOf(AreaCityQuery.WKB_SP_WKB, i1 += AreaCityQuery.WKB_SP_Prop.length());
                        propStr = line.substring(i1, i2);
                        wkbIdx = i2 + AreaCityQuery.WKB_SP_WKB.length();
                    } else {
                        i0 = line.indexOf("properties\"");
                        int i1 = line.indexOf("{", i0);
                        int i2 = line.indexOf("}", i0);
                        propStr = line.substring(i1, i2 + 1);
                    }
                    String typeStr = "";
                    if (!isWkbsFile) {
                        int iGeom = line.indexOf("geometry\"");
                        int i02 = line.indexOf("type\"", iGeom);
                        int i1 = line.indexOf("\"", i02 + 5);
                        int i2 = line.indexOf("\"", i1 + 1);
                        typeStr = line.substring(i1 + 1, i2);
                    }
                    QueryInitInfo iGeom = AreaCityQuery.this.InitInfo;
                    synchronized (iGeom) {
                        ((AreaCityQuery)AreaCityQuery.this).InitInfo.DurationN_FileParse += System.nanoTime() - r_t1;
                        ((AreaCityQuery)AreaCityQuery.this).InitInfo.CurrentLine_No = lineNo;
                        ((AreaCityQuery)AreaCityQuery.this).InitInfo.CurrentLine_Text = line;
                        ((AreaCityQuery)AreaCityQuery.this).InitInfo.CurrentLine_Prop = propStr;
                        if (AreaCityQuery.this.OnInitProgress != null && !AreaCityQuery.this.OnInitProgress.Exec(AreaCityQuery.this.InitInfo).booleanValue()) {
                            continue;
                        }
                        propStrPtr = (String[])Strings.get(propStr);
                        if (propStrPtr == null) {
                            propStrPtr = new String[]{propStr};
                            Strings.put(propStr, propStrPtr);
                        }
                    }
                    if (isWkbsFile && !wkbTypeIsSub) {
                        iGeom = AreaCityQuery.this.InitInfo;
                        synchronized (iGeom) {
                            ++((AreaCityQuery)AreaCityQuery.this).InitInfo.GeometryCount;
                        }
                        if (!wkbTypeIsEmpty) {
                            HashMap<String, Object> store = new HashMap<String, Object>();
                            store.put("prop", propStrPtr);
                            store.put("wkbPos", wkbPosStr);
                            List list = wktDataStores;
                            synchronized (list) {
                                wktDataStores.add(store);
                            }
                        }
                        if (wkbTypeIsParent) continue;
                    }
                    long r_t2 = System.nanoTime();
                    if (isWkbsFile) {
                        byte[] wkb = AreaCityQuery.Hex2Bytes(line, wkbIdx);
                        geomSrc = new WKBReader(Factory).read(wkb);
                    } else {
                        if (!typeStr.equals("Polygon") && !typeStr.equals("MultiPolygon")) {
                            throw new Exception("\u521d\u59cb\u5316\u4f20\u5165\u7684\u6587\u4ef6\u7b2c" + lineNo + "\u884c" + typeStr + "\u6570\u636e\u4e0d\u662fPolygon\u7c7b\uff0c\u8981\u6c42\u5fc5\u987b\u662fPolygon\u6216\u8005MultiPolygon\uff0c\u5e76\u4e14json\u6587\u4ef6\u5185\u4e00\u6761\u6570\u636e\u4e00\u884c");
                        }
                        geomSrc = AreaCityQuery.JSONLineParse(Factory, line);
                    }
                    QueryInitInfo wkb = AreaCityQuery.this.InitInfo;
                    synchronized (wkb) {
                        ((AreaCityQuery)AreaCityQuery.this).InitInfo.DurationN_GeometryParse += System.nanoTime() - r_t2;
                        if (!isWkbsFile) {
                            ++((AreaCityQuery)AreaCityQuery.this).InitInfo.GeometryCount;
                        }
                        if (geomSrc.isEmpty()) {
                            HashMap<String, Object> store = new HashMap<String, Object>();
                            store.put("prop", propStrPtr);
                            store.put("wkbPos", wkbPosStr);
                            store.put("empty", true);
                            emptyGeoms.add(store);
                            continue;
                        }
                    }
                    long r_t3 = System.nanoTime();
                    Geometry geomGrid = geomSrc;
                    if (!isWkbsFile) {
                        geomGrid = AreaCityQuery.GeometryGridSplit(Factory, geomSrc, AreaCityQuery.this.SetGridFactor);
                    }
                    int wkbMemoryLen = 0;
                    int polygonNum = 1;
                    if (geomGrid instanceof MultiPolygon) {
                        polygonNum = geomGrid.getNumGeometries();
                    }
                    int parentPos = 0;
                    if (polygonNum > 1 && saveWkbsFile != null) {
                        byte[] wkb2 = new WKBWriter().write(geomSrc);
                        FileOutputStream fileOutputStream = saveWkbsFile;
                        synchronized (fileOutputStream) {
                            parentPos = saveWkbsFileLength[0] + 1;
                            String wkbPos = lineNo + ":" + parentPos + ":" + parentPos;
                            SaveWkbsWrite.Exec("\nParent|Pos:" + wkbPos + AreaCityQuery.WKB_SP_Prop + propStr + AreaCityQuery.WKB_SP_WKB + AreaCityQuery.Bytes2Hex(wkb2));
                        }
                    }
                    for (int i03 = 0; i03 < polygonNum; ++i03) {
                        Polygon polygon = geomGrid instanceof MultiPolygon ? (Polygon)geomGrid.getGeometryN(i03) : (Polygon)geomGrid;
                        byte[] wkb3 = null;
                        String wkbPos = lineNo + ":0:0";
                        if (saveWkbsFile != null) {
                            FileOutputStream fileOutputStream = saveWkbsFile;
                            synchronized (fileOutputStream) {
                                wkbPos = saveWkbsFileLength[0] + 1 + "";
                                String type = "Sub";
                                if (polygonNum == 1) {
                                    type = "Full";
                                    wkbPos = wkbPos + ":" + wkbPos;
                                } else {
                                    wkbPos = parentPos + ":" + wkbPos;
                                }
                                wkbPos = lineNo + ":" + wkbPos;
                                wkb3 = new WKBWriter().write((Geometry)polygon);
                                SaveWkbsWrite.Exec("\n" + type + AreaCityQuery.WKB_SP_Pos + wkbPos + AreaCityQuery.WKB_SP_Prop + propStr + AreaCityQuery.WKB_SP_WKB + AreaCityQuery.Bytes2Hex(wkb3));
                            }
                        }
                        HashMap<String, Object> store = new HashMap<String, Object>();
                        store.put("prop", propStrPtr);
                        if (AreaCityQuery.this.ReadFromMemory) {
                            if (AreaCityQuery.this.SetInitStoreInMemoryUseObject) {
                                store.put("wkb", polygon);
                            } else {
                                if (wkb3 == null) {
                                    wkb3 = new WKBWriter().write((Geometry)polygon);
                                }
                                wkbMemoryLen += wkb3.length;
                                store.put("wkb", wkb3);
                            }
                        }
                        if (isWkbsFile) {
                            wkbPos = wkbPosStr;
                        }
                        store.put("wkbPos", wkbPos);
                        String[] wkbPosArr = AreaCityQuery.this.getWkbPos(store);
                        Object object = rtree;
                        synchronized (object) {
                            rtree.insert(polygon.getEnvelopeInternal(), store);
                            ArrayList<Integer> subs = (ArrayList<Integer>)lineSubsPos.get(wkbPosArr[0]);
                            if (subs == null) {
                                subs = new ArrayList<Integer>();
                                lineSubsPos.put(wkbPosArr[0], subs);
                            }
                            subs.add(Integer.parseInt(wkbPosArr[2]));
                        }
                        if (i03 != 0 || isWkbsFile) continue;
                        object = wktDataStores;
                        synchronized (object) {
                            wktDataStores.add(store);
                            continue;
                        }
                    }
                    QueryInitInfo queryInitInfo = AreaCityQuery.this.InitInfo;
                    synchronized (queryInitInfo) {
                        ((AreaCityQuery)AreaCityQuery.this).InitInfo.DurationN_Index += System.nanoTime() - r_t3;
                        if (AreaCityQuery.this.ReadFromMemory) {
                            if (((AreaCityQuery)AreaCityQuery.this).InitInfo.WkbMemory == -1) {
                                ((AreaCityQuery)AreaCityQuery.this).InitInfo.WkbMemory = 0;
                            }
                            ((AreaCityQuery)AreaCityQuery.this).InitInfo.WkbMemory += wkbMemoryLen;
                        }
                        ((AreaCityQuery)AreaCityQuery.this).InitInfo.PolygonCount += polygonNum;
                    }
                }
                return null;
            }
        };
        final int[] threadCount = new int[]{Math.max(1, Math.min(this.SetInitUseThreadMax, Runtime.getRuntime().availableProcessors() - 1))};
        this.InitInfo.UseThreadCount = threadCount[0];
        for (i2 = 0; i2 < threadCount[0]; ++i2) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ThreadExec.Exec(null);
                    }
                    catch (Exception e) {
                        if (threadError[0] == null) {
                            threadError[0] = e;
                        }
                    }
                    finally {
                        int[] nArray = threadCount;
                        synchronized (threadCount) {
                            threadCount[0] = threadCount[0] - 1;
                            // ** MonitorExit[var1_3] (shouldn't be in output)
                        }
                    }
                }
            }).start();
        }
        while (threadCount[0] > 0) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception i2) {}
        }
        if (threadError[0] != null) {
            throw threadError[0];
        }
        if (!IsStart[0]) {
            throw new Exception(IsStartErrMsg);
        }
        if (this.InitInfo.GeometryCount == 0) {
            throw new Exception("\u521d\u59cb\u5316\u4f20\u5165\u7684\u6587\u4ef6\u5185\u6ca1\u6709\u6570\u636e");
        }
        int iL = emptyGeoms.size();
        for (i2 = 0; i2 < iL; ++i2) {
            HashMap store = (HashMap)emptyGeoms.get(i2);
            wktDataStores.add(store);
            if (saveWkbsFile == null) continue;
            String propStr = this.getProp(store);
            String lineNo = this.getWkbPos(store)[0];
            String wkbPos = saveWkbsFileLength[0] + 1 + "";
            wkbPos = lineNo + ":" + wkbPos + ":" + wkbPos;
            store.put("wkbPos", wkbPos);
            byte[] wkb = new WKBWriter().write((Geometry)Factory.createPolygon());
            SaveWkbsWrite.Exec("\nEmpty|Pos:" + wkbPos + WKB_SP_Prop + propStr + WKB_SP_WKB + AreaCityQuery.Bytes2Hex(wkb));
        }
        if (saveWkbsFile != null) {
            SaveWkbsWrite.Exec("\n]");
        }
        this.LineSubsPos = lineSubsPos;
        this.WKTDataStores = wktDataStores;
        this.EnvelopeSTRTree = rtree;
    }

    private String getProp(Map<String, Object> store) {
        return ((String[])store.get("prop"))[0];
    }

    private String[] getWkbPos(Map<String, Object> store) {
        String str = (String)store.get("wkbPos");
        int p0 = str.indexOf(58);
        int p1 = str.indexOf(58, p0 + 1);
        return new String[]{str.substring(0, p0), str.substring(p0 + 1, p1), str.substring(p1 + 1)};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean AvailableWkbsFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return false;
        }
        try (FileInputStream in = new FileInputStream(path);){
            byte[] buffer = new byte[8192];
            int len = in.read(buffer);
            String txt = new String(buffer, "utf-8");
            if (!txt.contains("@Version: 1.0\n")) {
                boolean bl = false;
                return bl;
            }
            if (!txt.contains("@GridFactor: " + this.SetGridFactor + "\n")) {
                boolean bl = false;
                return bl;
            }
            in.skip(-len);
            in.skip(file.length() - 1L);
            boolean bl = in.read() == 93;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    private byte[] ReadWkbFromFile(int pos) throws Exception {
        try (FileInputStream in = new FileInputStream(this.WkbsFilePath);){
            in.skip(pos);
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            byte[] buffer = new byte[32768];
            int len = 0;
            boolean isStart = false;
            int findLen = 0;
            char[] FindChars = WKB_SP_WKB.toCharArray();
            while ((len = in.read(buffer)) != -1) {
                int i0 = 0;
                if (!isStart) {
                    for (int i = 0; i < len; ++i) {
                        if (buffer[i] == FindChars[0]) {
                            findLen = 1;
                            continue;
                        }
                        if (findLen == 0) continue;
                        if (buffer[i] == FindChars[findLen]) {
                            if (++findLen != FindChars.length) continue;
                            isStart = true;
                            i0 = i + 1;
                            break;
                        }
                        findLen = 0;
                    }
                }
                boolean isEnd = false;
                int i1 = len;
                for (int i = i0; i < len; ++i) {
                    if (buffer[i] != 10) continue;
                    isEnd = true;
                    i1 = i;
                    break;
                }
                if (i1 - i0 > 0) {
                    bs.write(buffer, i0, i1 - i0);
                }
                if (!isEnd) continue;
                byte[] byts = bs.toByteArray();
                if (byts.length % 2 == 1) {
                    throw new Exception("\u7ed3\u6784\u5316\u6570\u636e\u5185\u90e8\u5b58\u5728\u9519\u8bef");
                }
                byte[] byArray = AreaCityQuery.Hex2Bytes(byts, 0);
                return byArray;
            }
        }
        throw new Exception("\u7ed3\u6784\u5316\u6570\u636e\u6587\u4ef6\u5df2\u635f\u574f");
    }

    private static Geometry JSONLineParse(GeometryFactory factory, String line) {
        ArrayList<__ParsePolygon> multiPols = new ArrayList<__ParsePolygon>();
        int iGeom = line.indexOf("geometry\"");
        int i = line.indexOf("coordinates\"", iGeom);
        int L = line.length();
        while (i < L) {
            __ParsePolygon pr = new __ParsePolygon(factory, line, i);
            if (!pr.isFind) break;
            i = pr.lastIndex;
            multiPols.add(pr);
        }
        if (multiPols.size() == 1) {
            return ((__ParsePolygon)multiPols.get(0)).toPolygon(factory);
        }
        if (multiPols.size() > 1) {
            Polygon[] pols = new Polygon[multiPols.size()];
            int L2 = multiPols.size();
            for (int i2 = 0; i2 < L2; ++i2) {
                pols[i2] = ((__ParsePolygon)multiPols.get(i2)).toPolygon(factory);
            }
            return factory.createMultiPolygon(pols);
        }
        return factory.createPolygon();
    }

    private static Geometry GeometryGridSplit(GeometryFactory factory, Geometry geom, int gridFactor) {
        ArrayList<Polygon> pols = new ArrayList<Polygon>();
        if (geom instanceof Polygon) {
            AreaCityQuery.__PolygonGridSplit(factory, gridFactor, pols, (Polygon)geom);
        } else {
            int L = geom.getNumGeometries();
            for (int i = 0; i < L; ++i) {
                AreaCityQuery.__PolygonGridSplit(factory, gridFactor, pols, (Polygon)geom.getGeometryN(i));
            }
        }
        if (pols.size() == 1) {
            return (Geometry)pols.get(0);
        }
        return factory.createMultiPolygon(pols.toArray(new Polygon[0]));
    }

    private static void __PolygonGridSplit(GeometryFactory factory, int gridFactor, ArrayList<Polygon> pols, Polygon polygon) {
        int pointCount = polygon.getNumPoints();
        int gridPoint = (int)Math.round(1.0 * (double)pointCount / (double)gridFactor);
        if (gridPoint < 2) {
            pols.add(polygon);
            return;
        }
        Envelope box = polygon.getEnvelopeInternal();
        double width = box.getMaxX() - box.getMinX();
        double height = box.getMaxY() - box.getMinY();
        int gridX = 1;
        int gridY = 1;
        if (width / (height * 2.0) > 1.0) {
            ++gridX;
        } else {
            ++gridY;
        }
        double xStep = width / (double)gridX;
        double yStep = height / (double)gridY;
        double x_0 = box.getMinX();
        double y_00 = box.getMinY();
        double x_1 = box.getMaxX();
        double y_1 = box.getMaxY();
        while (x_0 - x_1 < -xStep / 2.0) {
            double x1;
            double x0 = x_0;
            x_0 = x1 = x_0 + xStep;
            double y_0 = y_00;
            while (y_0 - y_1 < -yStep / 2.0) {
                double y1;
                double y0 = y_0;
                y_0 = y1 = y_0 + yStep;
                Polygon gridItem = factory.createPolygon(new Coordinate[]{new Coordinate(x0, y0), new Coordinate(x0, y1), new Coordinate(x1, y1), new Coordinate(x1, y0), new Coordinate(x0, y0)});
                Geometry chunk = polygon.intersection((Geometry)gridItem);
                if (chunk.isEmpty()) continue;
                if (chunk instanceof Polygon) {
                    AreaCityQuery.__PolygonGridSplit(factory, gridFactor, pols, (Polygon)chunk);
                    continue;
                }
                int L2 = chunk.getNumGeometries();
                for (int i2 = 0; i2 < L2; ++i2) {
                    Geometry item = chunk.getGeometryN(i2);
                    if (!(item instanceof Polygon)) continue;
                    AreaCityQuery.__PolygonGridSplit(factory, gridFactor, pols, (Polygon)item);
                }
            }
        }
    }

    public static double Distance(double lng1, double lat1, double lng2, double lat2) {
        double d = Math.PI / 180;
        double f = lat1 * d;
        double h = lat2 * d;
        double i = lng2 * d - lng1 * d;
        double e = (1.0 - Math.cos(h - f) + (1.0 - Math.cos(i)) * Math.cos(f) * Math.cos(h)) / 2.0;
        return 1.2756274E7 * Math.asin(Math.sqrt(e));
    }

    public static Geometry CreateSimpleCircle(double lng, double lat, double radius, int pointCount) {
        double km = radius / 1000.0;
        double a = km < 5.0 ? 0.01 : (km < 50.0 ? 0.1 : (km < 500.0 ? 1.0 : 10.0));
        double b = AreaCityQuery.Distance(lng, lat, lng + a, lat);
        double c = AreaCityQuery.Distance(lng, lat, lng, lat + a);
        double rb = radius / b * a;
        double rc = radius / c * a;
        Coordinate[] arr = new Coordinate[pointCount + 1];
        double step = 360.0 / (double)pointCount;
        double N = 360.0 - step / 2.0;
        int i = 0;
        for (double n = 0.0; n < N; n += step) {
            double x = lng + rb * Math.cos(n * Math.PI / 180.0);
            double y = lat + rc * Math.sin(n * Math.PI / 180.0);
            arr[i] = new Coordinate(x, y);
            ++i;
        }
        arr[pointCount] = arr[0];
        return Factory.createPolygon(arr);
    }

    public static Geometry CreateRect(double lng1, double lat1, double lng2, double lat2) {
        return Factory.createPolygon(new Coordinate[]{new Coordinate(lng1, lat1), new Coordinate(lng1, lat2), new Coordinate(lng2, lat2), new Coordinate(lng2, lat1), new Coordinate(lng1, lat1)});
    }

    private static boolean IsWkbsFilePath(String path) {
        return path.toLowerCase().endsWith(".wkbs");
    }

    private static String Bytes2Hex(byte[] bytes) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int b1 = b >> 4 & 0xF;
            int b2 = b & 0xF;
            str.append((char)(b1 <= 9 ? 48 + b1 : 65 + b1 - 10));
            str.append((char)(b2 <= 9 ? 48 + b2 : 65 + b2 - 10));
        }
        return str.toString();
    }

    private static byte[] Hex2Bytes(String hex, int start) {
        byte[] val = new byte[(hex.length() - start) / 2];
        int i = start;
        int n = 0;
        int len = hex.length();
        while (i < len) {
            int c1 = hex.charAt(i++);
            int c2 = hex.charAt(i++);
            int n2 = c1 < 65 ? c1 - 48 : (c1 = c1 < 97 ? c1 - 65 + 10 : c1 - 97 + 10);
            c2 = c2 < 65 ? c2 - 48 : (c2 < 97 ? c2 - 65 + 10 : c2 - 97 + 10);
            val[n] = (byte)(c1 << 4 | c2);
            ++n;
        }
        return val;
    }

    private static byte[] Hex2Bytes(byte[] hex, int start) {
        byte[] val = new byte[(hex.length - start) / 2];
        int i = start;
        int n = 0;
        int len = hex.length;
        while (i < len) {
            int c1 = hex[i++];
            int c2 = hex[i++];
            int n2 = c1 < 65 ? c1 - 48 : (c1 = c1 < 97 ? c1 - 65 + 10 : c1 - 97 + 10);
            c2 = c2 < 65 ? c2 - 48 : (c2 < 97 ? c2 - 65 + 10 : c2 - 97 + 10);
            val[n] = (byte)(c1 << 4 | c2);
            ++n;
        }
        return val;
    }

    private static String ErrorStack(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private static String Nano(double nanoTime) {
        String ts = nanoTime / 1000000.0 + "";
        BigDecimal big = new BigDecimal(ts);
        String s = ts.split("\\.")[1];
        int c = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) > '0') {
                c += 2;
                break;
            }
            ++c;
        }
        big = big.setScale(c, RoundingMode.HALF_UP);
        return big.toString() + "ms";
    }

    private static String Memory(long memory) {
        return memory / 1024L / 1024L + "MB";
    }

    private static long GetMemory_System() {
        try {
            OperatingSystemMXBean osMX = ManagementFactory.getOperatingSystemMXBean();
            Method totalFn = osMX.getClass().getMethod("getTotalPhysicalMemorySize", new Class[0]);
            totalFn.setAccessible(true);
            Method freeFn = osMX.getClass().getMethod("getFreePhysicalMemorySize", new Class[0]);
            freeFn.setAccessible(true);
            return (Long)totalFn.invoke((Object)osMX, new Object[0]) - (Long)freeFn.invoke((Object)osMX, new Object[0]);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private static long GetMemory_JavaRuntime() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static class QueryResult {
        public ArrayList<String> Result = new ArrayList();
        public long StartTimeN;
        public long EndTimeN;
        public long DurationN_IO;
        public long DurationN_GeometryParse;
        public long DurationN_EnvelopeHitQuery;
        public long DurationN_ExactHitQuery;
        public int EnvelopeHitCount;
        public int ExactHitCount;
        public int QueryCount;
        public ArrayList<String> Set_EnvelopeHitResult = null;
        public String Set_ReturnWKTKey = null;

        public void Add(QueryResult other) {
            this.StartTimeN = Math.min(this.StartTimeN, other.StartTimeN);
            this.EndTimeN = Math.max(this.EndTimeN, other.EndTimeN);
            this.DurationN_IO += other.DurationN_IO;
            this.DurationN_GeometryParse += other.DurationN_GeometryParse;
            this.DurationN_EnvelopeHitQuery += other.DurationN_EnvelopeHitQuery;
            this.DurationN_ExactHitQuery += other.DurationN_ExactHitQuery;
            this.EnvelopeHitCount += other.EnvelopeHitCount;
            this.ExactHitCount += other.ExactHitCount;
            this.QueryCount += other.QueryCount;
        }

        public String toString() {
            String txt;
            StringBuilder str = new StringBuilder();
            long tn = this.EndTimeN - this.StartTimeN;
            str.append("\u67e5\u8be2" + this.QueryCount + "\u6b21\u5171\u8017\u65f6: " + AreaCityQuery.Nano(tn));
            str.append("\uff0cEnvelopeHitCount: " + this.EnvelopeHitCount);
            str.append("\uff0cExactHitCount: " + this.ExactHitCount);
            str.append("\uff0cIO: " + AreaCityQuery.Nano(this.DurationN_IO));
            str.append("\uff0cGeometryParse: " + AreaCityQuery.Nano(this.DurationN_GeometryParse));
            str.append("\uff0cEnvelopeHitQuery: " + AreaCityQuery.Nano(this.DurationN_EnvelopeHitQuery));
            str.append("\uff0cExactHitQuery: " + AreaCityQuery.Nano(this.DurationN_ExactHitQuery));
            if (this.QueryCount > 1) {
                double count = this.QueryCount;
                str.append("\n\u5355\u6b21\u67e5\u8be2\u8017\u65f6: " + AreaCityQuery.Nano((double)tn / count));
                str.append("\uff0cEnvelopeHitCount: " + (double)Math.round((double)(this.EnvelopeHitCount * 100) / count) / 100.0);
                str.append("\uff0cExactHitCount: " + (double)Math.round((double)(this.ExactHitCount * 100) / count) / 100.0);
                str.append("\uff0cIO: " + AreaCityQuery.Nano((double)this.DurationN_IO / count));
                str.append("\uff0cGeometryParse: " + AreaCityQuery.Nano((double)this.DurationN_GeometryParse / count));
                str.append("\uff0cEnvelopeHitQuery: " + AreaCityQuery.Nano((double)this.DurationN_EnvelopeHitQuery / count));
                str.append("\uff0cExactHitQuery: " + AreaCityQuery.Nano((double)this.DurationN_ExactHitQuery / count));
            }
            if (this.Set_EnvelopeHitResult != null) {
                str.append("\n\nEnvelopeHit\u521d\u6b65\u7b5b\u9009: " + this.Set_EnvelopeHitResult.size() + "\u6761");
                for (int i = 0; i < this.Set_EnvelopeHitResult.size(); ++i) {
                    txt = this.Set_EnvelopeHitResult.get(i);
                    str.append("\nHit[" + i + "] " + (txt.length() < 500 ? txt : txt.substring(0, 500) + " ... " + txt.length() + "\u5b57"));
                }
            }
            if (this.Result != null) {
                str.append("\n\n\u7ed3\u679c Result: " + this.Result.size() + "\u6761");
                for (int i = 0; i < this.Result.size(); ++i) {
                    txt = this.Result.get(i);
                    str.append("\n\u7ed3\u679c[" + i + "] " + (txt.length() < 500 ? txt : txt.substring(0, 500) + " ... " + txt.length() + "\u5b57"));
                }
            }
            return str.toString();
        }
    }

    public static class QueryInitInfo {
        public long StartTimeN;
        public long EndTimeN;
        public long StartMemory_System;
        public long EndMemory_System;
        public long StartMemory_JavaRuntime;
        public long EndMemory_JavaRuntime;
        public int UseThreadCount = 1;
        public int CurrentLine_No;
        public String CurrentLine_Text = "";
        public String CurrentLine_Prop = "";
        public int GeometryCount;
        public int PolygonCount;
        public int WkbMemory = -1;
        public long DurationN_FileRead;
        public long DurationN_FileParse;
        public long DurationN_GeometryParse;
        public long DurationN_Index;
        public long DurationN_JavaGC;
        public String FilePath_Data;
        public String FilePath_SaveWkbs;
        public boolean DataFromWkbsFile;
        public boolean HasWkbsFile;
        public String ErrMsg = "";

        public boolean hasError() {
            return this.ErrMsg != null && this.ErrMsg.length() > 0;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("[v1.0]" + (this.DataFromWkbsFile ? "wkbs+" : "") + "\u5df2\u8bfb\u53d6Geometry " + this.GeometryCount + " \u4e2a\uff08Grid\u5207\u5206Polygon " + this.PolygonCount + " \u4e2a\uff09");
            if (this.hasError()) {
                String errT = "\n=============\n";
                str.append(errT + this.ErrMsg + errT);
            }
            str.append("\n");
            long tn = this.EndTimeN - this.StartTimeN;
            str.append("Init\u603b\u8017\u65f6: " + tn / 1000000L + "ms");
            str.append("\uff0c\u5e73\u5747: " + (this.GeometryCount == 0 ? "-" : AreaCityQuery.Nano((double)tn * 1.0 / (double)this.GeometryCount)) + "/\u4e2aGeometry\uff0c\u7ebf\u7a0b\u6570: " + this.UseThreadCount);
            if (this.WkbMemory != -1) {
                str.append("\nWKB\u5185\u5b58: " + AreaCityQuery.Memory(this.WkbMemory));
            }
            str.append("\n\u6587\u4ef6\u8bfb\u53d6\u8017\u65f6: " + AreaCityQuery.Nano(this.DurationN_FileRead));
            str.append("\n\u6587\u4ef6\u89e3\u6790\u8017\u65f6: " + AreaCityQuery.Nano(this.DurationN_FileParse / (long)this.UseThreadCount) + "/\u7ebf\u7a0b\uff0c\u603b: " + AreaCityQuery.Nano(this.DurationN_FileParse));
            str.append("\n\u521b\u5efa\u56fe\u5f62\u8017\u65f6: " + AreaCityQuery.Nano(this.DurationN_GeometryParse / (long)this.UseThreadCount) + "/\u7ebf\u7a0b\uff0c\u603b: " + AreaCityQuery.Nano(this.DurationN_GeometryParse));
            str.append("\n\u521b\u5efa\u7d22\u5f15\u8017\u65f6: " + AreaCityQuery.Nano(this.DurationN_Index / (long)this.UseThreadCount) + "/\u7ebf\u7a0b\uff0c\u603b: " + AreaCityQuery.Nano(this.DurationN_Index));
            str.append("\n\u5185\u5b58\u5360\u7528: " + AreaCityQuery.Memory(this.EndMemory_JavaRuntime - this.StartMemory_JavaRuntime) + " (Java Runtime)");
            str.append(", " + AreaCityQuery.Memory(this.EndMemory_System - this.StartMemory_System) + " (\u7cfb\u7edf)");
            str.append(", Java GC\u8017\u65f6: " + AreaCityQuery.Nano(this.DurationN_JavaGC));
            str.append("\nData\u6587\u4ef6: " + this.FilePath_Data);
            str.append("\nWkbs\u6587\u4ef6: " + this.FilePath_SaveWkbs);
            return str.toString();
        }
    }

    private static class __ParsePolygon {
        public boolean isFind;
        public int lastIndex;
        private LinearRing ring0;
        private ArrayList<LinearRing> ringX = new ArrayList();

        public __ParsePolygon(GeometryFactory factory, String line, int index) {
            int i0;
            ArrayList<Coordinate> points = new ArrayList<Coordinate>();
            boolean isStart = false;
            int multiEnds = 0;
            int polEnds = 0;
            int Li = line.length();
            for (i0 = index; i0 < Li; ++i0) {
                char c = line.charAt(i0);
                if (c == ' ') continue;
                if (c == '}') break;
                if (!isStart) {
                    if (c != '[') continue;
                    isStart = true;
                    continue;
                }
                if (c == ']') {
                    if (++polEnds == 2) {
                        LinearRing ring = factory.createLinearRing(points.toArray(new Coordinate[0]));
                        if (this.ring0 == null) {
                            this.ring0 = ring;
                        } else {
                            this.ringX.add(ring);
                        }
                        points = new ArrayList();
                    }
                    if (++multiEnds != 3) continue;
                    ++i0;
                    break;
                }
                polEnds = 0;
                multiEnds = 0;
                if (c == ',' || c == '[') continue;
                StringBuilder lng = new StringBuilder();
                StringBuilder lat = new StringBuilder();
                while (i0 < Li) {
                    c = line.charAt(i0);
                    if (c != ' ') {
                        if (c == ',') {
                            ++i0;
                            break;
                        }
                        lng.append(c);
                    }
                    ++i0;
                }
                while (i0 < Li) {
                    c = line.charAt(i0);
                    if (c != ' ') {
                        if (c == ']') {
                            --i0;
                            break;
                        }
                        lat.append(c);
                    }
                    ++i0;
                }
                points.add(new Coordinate(Double.parseDouble(lng.toString()), Double.parseDouble(lat.toString())));
            }
            this.lastIndex = i0;
            this.isFind = this.ring0 != null;
        }

        public Polygon toPolygon(GeometryFactory factory) {
            if (this.ring0 == null) {
                return factory.createPolygon();
            }
            LinearRing[] holes = null;
            if (this.ringX.size() > 0) {
                holes = this.ringX.toArray(new LinearRing[0]);
            }
            return factory.createPolygon(this.ring0, holes);
        }
    }

    public static interface Func<iT, oT> {
        public oT Exec(iT var1) throws Exception;
    }
}

