/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.location.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.xdja.pki.location.util.JSONException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class JsonMapper {
    private static final JsonMapper alwaysMapper = new JsonMapper();
    private static final JsonMapper nonEmptyMapper = new JsonMapper(JsonInclude.Include.NON_EMPTY);
    private static final JsonMapper nonNullMapper = new JsonMapper(JsonInclude.Include.NON_NULL);
    private static final JsonMapper nonDefaultMapper = new JsonMapper(JsonInclude.Include.NON_DEFAULT);
    private ObjectMapper mapper = new ObjectMapper();

    public static JsonMapper alwaysMapper() {
        return alwaysMapper;
    }

    public static JsonMapper nonEmptyMapper() {
        return nonEmptyMapper;
    }

    public static JsonMapper nonNullMapper() {
        return nonNullMapper;
    }

    public static JsonMapper nonDefaultMapper() {
        return nonDefaultMapper;
    }

    private JsonMapper() {
        this(null);
    }

    private JsonMapper(JsonInclude.Include include) {
        if (include != null) {
            this.mapper.setSerializationInclusion(include);
        }
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        this.mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this.mapper.getFactory().enable(JsonParser.Feature.ALLOW_COMMENTS);
        this.mapper.getFactory().enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
    }

    public <T> T fromJson(InputStream jsonInputStream, TypeReference<T> type) throws JSONException {
        try {
            return (T)this.mapper.readValue(jsonInputStream, type);
        }
        catch (Exception t) {
            throw new JSONException("\u628ajson\u8f93\u5165\u6d41\u4e2d\u7684\u5185\u5bb9\u8f6c\u6362\u4e3a\u6307\u5b9a\u7c7b\u578b\u7684\u5bf9\u8c61\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public <T> T fromJson(InputStream jsonInputStream, Class<T> clazz) throws JSONException {
        try {
            return (T)this.mapper.readValue(jsonInputStream, clazz);
        }
        catch (Exception t) {
            throw new JSONException("\u628ajson\u8f93\u5165\u6d41\u4e2d\u7684\u5185\u5bb9\u8f6c\u6362\u4e3a\u6307\u5b9a\u7c7b\u578b\u7684\u5bf9\u8c61\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public <T> T fromJson(byte[] jsonByteArray, TypeReference<T> type) throws JSONException {
        try {
            return (T)this.mapper.readValue(jsonByteArray, type);
        }
        catch (Exception t) {
            throw new JSONException("\u628ajson\u5b57\u8282\u6570\u7ec4\u8f6c\u6362\u4e3a\u6307\u5b9a\u7c7b\u578b\u7684\u5bf9\u8c61\u662f\u51fa\u9519\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public <T> T fromJson(byte[] jsonByteArray, Class<T> clazz) throws JSONException {
        try {
            return (T)this.mapper.readValue(jsonByteArray, clazz);
        }
        catch (Exception t) {
            throw new JSONException("\u628ajson\u5b57\u8282\u6570\u7ec4\u8f6c\u6362\u4e3a\u6307\u5b9a\u7c7b\u578b\u7684\u5bf9\u8c61\u662f\u51fa\u9519\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public <T> T fromJson(String jsonString, TypeReference<T> type) throws JSONException {
        try {
            return (T)this.mapper.readValue(jsonString, type);
        }
        catch (Exception t) {
            throw new JSONException("\u628ajson\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u6307\u5b9a\u7c7b\u578b\u7684\u5bf9\u8c61\u51fa\u9519\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public <T> T fromJson(String jsonString, Class<T> clazz) throws JSONException {
        try {
            return (T)this.mapper.readValue(jsonString, clazz);
        }
        catch (Exception t) {
            throw new JSONException("\u628ajson\u5b57\u7b26\u4e32\u8f6c\u6362\u4e3a\u6307\u5b9a\u7c7b\u578b\u7684\u5bf9\u8c61\u51fa\u9519\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public <T> T fromJson(Object obj, TypeReference<T> type) throws JSONException {
        if (obj instanceof String) {
            return this.fromJson(obj.toString(), type);
        }
        try {
            return (T)this.mapper.convertValue(obj, type);
        }
        catch (Exception t) {
            throw new JSONException("\u628aobj\u8f6c\u6362\u4e3a\u6307\u5b9a\u7c7b\u578b\u7684\u5bf9\u8c61\u51fa\u9519\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public <T> T fromJson(Object obj, Class<T> clazz) throws JSONException {
        if (obj instanceof String) {
            return this.fromJson(obj.toString(), clazz);
        }
        try {
            return (T)this.mapper.convertValue(obj, clazz);
        }
        catch (Exception t) {
            throw new JSONException("\u628aobj\u8f6c\u6362\u4e3a\u6307\u5b9a\u5bf9\u8c61\u51fa\u9519\uff08" + t.getMessage() + ")", t);
        }
    }

    public <T> T fromJson(Reader reader, TypeReference<T> type) throws JSONException {
        try {
            return (T)this.mapper.readValue(reader, type);
        }
        catch (Exception t) {
            throw new JSONException("\u4ecereader\u4e2d\u8bfb\u53d6json\u4fe1\u606f\u5e76\u8f6c\u6362\u4e3a\u6307\u5b9a\u5bf9\u8c61\u51fa\u9519\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public <T> T fromJson(Reader reader, Class<T> clazz) throws JSONException {
        try {
            return (T)this.mapper.readValue(reader, clazz);
        }
        catch (Exception t) {
            throw new JSONException("\u4ecereader\u4e2d\u8bfb\u53d6json\u4fe1\u606f\u5e76\u8f6c\u6362\u4e3a\u6307\u5b9a\u5bf9\u8c61\u51fa\u9519\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public String toJson(Object obj) throws JSONException {
        if (obj == null) {
            return "{}";
        }
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (Exception t) {
            throw new JSONException("\u628aobj\u8f6c\u6362\u4e3ajson\u5b57\u7b26\u4e32\u51fa\u9519\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public byte[] toJsonBytes(Object obj) throws JSONException {
        if (obj == null) {
            return "{}".getBytes(Charset.forName("UTF-8"));
        }
        try {
            return this.mapper.writeValueAsBytes(obj);
        }
        catch (Exception t) {
            throw new JSONException("\u628aobj\u8f6c\u6362\u4e3ajson\u5b57\u7b26\u4e32\u51fa\u9519\uff08" + t.getMessage() + "\uff09", t);
        }
    }

    public String toJsonP(String functionName, Object object) throws JSONException {
        return this.toJson(new JSONPObject(functionName, object));
    }

    public void update(String jsonString, Object object) throws JSONException {
        try {
            this.mapper.readerForUpdating(object).readValue(jsonString);
        }
        catch (JsonProcessingException e) {
            throw new JSONException("\u66f4\u65b0json\u5b57\u7b26\u4e32\u5230\u5bf9\u8c61\u51fa\u9519\uff08" + e.getMessage() + "\uff09", e);
        }
        catch (IOException e) {
            throw new JSONException("\u66f4\u65b0json\u5b57\u7b26\u4e32\u5230\u5bf9\u8c61\u51fa\u9519\uff08" + e.getMessage() + "\uff09", e);
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

