/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.location;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.pki.location.AreaCityQuery;
import com.xdja.pki.location.bean.AreaLocationInfo;
import com.xdja.pki.location.util.JsonMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class AreaLocationUtil {
    private static final AtomicInteger COUNT = new AtomicInteger();
    private static final AtomicBoolean INIT_FLAG = new AtomicBoolean();

    public static final void init(String geoDataWkbsPath) {
        if (!INIT_FLAG.get()) {
            for (AreaCityQuery instance : AreaCityQuery.Instances) {
                instance.Init_StoreInWkbsFile(geoDataWkbsPath, null, true);
            }
            INIT_FLAG.set(true);
        }
    }

    public static final String queryPoint(double longitude, double latitude) throws Exception {
        AreaCityQuery.QueryResult queryResult = AreaLocationUtil.getInstance().QueryPoint(longitude, latitude, null, null);
        if (queryResult.Result.isEmpty()) {
            return null;
        }
        String[] addrArry = new String[3];
        Map data = null;
        for (String item : queryResult.Result) {
            int deepInt;
            data = JsonMapper.alwaysMapper().fromJson(item, new TypeReference<HashMap<String, String>>(){});
            String deepStr = (String)data.get("deep");
            String name = (String)data.get("name");
            if (null == deepStr || deepStr.length() == 0 || null == name || name.length() == 0 || (deepInt = Integer.valueOf(deepStr).intValue()) < 0 || deepInt > 3) continue;
            addrArry[deepInt] = name;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < addrArry.length; ++i) {
            if (null == addrArry[i] || addrArry[i].length() == 0) continue;
            result.append(addrArry[i]);
        }
        return result.length() == 0 ? null : result.toString();
    }

    public static final List<AreaLocationInfo> queryPointList(double longitude, double latitude) throws Exception {
        AreaCityQuery.QueryResult queryResult = AreaLocationUtil.getInstance().QueryPoint(longitude, latitude, null, null);
        if (queryResult.Result.isEmpty()) {
            return null;
        }
        ArrayList<AreaLocationInfo> result = new ArrayList<AreaLocationInfo>();
        AreaLocationInfo info = null;
        Map data = null;
        for (String item : queryResult.Result) {
            AreaLocationInfo.LevelEnum level;
            data = JsonMapper.alwaysMapper().fromJson(item, new TypeReference<HashMap<String, String>>(){});
            String code = (String)data.get("id");
            String deepStr = (String)data.get("deep");
            String name = (String)data.get("name");
            if (null == code || code.length() == 0 || null == deepStr || deepStr.length() == 0 || null == name || name.length() == 0 || null == (level = AreaLocationInfo.LevelEnum.convert(Integer.valueOf(deepStr)))) continue;
            info = new AreaLocationInfo();
            info.setCode(code);
            info.setName(name);
            info.setLevel(level.value);
            result.add(info);
        }
        return result;
    }

    private static final AreaCityQuery getInstance() throws Exception {
        if (!INIT_FLAG.get()) {
            throw new Exception("\u8bf7\u5148\u8fdb\u884cAreaLocationUtil\u5de5\u5177\u7c7b\u521d\u59cb\u5316");
        }
        int index = COUNT.getAndIncrement() % AreaCityQuery.Instances.length;
        return AreaCityQuery.Instances[index];
    }
}

