/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ocsp.issue;

import com.xdja.pki.ocsp.issue.ResponseTypeEnum;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.ocsp.ResponseBytes;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPHenceRespBuilder
extends OCSPRespBuilder {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public OCSPResp build(int status, Object response, int responseType) throws OCSPException {
        if (response == null) {
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), null));
        }
        if (response instanceof BasicOCSPResp) {
            DEROctetString octs;
            BasicOCSPResp r = (BasicOCSPResp)response;
            try {
                octs = new DEROctetString(r.getEncoded());
            }
            catch (IOException e) {
                throw new OCSPException("can't encode object.", (Throwable)e);
            }
            ResponseBytes rb = null;
            if (ResponseTypeEnum.ID_PKIX_OCSP.type == responseType) {
                rb = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp, (ASN1OctetString)octs);
            } else if (ResponseTypeEnum.ID_PKIX_OCSP_BASIC.type == responseType) {
                rb = new ResponseBytes(OCSPObjectIdentifiers.id_pkix_ocsp_basic, (ASN1OctetString)octs);
            } else {
                this.logger.error("\u4e0d\u652f\u6301\u7684OCSP\u54cd\u5e94\u7c7b\u578b");
                throw new OCSPException("unsupported response type");
            }
            return new OCSPResp(new OCSPResponse(new OCSPResponseStatus(status), rb));
        }
        throw new OCSPException("unknown response object");
    }
}

