/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.apache.client.result;

import com.xdja.pki.apache.client.core.ClientErrorBean;
import com.xdja.pki.apache.client.result.ClientResult;
import com.xdja.pki.core.json.JsonUtils;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptClientResult {
    protected static final transient Logger logger = LoggerFactory.getLogger(AdaptClientResult.class);

    public static ClientResult getResultFromClientResponse(CloseableHttpResponse response) throws IOException {
        ClientResult clientResult = new ClientResult();
        int statusCode = response.getStatusLine().getStatusCode();
        logger.info("========== \u6267\u884c\u8c03\u7528\u8fdc\u7a0b\u72b6\u6001\u7801\u3010" + statusCode + "\u3011");
        byte[] body = null;
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = EntityUtils.toByteArray((HttpEntity)entity);
        }
        if (statusCode != 200) {
            try {
                ClientErrorBean errorBean = (ClientErrorBean)JsonUtils.json2Object((String)new String(body), ClientErrorBean.class);
                logger.info("POST\u8bf7\u6c42========= CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u4fe1\u606f:" + statusCode + " ====== errorCode:" + errorBean.getErrorCode() + " ====== errorMsg:" + errorBean.getErrorMsg());
                clientResult.setCode(statusCode);
                clientResult.setClientErrorBean(errorBean);
                return clientResult;
            }
            catch (Exception e) {
                logger.error(" ========== \u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
                return clientResult;
            }
        }
        if (body.length != 0) {
            try {
                byte[] resp = Base64.decode((byte[])body);
                clientResult.setInfo(resp);
            }
            catch (Exception e) {
                clientResult.setInfo(body);
            }
        } else {
            clientResult.setInfo(null);
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return clientResult;
    }
}

