/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.apache.client.utils;

import com.xdja.pki.apache.client.core.ApacheHttpException;
import com.xdja.pki.apache.client.core.ClientKeyStoreConfig;
import com.xdja.pki.apache.client.core.KeyStroeConvertException;
import com.xdja.pki.gmssl.GMSSLContext;
import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.http.bean.GMSSLProtocol;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ApacheClientHttpUtils {
    protected static final transient Logger logger = LoggerFactory.getLogger(ApacheClientHttpUtils.class);
    public static volatile CloseableHttpClient client = null;
    private static HttpContext localContext = new BasicHttpContext();
    private static HttpClientContext context = HttpClientContext.adapt((HttpContext)localContext);
    private static RequestConfig requestConfig = null;

    public static CloseableHttpResponse sendApacheClientRequest(byte[] reqBody, Map<String, String> paramsMap, Map<String, String> headerMap, String url, String contentType, String protectionAlgName, boolean isHttps, String requestMethod, ClientKeyStoreConfig clientKeyStoreConfig) throws ApacheHttpException {
        CloseableHttpResponse clientResponse = ApacheClientHttpUtils.exeHttpsRequest(url, reqBody, paramsMap, headerMap, contentType, protectionAlgName, isHttps, requestMethod, clientKeyStoreConfig);
        return clientResponse;
    }

    private static CloseableHttpResponse exeHttpsRequest(String url, byte[] message, Map<String, String> paramsMap, Map<String, String> headerMap, String contentType, String signAlgName, boolean isHttps, String requestMethod, ClientKeyStoreConfig clientKeyStoreConfig) throws ApacheHttpException {
        ApacheClientHttpUtils.getClient(isHttps, signAlgName, clientKeyStoreConfig);
        CloseableHttpResponse response = null;
        try {
            URIBuilder uri = null;
            uri = isHttps ? new URIBuilder("https://" + url) : new URIBuilder("http://" + url);
            logger.info("\u5f53\u524d\u8bf7\u6c42\u7684url==========================" + uri.toString());
            HttpPost httpUriRequest = null;
            ByteArrayEntity bodyEntity = null;
            if ("post".equalsIgnoreCase(requestMethod)) {
                httpUriRequest = new HttpPost(uri.build());
                bodyEntity = new ByteArrayEntity(message);
                httpUriRequest.setEntity((HttpEntity)bodyEntity);
            } else {
                if (null != paramsMap && paramsMap.size() != 0) {
                    LinkedList<BasicNameValuePair> list = new LinkedList<BasicNameValuePair>();
                    for (Map.Entry<String, String> entry : paramsMap.entrySet()) {
                        BasicNameValuePair param = new BasicNameValuePair(entry.getKey(), entry.getValue());
                        list.add(param);
                    }
                    uri.setParameters(list);
                }
                if ("get".equalsIgnoreCase(requestMethod)) {
                    httpUriRequest = new HttpGet(uri.build());
                    ((HttpGet)httpUriRequest).setConfig(requestConfig);
                } else if ("put".equalsIgnoreCase(requestMethod)) {
                    httpUriRequest = new HttpPut(uri.build());
                    bodyEntity = new ByteArrayEntity(message);
                    ((HttpPut)httpUriRequest).setEntity((HttpEntity)bodyEntity);
                    ((HttpPut)httpUriRequest).setConfig(requestConfig);
                } else if ("delete".equalsIgnoreCase(requestMethod)) {
                    httpUriRequest = new HttpDelete(uri.build());
                    ((HttpDelete)httpUriRequest).setConfig(requestConfig);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                httpUriRequest.setHeader("content-type", contentType);
            }
            httpUriRequest.setHeader("timestamp", String.valueOf(System.currentTimeMillis()));
            if (!CollectionUtils.isEmpty(headerMap)) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    httpUriRequest.setHeader(entry.getKey(), entry.getValue());
                }
            }
            response = client.execute((HttpUriRequest)httpUriRequest);
        }
        catch (Exception e) {
            logger.error("apache\u53d1\u9001client\u8bf7\u6c42\u5f02\u5e38:", (Throwable)e);
            throw new ApacheHttpException("apache\u53d1\u9001client\u8bf7\u6c42\u5f02\u5e38");
        }
        return response;
    }

    private static SSLContext createVerifySSL(String signAlgName, ClientKeyStoreConfig clientKeyStoreConfig) throws ApacheHttpException {
        block11: {
            SSLContext sslcontext = null;
            if (StringUtils.isBlank((CharSequence)signAlgName)) {
                return sslcontext;
            }
            String algName = null;
            algName = "SM3withSM2".equalsIgnoreCase(signAlgName) ? GMSSLProtocol.GMSSLSDFYUNHSMv11.getValue() : GMSSLProtocol.TLSV12.getValue();
            KeyStore clientKeyStore = null;
            KeyStore trustKeyStore = null;
            try {
                if (clientKeyStoreConfig == null) {
                    sslcontext = "SM3withSM2".equalsIgnoreCase(signAlgName) ? GMSSLContext.getClientInstance((String)"GMSSLv1.1").getSslContext() : GMSSLContext.getClientInstance((String)"TLSv1.2").getSslContext();
                    X509TrustManager trustManager = new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
                            if (x509Certificates == null || x509Certificates.length < 1 || authType == null || authType.length() < 1) {
                                throw new IllegalArgumentException();
                            }
                            String subject = x509Certificates[0].getSubjectX500Principal().getName();
                            logger.info("Auto-trusted server certificate chain for: " + subject);
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    };
                    sslcontext.init(null, new TrustManager[]{trustManager}, null);
                    return sslcontext;
                }
                if (!StringUtils.isNotBlank((CharSequence)clientKeyStoreConfig.getTrustKeyStorePath()) || !StringUtils.isNotBlank((CharSequence)clientKeyStoreConfig.getTrustKeyStorePwd())) break block11;
                File tf = new File(clientKeyStoreConfig.getTrustKeyStorePath());
                if (tf.exists()) {
                    try {
                        trustKeyStore = ApacheClientHttpUtils.getKeyStore(clientKeyStoreConfig.getTrustKeyStorePath(), clientKeyStoreConfig.getTrustKeyStorePwd().toCharArray());
                    }
                    catch (Exception e) {
                        logger.error("ApacheClientHttpUtils.getKeyStore==========", (Throwable)e);
                        throw new KeyStroeConvertException("keyStore\u8f6c\u6362\u5931\u8d25\uff01");
                    }
                }
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{clientKeyStoreConfig.getClientKeyStorePath(), clientKeyStoreConfig.getClientKeyStorePwd()})) {
                    sslcontext = GMSSLContext.getClientInstance(clientKeyStore, null, (KeyStore)trustKeyStore, (String)algName).getSslContext();
                    return sslcontext;
                }
                File sf = new File(clientKeyStoreConfig.getClientKeyStorePath());
                if (sf.exists()) {
                    try {
                        clientKeyStore = ApacheClientHttpUtils.getKeyStore(clientKeyStoreConfig.getClientKeyStorePath(), clientKeyStoreConfig.getClientKeyStorePwd().toCharArray());
                    }
                    catch (Exception e) {
                        logger.error("ApacheClientHttpUtils.getKeyStore==========", (Throwable)e);
                        throw new KeyStroeConvertException("keyStore\u8f6c\u6362\u5931\u8d25\uff01");
                    }
                }
                sslcontext = GMSSLContext.getClientInstance(clientKeyStore, (char[])clientKeyStoreConfig.getClientKeyStorePwd().toCharArray(), (KeyStore)trustKeyStore, (String)algName).getSslContext();
                return sslcontext;
            }
            catch (Exception e) {
                logger.error("ApacheClientHttpUtils.createVerifySSL==========", (Throwable)e);
                throw new ApacheHttpException("\u6784\u9020SSLContext\u5f02\u5e38");
            }
        }
        return null;
    }

    private static CloseableHttpClient getClient(boolean isHttps, String signAlgName, ClientKeyStoreConfig clientKeyStoreConfig) throws ApacheHttpException {
        Registry socketFactoryRegistry = null;
        if (client == null) {
            if (isHttps) {
                SSLContext sslcontext = null;
                sslcontext = ApacheClientHttpUtils.createVerifySSL(signAlgName, clientKeyStoreConfig);
                socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER)).build();
            } else {
                socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
            }
            PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connManager.setMaxTotal(500);
            connManager.setDefaultMaxPerRoute(500);
            ConnectionKeepAliveStrategy myStrategy = new ConnectionKeepAliveStrategy(){

                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                    while (it.hasNext()) {
                        HeaderElement he = it.nextElement();
                        String param = he.getName();
                        String value = he.getValue();
                        if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                        try {
                            return Long.parseLong(value) * 1000L;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                    return 30000L;
                }
            };
            client = HttpClients.custom().setKeepAliveStrategy(myStrategy).setConnectionManager((HttpClientConnectionManager)connManager).build();
            requestConfig = RequestConfig.custom().setConnectionRequestTimeout(600000).setSocketTimeout(200000).setConnectTimeout(600000).build();
        }
        return client;
    }

    private static KeyStore getKeyStore(String filePath, char[] pw) throws Exception {
        KeyStore keyStore;
        try {
            InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)filePath);
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(in, pw);
        }
        catch (Exception e) {
            try {
                InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)filePath);
                KeyStore keyStore2 = KeyStore.getInstance("BKS", "BC");
                keyStore2.load(in, pw);
            }
            catch (Exception e1) {
                InputStream in = GMSSLX509Utils.readInputStreamFromPath((String)filePath);
                KeyStore keyStore3 = KeyStore.getInstance("pkcs12", "BC");
                keyStore3.load(in, pw);
                return keyStore3;
            }
            throw new KeyStroeConvertException(e.getMessage());
        }
        return keyStore;
    }
}

