package com.xdja.pki.apache.client.result;

import com.xdja.pki.apache.client.core.ClientErrorBean;

import java.io.Serializable;

/**
 * 通用返回结果Bean
 *
 * @author syg
 */
public class ClientResult implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * true 成功  false失败
     */
    private Boolean isSuccess = true;

    /**
     * 执行结果
     */
    private int code;
    /**
     * 业务数据
     */
    private Object info;

    private ClientErrorBean clientErrorBean;

    public ClientErrorBean getClientErrorBean() {
        return clientErrorBean;
    }

    public void setClientErrorBean(ClientErrorBean clientErrorBean) {
        this.isSuccess=false;
        this.clientErrorBean = clientErrorBean;
    }

    /**
     * 无参构造函数
     */
    public ClientResult() {
    }

    public Boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(Boolean success) {
        isSuccess = success;
    }

    /**
     * 构造函数
     *
     * @param code 错误码
     * @param info 返回业务数据
     */
    public ClientResult(int code, Object info) {
        this.code = code;
        this.info = info;
    }


    /**
     * 构造函数 失败
     *
     * @param errorCode 业务异常枚举
     * @param errorMsg  错误描述
     */
    public static ClientResult failure(Integer errorCode, String errorMsg) {
        ClientErrorBean msg = new ClientErrorBean(errorCode, errorMsg);
        ClientResult result = new ClientResult();
        result.setClientErrorBean(msg);
        return result;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Object getInfo() {
        return info;
    }

    public void setInfo(Object info) {
        this.info = info;
    }


    /**
     * 构造失败返回结果
     *
     * @param code 错误码
     * @return 结果对象
     */
    public static ClientResult failure(int code) {
        return new ClientResult(code, null);
    }


    @Override
    public String toString() {
        return "ClientResult [code=" + code + ", info=" + info + "]";
    }
}
