package com.xdja.pki.apache.client.core;


/**
 * 系统共用异常枚举定义
 *
 * @author syg
 *
 */
public enum ClientErrorEnum {

	/************************* 共用错误码 ******************************/
	MISSING_REQUIRED_PARAMETERS(400, 10001, "missing_required_parameters", "缺少必要请求参数"),
	ILLEGAL_REQUEST_PARAMETER(400, 10002, "illegal_request_parameter", "非法请求参数"),
	SERVER_INTERNAL_EXCEPTION(500, 10007, "server_internal_exception", "服务器内部异常"),

	RESOLVE_CLIENT_RESULT_EXCEPTION(400, 90001, "resolve_client_reslut_exception", "请求返回数据解析异常"),

	;

	/**
	 * HTTP状态码
	 */
	private int status;
	/**
	 * 异常信息对象
	 */
	private ClientErrorBean errorBean;
	/**
	 * 异常描述
	 */
	public String desc;

	/**
	 * 异常描述 英文
	 */
	public String errMsg;

	/**
	 * 错误码 syg
	 */
	public int code;

	ClientErrorEnum(int status, int errCode, String errMsg, String desc) {
		this.status = status;
		this.errorBean = new ClientErrorBean(errCode, errMsg);
		this.code = errCode;
		this.desc = desc;
		this.errMsg = errMsg;
	}
}
