package com.xdja.pki.apache.client.result;

import com.xdja.pki.apache.client.core.ClientErrorBean;
import com.xdja.pki.core.json.JsonUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;

/**
 * 适配client返回结果处理类
 *
 * @author syg
 */
public class AdaptClientResult {


    protected static transient final Logger logger = LoggerFactory.getLogger(AdaptClientResult.class);

    /**
     * 将Apache的client返回的Respond转换为对应的result对象
     * @param response
     * @return
     * @throws IOException
     */
    public static ClientResult getResultFromClientResponse(CloseableHttpResponse response) throws IOException {
       ClientResult clientResult = new ClientResult();
        // 获取响应状态
        int statusCode = response.getStatusLine().getStatusCode();
        logger.info("========== 执行调用远程状态码【" + statusCode + "】");

        byte[] body = null;
        // 获取结果实体
        org.apache.http.HttpEntity entity = response.getEntity();
        // 按指定编码转换结果实体为String类型
        if (entity != null) {
            body = EntityUtils.toByteArray(entity);
        }
        if (statusCode != 200) {
            try {
                ClientErrorBean errorBean = JsonUtils.json2Object(new String(body), ClientErrorBean.class);
                logger.info("POST请求========= CA的外部接口返回非200状态信息:" + statusCode + " ====== errCode:" + errorBean.getErrCode() + " ====== errMsg:" + errorBean.getErrMsg());
                clientResult.setCode(statusCode);
                clientResult.setClientErrorBean(errorBean);
                return clientResult;
            } catch (Exception e) {
                logger.error(" ========== 异常信息:{}", e);
                return clientResult;
            }
        }
        if (body.length != 0) {
            try {
                byte[] resp = Base64.decode(body);
                clientResult.setInfo(resp);
            } catch (Exception e) {
                clientResult.setInfo(body);
            }
        } else {
            clientResult.setInfo(null);
        }


        // 释放链接
        EntityUtils.consume(entity);
        response.close();
        return clientResult;
    }

    /**
     * 将Apache的client返回的Respond转换为对应的result对象
     * @param response
     * @return
     * @throws IOException
     */
    public static RAClientResult getClientResponse(CloseableHttpResponse response) throws IOException {
        RAClientResult RAClientResult = new RAClientResult();
        // 获取响应状态
        int statusCode = response.getStatusLine().getStatusCode();
        logger.info("========== 执行调用远程状态码【" + statusCode + "】");

        byte[] body = null;
        // 获取结果实体
        org.apache.http.HttpEntity entity = response.getEntity();
        // 按指定编码转换结果实体为String类型
        if (entity != null) {
            body = EntityUtils.toByteArray(entity);
        }
        if (statusCode != 200) {
            try {
                ErrorBean errorBean = JsonUtils.json2Object(new String(body), ErrorBean.class);

                if (null == errorBean.getErrMsg()) {
                    ErrorMsg errorMsg = JsonUtils.json2Object(new String(body), ErrorMsg.class);
                    logger.info("POST请求========= RA的外部接口返回非200状态信息" + errorMsg);
                    return RAClientResult.failure(errorMsg.getErrorCode(), errorMsg.getErrorMsg());
                }
                logger.info("POST请求========= RA的外部接口返回非200状态信息" + errorBean);
                return RAClientResult.failure(errorBean.getErrCode(), errorBean.getErrMsg());
            } catch (Exception e) {
                logger.error(" ========== 异常信息:{}", e);
                return RAClientResult;
            }
        }
        if (body.length != 0) {
            try {
                byte[] resp = Base64.decode(body);
                RAClientResult.setInfo(resp);
            } catch (Exception e) {
                RAClientResult.setInfo(body);
            }
        } else {
            RAClientResult.setInfo(null);
        }


        // 释放链接
        EntityUtils.consume(entity);
        response.close();
        return RAClientResult;
    }

}
