package com.xdja.pki.apache.client.result;



/**
 * RA-SDK 结果返回errorMsg： code + 中文描述
 *
 * @author: ggp
 * @Date: 2019/11/1 13:59
 * @Description:
 */
public class RAClientResult {

    /**
     * 错误返回对象
     */
    private ErrorMsg errorMsg;
    /**
     * 成功时 返回数据对象
     */
    private Object info;
    /**
     * true 成功  false失败
     */
    private Boolean isSuccess = true;

    public ErrorMsg getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(ErrorMsg errorMsg) {
        this.setSuccess(false);
        this.errorMsg = errorMsg;
    }

    public Object getInfo() {
        return info;
    }

    public void setInfo(Object info) {
        this.info = info;
    }

    public RAClientResult() {
    }

    /**
     * 构造函数 成功
     *
     * @param info 返回业务数据
     */
    public static RAClientResult success(Object info) {
        RAClientResult RAClientResult = new RAClientResult();
        RAClientResult.setSuccess(true);
        RAClientResult.setInfo(info);
        return RAClientResult;
    }
    /**
     * 构造函数 成功
     *
     */
    public static RAClientResult success() {
        RAClientResult RAClientResult = new RAClientResult();
        RAClientResult.setSuccess(true);
        return RAClientResult;
    }

    /**
     * 构造函数 失败
     *
     * @param errorCode 业务异常枚举
     * @param errorMsg  错误描述
     */
    public static RAClientResult failure(Integer errorCode, String errorMsg) {
        ErrorMsg msg = new ErrorMsg(errorCode, errorMsg);
        RAClientResult RAClientResult = new RAClientResult();
        RAClientResult.setErrorMsg(msg);
        return RAClientResult;
    }

    /**
     * 兼容
     *
     * @return
     */
    public Boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(Boolean success) {
        isSuccess = success;
    }

    @Override
    public String toString() {
        return "RAClientResult{" +
                "errorMsg=" + errorMsg +
                ", info=" + info +
                ", isSuccess=" + isSuccess +
                '}';
    }
}
