/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.apache.client.result;

import com.xdja.pki.apache.client.core.ClientErrorBean;
import com.xdja.pki.apache.client.core.ClientErrorEnum;
import com.xdja.pki.apache.client.result.ClientResult;
import com.xdja.pki.apache.client.result.ErrorBean;
import com.xdja.pki.apache.client.result.ErrorMsg;
import com.xdja.pki.apache.client.result.RAClientResult;
import com.xdja.pki.apache.client.utils.json.JsonUtils;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptClientResult {
    protected static final transient Logger logger = LoggerFactory.getLogger(AdaptClientResult.class);

    public static ClientResult getResultFromClientResponse(CloseableHttpResponse response) throws IOException {
        ClientResult clientResult = new ClientResult();
        int statusCode = response.getStatusLine().getStatusCode();
        logger.info("========== \u6267\u884c\u8c03\u7528\u8fdc\u7a0b\u72b6\u6001\u7801\u3010" + statusCode + "\u3011");
        byte[] body = null;
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = EntityUtils.toByteArray((HttpEntity)entity);
        }
        if (statusCode != 200) {
            clientResult.setCode(statusCode);
            try {
                ClientErrorBean errorBean = JsonUtils.json2Object(new String(body), ClientErrorBean.class);
                logger.info("POST\u8bf7\u6c42========= CA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u4fe1\u606f:" + statusCode + " ====== errCode:" + errorBean.getErrCode() + " ====== errMsg:" + errorBean.getErrMsg());
                clientResult.setClientErrorBean(errorBean);
                return clientResult;
            }
            catch (Exception e) {
                logger.error(" ========== \u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
                clientResult.setClientErrorBean(new ClientErrorBean(statusCode, ClientErrorEnum.SERVER_INTERNAL_EXCEPTION.errMsg));
                return clientResult;
            }
        }
        if (null != body && body.length != 0) {
            try {
                byte[] resp = Base64.decode((byte[])body);
                clientResult.setInfo(resp);
            }
            catch (Exception e) {
                clientResult.setInfo(body);
            }
        } else {
            clientResult.setInfo(null);
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return clientResult;
    }

    public static RAClientResult getClientResponse(CloseableHttpResponse response) throws IOException {
        RAClientResult raClientResult = new RAClientResult();
        int statusCode = response.getStatusLine().getStatusCode();
        logger.info("========== \u6267\u884c\u8c03\u7528\u8fdc\u7a0b\u72b6\u6001\u7801\u3010" + statusCode + "\u3011");
        byte[] body = null;
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = EntityUtils.toByteArray((HttpEntity)entity);
        }
        if (statusCode != 200) {
            try {
                ErrorBean errorBean = JsonUtils.json2Object(new String(body), ErrorBean.class);
                if (null == errorBean.getErrMsg()) {
                    ErrorMsg errorMsg = JsonUtils.json2Object(new String(body), ErrorMsg.class);
                    logger.info("POST\u8bf7\u6c42========= RA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u4fe1\u606f" + errorMsg);
                    return RAClientResult.failure(errorMsg.getErrorCode(), errorMsg.getErrorMsg());
                }
                logger.info("POST\u8bf7\u6c42========= RA\u7684\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u975e200\u72b6\u6001\u4fe1\u606f" + errorBean);
                return RAClientResult.failure(errorBean.getErrCode(), errorBean.getErrMsg());
            }
            catch (Exception e) {
                logger.error(" ========== \u5f02\u5e38\u4fe1\u606f:{}", (Throwable)e);
                raClientResult.setErrorMsg(new ErrorMsg(statusCode, ClientErrorEnum.SERVER_INTERNAL_EXCEPTION.errMsg));
                return raClientResult;
            }
        }
        if (null != body && body.length != 0) {
            try {
                byte[] resp = Base64.decode((byte[])body);
                raClientResult.setInfo(resp);
            }
            catch (Exception e) {
                raClientResult.setInfo(body);
            }
        } else {
            raClientResult.setInfo(null);
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return raClientResult;
    }
}

