/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.auditlog.dao;

import com.xdja.pki.auditlog.dao.model.AuditLogDO;
import com.xdja.pki.auditlog.dao.model.PeriodAuditLogDO;
import com.xdja.pki.core.bean.PageInfo;
import com.xdja.pki.core.exception.DAOException;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class PeriodAuditLogDao
extends BaseJdbcDao {
    public List<AuditLogDO> getAuditLogByPeriodId(List<Long> auditLogIds) {
        try {
            ArrayList<AuditLogDO> list = new ArrayList<AuditLogDO>();
            for (Long id : auditLogIds) {
                AuditLogDO auditLogDO = (AuditLogDO)this.daoTemplate.fetch(AuditLogDO.class, id.longValue());
                list.add(auditLogDO);
            }
            return list;
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eid\u67e5\u8be2\u5468\u671f\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public PeriodAuditLogDO savePeriodAuditLog(PeriodAuditLogDO logDO) {
        return (PeriodAuditLogDO)this.daoTemplate.insert((Object)logDO);
    }

    public Object getPeriodAuditLogList(Integer pageNo, Integer pageSize, String startTime, String endTime) {
        Cnd cnd = Cnd.NEW();
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            cnd.and("gmt_create", ">=", (Object)startTime);
            cnd.and("gmt_create", "<=", (Object)endTime);
        }
        cnd.orderBy("id", "desc");
        try {
            if (pageNo == 0 && pageSize == 0) {
                return this.daoTemplate.query(PeriodAuditLogDO.class, (Condition)cnd);
            }
            PageInfo pageInfo = new PageInfo(pageNo.intValue(), pageSize.intValue(), this.daoTemplate.count(PeriodAuditLogDO.class, (Condition)cnd));
            pageInfo.setDatas((Collection)this.daoTemplate.query(PeriodAuditLogDO.class, (Condition)cnd, this.createPager(pageNo, pageSize)));
            this.logger.debug("list page info {} ", (Object)pageInfo);
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u5206\u9875\u67e5\u8be2\u5468\u671f\u5ba1\u8ba1\u65e5\u5fd7\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public PeriodAuditLogDO getPeriodAuditLogById(long periodLogId) {
        Cnd cnd = Cnd.where((String)"id", (String)"=", (Object)periodLogId);
        cnd.orderBy("gmt_create", "desc");
        try {
            List list = this.daoTemplate.query(PeriodAuditLogDO.class, (Condition)cnd);
            if (list.size() > 1) {
                throw new DAOException("\u6839\u636eID\u83b7\u53d6\u5230:" + list.size() + "\u4e2a\u6570\u636e!");
            }
            if (list.isEmpty()) {
                return null;
            }
            return (PeriodAuditLogDO)list.get(0);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eid\u83b7\u53d6\u5468\u671f\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public PeriodAuditLogDO getMaxIdPeriodAuditLog() {
        try {
            String sql = "select * from period_audit_log where id = (select max(id) from period_audit_log)";
            List list = new ArrayList();
            list = this.daoTemplate.queryForList(sql, null, (RowMapper)BeanPropertyRowMapper.newInstance(PeriodAuditLogDO.class));
            if (list.isEmpty()) {
                return null;
            }
            return (PeriodAuditLogDO)list.get(0);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eid\u83b7\u53d6\u5468\u671f\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

