/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    protected static final transient Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static String read(String path) {
        StringBuilder content = new StringBuilder();
        BufferedReader reader = null;
        try {
            File file = new File(path);
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        try {
            String temp;
            reader = new BufferedReader(new FileReader(new File(path)));
            while (null != (temp = reader.readLine())) {
                content.append(temp);
            }
            String string = content.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6\u6587\u4ef6\u65f6\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static String readByBytes(String path) {
        String content = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(path);
            StringBuffer sb = new StringBuffer();
            int c = 0;
            byte[] bytes = new byte[1024];
            while ((c = ((InputStream)inputStream).read(bytes)) != -1) {
                sb.append(new String(bytes, 0, c, StandardCharsets.UTF_8));
            }
            content = sb.toString();
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            throw new RuntimeException("\u4ee5\u5b57\u8282\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    logger.error("\u4ee5\u5b57\u8282\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6", (Throwable)e);
                }
            }
        }
        return content;
    }

    public static String readByLines(String path) {
        String content = null;
        BufferedReader bufferedReader = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                file.createNewFile();
            }
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8));
            StringBuffer sb = new StringBuffer();
            String temp = null;
            while ((temp = bufferedReader.readLine()) != null) {
                sb.append(temp);
            }
            content = sb.toString();
            bufferedReader.close();
        }
        catch (Exception e) {
            throw new RuntimeException("\u4ee5\u884c\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            if (null != bufferedReader) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    logger.error("\u4ee5\u884c\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6", (Throwable)e);
                }
            }
        }
        return content;
    }

    public static String readByChars(String path) {
        String content = null;
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);
            StringBuffer sb = new StringBuffer();
            char[] tempchars = new char[1024];
            while (reader.read(tempchars) != -1) {
                sb.append(tempchars);
            }
            content = sb.toString();
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(" \u4ee5\u5b57\u7b26\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("\u4ee5\u5b57\u7b26\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6", (Throwable)e);
                }
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(String content, String path) {
        boolean mkdir;
        File file = new File(path);
        if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
            throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
        }
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u5931\u8d25", e);
        }
        OutputStreamWriter fw = null;
        try {
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                fw = new FileWriter(new File(path), false);
                if (content != null) {
                    fw.write(content);
                }
                fw.flush();
                // ** MonitorExit[var4_6] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(byte[] content, String path) {
        boolean mkdir;
        File file = new File(path);
        if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
            throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
        }
        OutputStream out = null;
        try {
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                out = new FileOutputStream(new File(path), false);
                ByteArrayInputStream is = new ByteArrayInputStream(content);
                byte[] buff = new byte[1024];
                int len = 0;
                while ((len = is.read(buff)) != -1) {
                    out.write(buff, 0, len);
                }
                ((InputStream)is).close();
                out.close();
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        {
            return;
        }
    }

    public static String downloadFile(String fileFullPath, byte[] fileInfo) {
        FileOutputStream fileWriter = null;
        try {
            boolean mkdir;
            File file = new File(fileFullPath);
            if (file.exists()) {
                file.delete();
            }
            if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
                throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
            }
            file.createNewFile();
            fileWriter = new FileOutputStream(file);
            fileWriter.write(fileInfo);
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException("\u5199\u5165\u6587\u4ef6\uff0c\u8fd4\u56de\u4e0b\u8f7d\u8def\u5f84\u5f02\u5e38", e);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    logger.error("\u5199\u5165\u6587\u4ef6\uff0c\u8fd4\u56de\u4e0b\u8f7d\u8def\u5f84\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return fileFullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveCertInfoFile(String fileFullPath, String fileInfo, boolean isClearDir) {
        OutputStreamWriter fw = null;
        try {
            boolean mkdir;
            File file = new File(fileFullPath);
            if (file.getParentFile().exists() && isClearDir) {
                FileUtils.deleteFile(file.getParentFile());
            }
            if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
                throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
            }
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                fw = new FileWriter(new File(fileFullPath), false);
                if (fileInfo != null) {
                    fw.write(fileInfo);
                }
                fw.flush();
                // ** MonitorExit[var5_8] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5199\u5165\u6587\u4ef6\uff0c\u8fd4\u56de\u4e0b\u8f7d\u8def\u5f84\u5f02\u5e38", e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        {
            return fileFullPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveByteCertInfoFile(String fileFullPath, byte[] fileInfo, boolean isClearDir) {
        FileOutputStream fw = null;
        try {
            boolean mkdir;
            File file = new File(fileFullPath);
            if (file.getParentFile().exists() && isClearDir) {
                FileUtils.deleteFile(file.getParentFile());
            }
            if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
                throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
            }
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                fw = new FileOutputStream(new File(fileFullPath), false);
                if (fileInfo != null) {
                    fw.write(fileInfo);
                }
                fw.flush();
                // ** MonitorExit[var5_8] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            throw new RuntimeException("\u5199\u5165\u6587\u4ef6\uff0c\u8fd4\u56de\u4e0b\u8f7d\u8def\u5f84\u5f02\u5e38", e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        {
            return fileFullPath;
        }
    }

    public static void deleteFiles(List<String> fileNames) {
        if (fileNames != null && fileNames.size() > 0) {
            for (String fileName : fileNames) {
                FileUtils.deleteFile(fileName);
            }
        }
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            FileUtils.deleteFile(file);
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else {
                File[] listFiles;
                for (File file2 : listFiles = file.listFiles()) {
                    FileUtils.deleteFile(file2);
                }
                file.delete();
            }
        } else {
            logger.error("\u8be5file\u8def\u5f84\u4e0d\u5b58\u5728\uff01\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByBinary(String path) throws FileNotFoundException, IOException {
        FileInputStream inputStream = null;
        ByteArrayOutputStream baos = null;
        try {
            inputStream = new FileInputStream(path);
            baos = new ByteArrayOutputStream();
            int c = 0;
            byte[] bytes = new byte[1024];
            while ((c = ((InputStream)inputStream).read(bytes)) != -1) {
                baos.write(bytes, 0, c);
            }
            ((InputStream)inputStream).close();
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
            if (baos != null) {
                baos.close();
            }
        }
        return baos.toByteArray();
    }

    public static void writeByBinary(String path, byte[] datas) throws IOException {
        boolean mkdir;
        File file = new File(path);
        if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
            throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream os = new FileOutputStream(path);
        ((OutputStream)os).write(datas);
        ((OutputStream)os).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(OutputStream out, File file) throws Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] data = new byte[1024];
            int size = 0;
            while ((size = ((InputStream)in).read(data)) != -1) {
                out.write(data, 0, size);
            }
        }
        finally {
            if (null != in) {
                ((InputStream)in).close();
            }
        }
    }

    public static byte[] readToBytes(InputStream in) throws Exception {
        int num;
        ByteArrayOutputStream outputData = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((num = in.read(buf)) != -1) {
            outputData.write(buf, 0, num);
        }
        return outputData.toByteArray();
    }

    public static boolean mkdirs(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDir(String sourceDir, String targetDir) throws IOException {
        File path1 = new File(sourceDir);
        File path2 = new File(targetDir);
        if (path1.exists()) {
            File[] items;
            if (!path2.exists()) {
                path2.mkdirs();
            }
            for (File item : items = path1.listFiles()) {
                if (item.isFile()) {
                    FileInputStream fis = null;
                    FileOutputStream fos = null;
                    try {
                        fis = new FileInputStream(item);
                        fos = new FileOutputStream(path2 + "/" + item.getName());
                        byte[] b = new byte[1024];
                        int i = 0;
                        while ((i = fis.read(b)) != -1) {
                            fos.write(b, 0, i);
                            fos.flush();
                        }
                        fos.close();
                        fis.close();
                        continue;
                    }
                    finally {
                        if (fos != null) {
                            fos.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                }
                FileUtils.copyDir(item.getPath(), path2 + "/" + item.getName());
            }
        } else {
            logger.error("\u6e90\u76ee\u5f55[{}]\u4e0d\u5b58\u5728", (Object)sourceDir);
        }
    }

    public static void copyFiles(String srouceFileName, String destFileName) throws IOException {
        File srouceFile = new File(srouceFileName);
        File destFile = new File(destFileName);
        Files.copy(srouceFile.toPath(), destFile.toPath(), new CopyOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(MultipartFile filecontent, String fileName) {
        FileOutputStream os = null;
        InputStream inputStream = null;
        try {
            inputStream = filecontent.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            int len;
            byte[] bs = new byte[1024];
            os = new FileOutputStream(fileName);
            while ((len = inputStream.read(bs)) != -1) {
                ((OutputStream)os).write(bs, 0, len);
            }
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (null != os) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8f93\u5165\u6d41\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
            if (null != os) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }
}

