/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.service.manager;

import com.xdja.pki.backup.common.Result;
import com.xdja.pki.backup.dao.BackupConfigDao;
import com.xdja.pki.backup.dao.model.BackupConfigDO;
import com.xdja.pki.backup.service.manager.BackupConfigService;
import com.xdja.pki.backup.service.manager.DatabaseBackupOperateHelper;
import com.xdja.pki.backup.service.manager.bean.BackupConfigReq;
import com.xdja.pki.backup.service.manager.bean.BackupConfigVO;
import com.xdja.pki.backup.util.ConfigUtils;
import com.xdja.pki.dynamic.task.CronTaskRegistrar;
import com.xdja.pki.dynamic.task.SchedulingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackupConfigServiceImpl
implements BackupConfigService {
    private Logger logger = LoggerFactory.getLogger(DatabaseBackupOperateHelper.class);
    @Autowired
    BackupConfigDao backupConfigDao;
    @Autowired
    private CronTaskRegistrar cronTaskRegistrar;

    @Override
    public Result updateBackupConfig(BackupConfigReq backupConfigReq) {
        Result result = new Result();
        BackupConfigDO backupConfigDO = new BackupConfigDO();
        BeanUtils.copyProperties((Object)backupConfigReq, (Object)backupConfigDO);
        BackupConfigDO backupConfigDoFromJson = this.backupConfigDao.getBackupConfig();
        backupConfigDO.setBackupPath(backupConfigDoFromJson.getBackupPath());
        backupConfigDO.setRecoverPath(backupConfigDoFromJson.getRecoverPath());
        this.backupConfigDao.saveBackupConfig(backupConfigDO);
        if (backupConfigDO.getIsOpenAutoBackup() == 1) {
            this.logger.info("\u8bbe\u7f6e\u4e3a\u81ea\u52a8\u5907\u4efd\uff0c\u6dfb\u52a0\u5907\u4efd\u7ebf\u7a0b[backupServiceImpl.autoTotalBackup()] crn[{}]", (Object)backupConfigDO.getTotalCron());
            this.cronTaskRegistrar.addCronTask((Runnable)new SchedulingRunnable("backupServiceImpl", "autoTotalBackup"), backupConfigDO.getTotalCron());
            this.logger.info("\u8bbe\u7f6e\u4e3a\u81ea\u52a8\u5907\u4efd\uff0c\u6dfb\u52a0\u5907\u4efd\u7ebf\u7a0b[backupServiceImpl.autoIncBackup()] crn[{}]", (Object)backupConfigDO.getIncCron());
            this.cronTaskRegistrar.addCronTask((Runnable)new SchedulingRunnable("backupServiceImpl", "autoIncBackup"), backupConfigDO.getIncCron());
        } else {
            this.logger.info("\u8bbe\u7f6e\u4e3a\u624b\u52a8\u5907\u4efd\uff0c\u5220\u9664\u5907\u4efd\u7ebf\u7a0b[backupServiceImpl.autoTotalBackup()]");
            this.cronTaskRegistrar.removeCronTask((Runnable)new SchedulingRunnable("backupServiceImpl", "autoTotalBackup"));
            this.logger.info("\u8bbe\u7f6e\u4e3a\u624b\u52a8\u5907\u4efd\uff0c\u5220\u9664\u5907\u4efd\u7ebf\u7a0b[backupServiceImpl.autoIncBackup()]");
            this.cronTaskRegistrar.removeCronTask((Runnable)new SchedulingRunnable("backupServiceImpl", "autoIncBackup"));
        }
        return result;
    }

    @Override
    public Result getBackupConfigForView() {
        Result result = new Result();
        BackupConfigVO backupConfigVo = new BackupConfigVO();
        BeanUtils.copyProperties((Object)this.getBackupConfigModel(), (Object)backupConfigVo);
        result.setInfo(backupConfigVo);
        return result;
    }

    @Override
    public BackupConfigDO getBackupConfigModel() {
        BackupConfigDO backupConfigDO;
        try {
            backupConfigDO = this.backupConfigDao.getBackupConfig();
        }
        catch (RuntimeException e) {
            this.logger.error("\u5907\u4efd\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\u521b\u5efa\u914d\u7f6e\u6587\u4ef6\u3002");
            backupConfigDO = new BackupConfigDO();
            String[] filePath = ConfigUtils.getSysConfPath().split("/");
            backupConfigDO.setBackupPath("/home/xdja/backup/" + filePath[4]);
            backupConfigDO.setRecoverPath("/home/xdja/recover/" + filePath[4]);
            backupConfigDO.setIsOpenAutoBackup(0);
            backupConfigDO.setFileRetentionPeriod(2);
            backupConfigDO.setTotalBackupPeriod(1);
            backupConfigDO.setIncBackupPeriod(1);
            this.backupConfigDao.saveBackupConfig(backupConfigDO);
        }
        return backupConfigDO;
    }

    @Override
    public void initBackupConfig() {
        BackupConfigDO backupConfigDO = this.getBackupConfigModel();
        if (backupConfigDO.getIsOpenAutoBackup() == 1) {
            this.logger.info("\u5907\u4efd\u6a21\u5f0f\uff1a\u81ea\u52a8\u5907\u4efd");
            this.logger.info("\u542f\u52a8\u5168\u91cf\u5907\u4efd\u7ebf\u7a0b[autoTotalBackup()] crn[{}]", (Object)backupConfigDO.getTotalCron());
            this.cronTaskRegistrar.addCronTask((Runnable)new SchedulingRunnable("backupServiceImpl", "autoTotalBackup"), backupConfigDO.getTotalCron());
            this.logger.info("\u542f\u52a8\u589e\u91cf\u5907\u4efd\u7ebf\u7a0b[autoIncBackup()] crn[{}]", (Object)backupConfigDO.getIncCron());
            this.cronTaskRegistrar.addCronTask((Runnable)new SchedulingRunnable("backupServiceImpl", "autoIncBackup"), backupConfigDO.getIncCron());
            this.logger.info("\u542f\u52a8\u81ea\u52a8\u6e05\u7406\u5907\u4efd\u7ebf\u7a0b[autoCleanOverdueBackup()] crn[{}]", (Object)backupConfigDO.getRetentionCron());
            this.cronTaskRegistrar.addCronTask((Runnable)new SchedulingRunnable("backupServiceImpl", "autoCleanOverdueBackup"), backupConfigDO.getRetentionCron());
        } else {
            this.logger.info("\u5907\u4efd\u6a21\u5f0f\uff1a\u624b\u5de5\u5907\u4efd");
        }
    }
}

