/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.web.manager;

import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditLogSign;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.backup.common.ErrorEnum;
import com.xdja.pki.backup.common.Result;
import com.xdja.pki.backup.service.manager.BackupConfigService;
import com.xdja.pki.backup.service.manager.bean.BackupConfigReq;
import com.xdja.pki.backup.util.JsonUtils;
import com.xdja.pki.core.bean.CoreResult;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BackupConfigController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BackupConfigService backupConfigService;

    @AuditLogSign
    @RequestMapping(value={"/v1/system/backup/updateConfig"}, method={RequestMethod.POST})
    public Object updateBackupConfig(@RequestBody BackupConfigReq backupConfigReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("UpdateBackupConfig()>>>>>>backupConfigReq:[{}]", (Object)JsonUtils.object2Json(backupConfigReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u53d1\u8d77\u4fdd\u5b58\u5907\u4efd\u8bbe\u7f6e\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.backupConfigService.updateBackupConfig(backupConfigReq);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5907\u4efd\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            logContent.append("\u4fee\u6539\u5907\u4efd\u914d\u7f6e\u3010\u5931\u8d25\u3011\uff0c\u662f\u5426\u81ea\u52a8\u5907\u4efd=");
        } else {
            logContent.append("\u4fee\u6539\u5907\u4efd\u914d\u7f6e\u3010\u6210\u529f\u3011\uff0c\u662f\u5426\u81ea\u52a8\u5907\u4efd=");
        }
        if (0 == backupConfigReq.getIsOpenAutoBackup()) {
            logContent.append("\u624b\u5de5\u5907\u4efd");
        } else {
            logContent.append("\u81ea\u52a8\u5907\u4efd");
        }
        logContent.append(", \u6587\u4ef6\u4fdd\u7559\u671f\u9650=(").append(backupConfigReq.getFileRetentionPeriod()).append("*30)\u5929");
        logContent.append(", \u5168\u91cf\u5907\u4efd\u5468\u671f=\u6bcf\u6708").append(backupConfigReq.getTotalBackupPeriod()).append("\u53f7");
        logContent.append(", \u589e\u91cf\u5907\u4efd\u5468\u671f=\u6bcf\u5468").append(backupConfigReq.getIncBackupPeriod());
        CoreResult coreResult = CoreResult.getCoreResultInstance((Object)JsonUtils.object2Json(result), (int)AuditLogOperatorTypeEnum.SYSTEM_BACKUP_MANAGEMENT.type, (String)logContent.toString());
        this.logger.info("UpdateBackupConfig()<<<<<result:{}", (Object)JsonUtils.object2Json(coreResult));
        return coreResult;
    }

    @RequestMapping(value={"/v1/system/backup/getConfig"}, method={RequestMethod.GET})
    public Object getBackupConfig(AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("getBackupConfig()>>>>>>");
        try {
            result = this.backupConfigService.getBackupConfigForView();
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5907\u4efd\u914d\u7f6e\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("getBackupConfig()<<<<<result:{}", (Object)JsonUtils.object2Json(result));
        return result.getInfo();
    }
}

