/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.web.manager;

import com.xdja.pki.backup.common.ErrorEnum;
import com.xdja.pki.backup.common.Result;
import com.xdja.pki.backup.service.manager.RecoveryService;
import com.xdja.pki.backup.util.JsonUtils;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
public class RecoverController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RecoveryService recoveryService;

    @RequestMapping(value={"/v1/init/system/recovery"}, method={RequestMethod.POST})
    public Object recovery(@RequestParam(value="totalFileData") MultipartFile totalFileData, @RequestParam(value="incFileData", required=false) MultipartFile incFileData, HttpServletResponse resp) {
        Result result;
        this.logger.info("recovery()>>>>>>totalFileName:[{}] ", (Object)totalFileData.getOriginalFilename());
        try {
            result = this.recoveryService.recovery(totalFileData, incFileData);
        }
        catch (Exception e) {
            this.logger.error("\u6062\u590d\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("recovery()<<<<<result:{}", (Object)JsonUtils.object2Json(result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/init/system/isRecoveryOver"}, method={RequestMethod.GET})
    public Object isRecoveryOver(HttpServletResponse resp) {
        Result result;
        this.logger.info("isRecoveryOver()>>>>>>");
        try {
            result = this.recoveryService.isRecoveryOver();
        }
        catch (Exception e) {
            this.logger.error("\u5907\u4efd\u662f\u5426\u7ed3\u675f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("isRecoveryOver()<<<<<result:{}", (Object)JsonUtils.object2Json(result));
        return result.getInfo();
    }
}

