/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.service.manager;

import com.xdja.pki.backup.util.ConfigUtils;
import com.xdja.pki.backup.util.DataSourceUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatabaseBackupOperateHelper {
    private Logger logger = LoggerFactory.getLogger(DatabaseBackupOperateHelper.class);
    @Autowired
    DataSourceUtils dataSourceUtils;

    public void execBackup(String sqlFile) throws IOException, InterruptedException {
        String[] dburl = this.dataSourceUtils.dbUrlSplit(this.dataSourceUtils.getDbUrl());
        String pwd = this.dataSourceUtils.getDbPassword();
        String userName = this.dataSourceUtils.getDbUsername();
        String mysqldumpCommandPath = this.getMysqldumpCommandPath();
        StringBuilder sb = new StringBuilder();
        sb.append(mysqldumpCommandPath);
        sb.append(" -h" + dburl[0]);
        sb.append(" -u" + userName);
        sb.append(" -p" + pwd);
        sb.append(" " + dburl[2] + " --set-gtid-purged=off >");
        sb.append(sqlFile);
        String[] command = new String[3];
        if (ConfigUtils.isWindows()) {
            command[0] = "cmd";
            command[1] = "/c";
        } else {
            command[0] = "/bin/sh";
            command[1] = "-c";
        }
        command[2] = sb.toString();
        this.logger.debug("\u5907\u4efd\u547d\u4ee4\u4e3a\uff1a[{}]", (Object)sb);
        Runtime runtime = Runtime.getRuntime();
        this.logger.info("\u5f00\u59cb\u5907\u4efd\uff1a[{}]", (Object)dburl[2]);
        Process process = runtime.exec(command);
        InputStream input = process.getInputStream();
        String expMsg = IOUtils.toString((InputStream)input, (String)"UTF-8");
        this.logger.debug("\u6570\u636e\u5e93\u5907\u4efd\u4fe1\u606f\uff1a[{}]", (Object)expMsg);
        int processComplete = process.waitFor();
        if (processComplete != 0) {
            InputStream errorStream = process.getErrorStream();
            expMsg = IOUtils.toString((InputStream)errorStream);
            this.logger.error("\u6570\u636e\u5e93\u5907\u4efd\u5931\u8d25\uff1a[{}]", (Object)expMsg);
            throw new RuntimeException("\u5907\u4efd\u6570\u636e\u5e93\u5931\u8d25.");
        }
        this.logger.info("\u6570\u636e\u5e93\u5907\u4efd\u6210\u529f\uff1a[{}]", (Object)sqlFile);
    }

    private String getMysqldumpCommandPath() throws IOException, InterruptedException {
        String[] command = new String[3];
        if (ConfigUtils.isWindows()) {
            command[0] = "cmd";
            command[1] = "/c";
        } else {
            command[0] = "/bin/sh";
            command[1] = "-c";
        }
        command[2] = "whereis mysqldump";
        this.logger.debug("\u83b7\u53d6mysqldump\u8def\u5f84\u547d\u4ee4\u4e3a\uff1a[{}]", (Object)command[2]);
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(command);
        InputStream input = process.getInputStream();
        String expMsg = IOUtils.toString((InputStream)input, (String)"UTF-8");
        this.logger.debug("mysqldump\u8def\u5f84\uff1a[{}]", (Object)expMsg);
        int processComplete = process.waitFor();
        if (processComplete != 0) {
            InputStream errorStream = process.getErrorStream();
            expMsg = IOUtils.toString((InputStream)errorStream);
            this.logger.error("\u6570\u636e\u5e93\u5907\u4efd\u5931\u8d25\uff1a[{}]", (Object)expMsg);
            throw new RuntimeException("\u5907\u4efd\u6570\u636e\u5e93\u5931\u8d25\uff0c\u6570\u636e\u5e93\u6ca1\u6709\u6b63\u786e\u5b89\u88c5!");
        }
        if (expMsg == null) {
            this.logger.error("\u6570\u636e\u5e93\u5907\u4efd\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230mysqldump\u547d\u4ee4");
            throw new RuntimeException("\u5907\u4efd\u6570\u636e\u5e93\u5931\u8d25\uff0c\u6570\u636e\u5e93\u6ca1\u6709\u6b63\u786e\u5b89\u88c5!");
        }
        return expMsg.replaceAll("\r|\n", "").split(" ")[1];
    }

    public void execRecover(String sqlFile) throws IOException, InterruptedException {
        String[] dburl = this.dataSourceUtils.dbUrlSplit(this.dataSourceUtils.getDbUrl());
        String pwd = this.dataSourceUtils.getDbPassword();
        String userName = this.dataSourceUtils.getDbUsername();
        String mysqlCommandPath = this.getMysqlCommandPath();
        StringBuilder sb = new StringBuilder();
        sb.append(mysqlCommandPath);
        sb.append(" -h" + dburl[0]);
        sb.append(" -P" + dburl[1]);
        sb.append(" -u" + userName);
        sb.append(" -p" + pwd);
        sb.append(" " + dburl[2] + " <");
        sb.append(sqlFile);
        String[] command = new String[3];
        if (ConfigUtils.isWindows()) {
            command[0] = "cmd";
            command[1] = "/c";
        } else {
            command[0] = "/bin/sh";
            command[1] = "-c";
        }
        command[2] = sb.toString();
        this.logger.info("\u8fd8\u539f\u547d\u4ee4\u4e3a\uff1a[{}]", (Object)sb);
        Runtime runtime = Runtime.getRuntime();
        this.logger.info("\u5f00\u59cb\u8fd8\u539f\u6570\u636e");
        Process process = runtime.exec(command);
        InputStream input = process.getInputStream();
        String expMsg = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
        this.logger.info("\u6570\u636e\u5e93\u6062\u590d\u4fe1\u606f\uff1a[{}]", (Object)expMsg);
        int processComplete = process.waitFor();
        if (processComplete != 0) {
            InputStream errorStream = process.getErrorStream();
            expMsg = IOUtils.toString((InputStream)errorStream);
            this.logger.error("\u6570\u636e\u5e93\u5907\u4efd\u5931\u8d25\uff1a[{}]", (Object)expMsg);
            throw new RuntimeException("\u5907\u4efd\u6570\u636e\u5e93\u5931\u8d25.");
        }
        this.logger.info("\u6570\u636e\u5e93\u8fd8\u539f\u6210\u529f\uff1a[{}]", (Object)sqlFile);
    }

    private String getMysqlCommandPath() throws IOException, InterruptedException {
        String[] command = new String[3];
        if (ConfigUtils.isWindows()) {
            command[0] = "cmd";
            command[1] = "/c";
        } else {
            command[0] = "/bin/sh";
            command[1] = "-c";
        }
        command[2] = "whereis mysql";
        this.logger.debug("\u83b7\u53d6mysql\u8def\u5f84\u547d\u4ee4\u4e3a\uff1a[{}]", (Object)command[2]);
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(command);
        InputStream input = process.getInputStream();
        String expMsg = IOUtils.toString((InputStream)input, (String)"UTF-8");
        this.logger.debug("mysql\u8def\u5f84\uff1a[{}]", (Object)expMsg);
        int processComplete = process.waitFor();
        if (processComplete != 0) {
            InputStream errorStream = process.getErrorStream();
            expMsg = IOUtils.toString((InputStream)errorStream);
            this.logger.error("\u6570\u636e\u5e93\u5907\u4efd\u5931\u8d25\uff1a[{}]", (Object)expMsg);
            throw new RuntimeException("\u5907\u4efd\u6570\u636e\u5e93\u5931\u8d25\uff0c\u6570\u636e\u5e93\u6ca1\u6709\u6b63\u786e\u5b89\u88c5!");
        }
        if (expMsg == null) {
            this.logger.error("\u6570\u636e\u5e93\u5907\u4efd\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230mysql\u547d\u4ee4");
            throw new RuntimeException("\u5907\u4efd\u6570\u636e\u5e93\u5931\u8d25\uff0c\u6570\u636e\u5e93\u6ca1\u6709\u6b63\u786e\u5b89\u88c5!");
        }
        return expMsg.replaceAll("\r|\n", "").split(" ")[1];
    }
}

