/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.dao;

import com.xdja.pki.backup.common.PageInfo;
import com.xdja.pki.backup.dao.model.BackupDO;
import com.xdja.pki.dao.BaseJdbcDao;
import java.util.Date;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class BackupDao
extends BaseJdbcDao {
    public PageInfo<BackupDO> getTotalBackupByPage(int pageNo, int pageSize) {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select * ");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM pki_backup AS c");
        fromSql.append(" WHERE c.backup_type = 0 ");
        fromSql.append(" ORDER BY c.gmt_create DESC ");
        PageInfo<BackupDO> page = new PageInfo<BackupDO>(pageNo, pageSize, this.queryForInt("SELECT COUNT(0)" + fromSql, (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(BackupDO.class)));
        return page;
    }

    public List<BackupDO> getBackupByParentId(Long parentId) {
        String sql = "select * from  pki_backup WHERE parent_id = :parent_id order by gmt_create desc";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("parent_id", (Object)parentId);
        return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(BackupDO.class));
    }

    public List<BackupDO> getBackupList(int backupMode, int backupType, int backupStatus) {
        String sql = "select * from  pki_backup WHERE backup_mode = :backup_mode  and backup_type = :backup_type and backup_status = :backup_status order by gmt_create desc";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("backup_mode", (Object)backupMode);
        params.addValue("backup_type", (Object)backupType);
        params.addValue("backup_status", (Object)backupStatus);
        return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(BackupDO.class));
    }

    public BackupDO insertBackup(BackupDO backupDO) {
        return (BackupDO)this.daoTemplate.insert((Object)backupDO);
    }

    public BackupDO getBackupById(Long id) {
        String sql = "select * from  pki_backup WHERE id = :id order by gmt_create desc";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("id", (Object)id);
        return (BackupDO)this.daoTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(BackupDO.class));
    }

    public BackupDO getLastTotalBackup(int backupMode) {
        List<BackupDO> backupDOList = this.getBackupList(backupMode, 0, 1);
        if (backupDOList != null && backupDOList.size() > 0) {
            return backupDOList.get(0);
        }
        return null;
    }

    public List<BackupDO> getExpireBackupListBefore(String currentDate) {
        Cnd cnd = Cnd.where((String)"gmt_create", (String)">", (Object)currentDate).and("backup_status", "=", (Object)1).and("file_expired", "=", (Object)0);
        return this.daoTemplate.query(BackupDO.class, (Condition)cnd);
    }

    public int updateBackuping() {
        String sql = "update pki_backup set backup_status = 2, gmt_create = :time where backup_status = 0";
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("time", (Object)new Date());
        return this.daoTemplate.update(sql, (SqlParameterSource)parameterSource);
    }
}

