/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.util;

import com.alibaba.fastjson.util.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class SpringPropertiesUtils
extends PropertyPlaceholderConfigurer {
    private static Map<String, Object> ctxPropertiesMap;

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        super.processProperties(beanFactoryToProcess, props);
        ctxPropertiesMap = new HashMap<String, Object>();
        for (Object key : props.keySet()) {
            String keyStr = key.toString();
            String value = props.getProperty(keyStr);
            ctxPropertiesMap.put(keyStr, value);
        }
    }

    public static String getProperty(String key) {
        return TypeUtils.castToString((Object)ctxPropertiesMap.get(key));
    }

    public static Object getObject(String key, Class clazz) {
        String obj = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToJavaBean((Object)obj, (Class)clazz);
    }

    public static Boolean getBoolean(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToBoolean((Object)value);
    }

    public static byte[] getBytes(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToBytes((Object)value);
    }

    public static boolean getBooleanValue(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToBoolean((Object)value);
    }

    public static Byte getByte(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToByte((Object)value);
    }

    public static byte getByteValue(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToByte((Object)value);
    }

    public static Short getShort(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToShort((Object)value);
    }

    public static short getShortValue(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToShort((Object)value);
    }

    public static Integer getInteger(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToInt((Object)value);
    }

    public static int getIntValue(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToInt((Object)value);
    }

    public static Long getLong(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToLong((Object)value);
    }

    public static long getLongValue(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToLong((Object)value);
    }

    public static Float getFloat(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToFloat((Object)value);
    }

    public static float getFloatValue(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToFloat((Object)value).floatValue();
    }

    public static Double getDouble(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToDouble((Object)value);
    }

    public static double getDoubleValue(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToDouble((Object)value);
    }

    public static BigDecimal getBigDecimal(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToBigDecimal((Object)value);
    }

    public static BigInteger getBigInteger(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToBigInteger((Object)value);
    }

    public static String getString(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return value.toString();
    }

    public static Date getDate(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToDate((Object)value);
    }

    public static java.sql.Date getSqlDate(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToSqlDate((Object)value);
    }

    public static Timestamp getTimestamp(String key) {
        String value = SpringPropertiesUtils.getProperty(key);
        return TypeUtils.castToTimestamp((Object)value);
    }
}

