/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.util;

import com.xdja.pki.backup.dao.model.EachFileHashDo;
import com.xdja.pki.backup.dao.model.FileHashDO;
import com.xdja.pki.backup.util.ConfigUtils;
import com.xdja.pki.backup.util.FileUtils;
import com.xdja.pki.core.utils.HashUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupFileUtils {
    private static Logger logger = LoggerFactory.getLogger(BackupFileUtils.class);

    public static EachFileHashDo scanFile() {
        EachFileHashDo eachFileHashDo = new EachFileHashDo();
        eachFileHashDo.setTomcatFileHash(BackupFileUtils.scanFile(ConfigUtils.getTomcatConfPath()));
        eachFileHashDo.setSancHsmFileHash(BackupFileUtils.scanFile(ConfigUtils.getSancHsmConfPath()));
        eachFileHashDo.setYunHsmFileHash(BackupFileUtils.scanFile(ConfigUtils.getYunHsmConfPath()));
        eachFileHashDo.setSysConfFileHash(BackupFileUtils.scanFile(ConfigUtils.getSysConfPath()));
        return eachFileHashDo;
    }

    public static List<FileHashDO> scanFile(String fileName) {
        ArrayList<FileHashDO> eachFileHashDOList = new ArrayList<FileHashDO>();
        File dir = new File(fileName);
        if (dir.exists()) {
            logger.info("\u626b\u63cf\u6587\u4ef6\u76ee\u5f55[{}]", (Object)dir.getAbsolutePath());
            BackupFileUtils.scanFile(eachFileHashDOList, dir);
        } else {
            logger.info("\u626b\u63cf\u6587\u4ef6\u76ee\u5f55[{}]\u4e0d\u5b58\u5728", (Object)dir.getAbsolutePath());
        }
        dir = null;
        return eachFileHashDOList;
    }

    private static void scanFile(List<FileHashDO> eachFileHashDOList, File dir) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            FileHashDO fileHashDo;
            if (file.isDirectory()) {
                fileHashDo = new FileHashDO();
                BackupFileUtils.scanFile(eachFileHashDOList, file);
                fileHashDo.setFileAbsolutePath(file.getAbsolutePath());
                fileHashDo.setSubFileHash(eachFileHashDOList);
                file = null;
                continue;
            }
            fileHashDo = new FileHashDO();
            fileHashDo.setFileName(file.getName());
            fileHashDo.setFileAbsolutePath(file.getAbsolutePath());
            fileHashDo.setFileLength(file.length());
            fileHashDo.setFileHash(HashUtils.md5((File)file));
            eachFileHashDOList.add(fileHashDo);
            file = null;
        }
    }

    public static List<FileHashDO> compareEachFile(EachFileHashDo totalEachFileHashList, EachFileHashDo newEachFileHashList) {
        ArrayList<FileHashDO> incFileList = new ArrayList<FileHashDO>();
        HashMap<String, FileHashDO> totalFileHashDoMap = new HashMap<String, FileHashDO>();
        BackupFileUtils.fileHashDoList2Map(totalFileHashDoMap, totalEachFileHashList.getSancHsmFileHash());
        BackupFileUtils.fileHashDoList2Map(totalFileHashDoMap, totalEachFileHashList.getSysConfFileHash());
        BackupFileUtils.fileHashDoList2Map(totalFileHashDoMap, totalEachFileHashList.getTomcatFileHash());
        BackupFileUtils.fileHashDoList2Map(totalFileHashDoMap, totalEachFileHashList.getYunHsmFileHash());
        HashMap<String, FileHashDO> newFileHashDoMap = new HashMap<String, FileHashDO>();
        BackupFileUtils.fileHashDoList2Map(newFileHashDoMap, newEachFileHashList.getSancHsmFileHash());
        BackupFileUtils.fileHashDoList2Map(newFileHashDoMap, newEachFileHashList.getSysConfFileHash());
        BackupFileUtils.fileHashDoList2Map(newFileHashDoMap, newEachFileHashList.getTomcatFileHash());
        BackupFileUtils.fileHashDoList2Map(newFileHashDoMap, newEachFileHashList.getYunHsmFileHash());
        BackupFileUtils.compareEachFile(incFileList, totalFileHashDoMap, newFileHashDoMap);
        return incFileList;
    }

    private static void fileHashDoList2Map(Map<String, FileHashDO> map, List<FileHashDO> list) {
        if (list != null && !list.isEmpty()) {
            for (FileHashDO fileHashDo : list) {
                BackupFileUtils.fileHashDoList2Map(map, fileHashDo.getSubFileHash());
                fileHashDo.setSubFileHash(null);
                map.put(fileHashDo.getFileAbsolutePath(), fileHashDo);
            }
        }
    }

    private static void compareEachFile(List<FileHashDO> incFileList, Map<String, FileHashDO> totalFileHashDoMap, Map<String, FileHashDO> newFileHashDoMap) {
        if (totalFileHashDoMap == null || totalFileHashDoMap.isEmpty()) {
            incFileList.addAll(newFileHashDoMap.values());
        } else {
            String totalFileHash = null;
            String newFileHash = null;
            for (String key : newFileHashDoMap.keySet()) {
                if (totalFileHashDoMap.containsKey(key)) {
                    totalFileHash = totalFileHashDoMap.get(key).getFileHash();
                    if (totalFileHash.equals(newFileHash = newFileHashDoMap.get(key).getFileHash())) continue;
                    incFileList.add(newFileHashDoMap.get(key));
                    continue;
                }
                incFileList.add(newFileHashDoMap.get(key));
            }
        }
    }

    public static void copyFiles2BackupPath(List<FileHashDO> incFileList, String backupPath) throws IOException {
        HashMap<String, String> configFilePath = new HashMap<String, String>();
        File dir = new File(ConfigUtils.getSancHsmConfPath());
        File backupDir = new File(backupPath + ConfigUtils.getZipSancHsmConfPath());
        FileUtils.mkdirs(backupPath + ConfigUtils.getZipSancHsmConfPath());
        configFilePath.put(dir.getAbsolutePath(), backupDir.getAbsolutePath());
        dir = new File(ConfigUtils.getYunHsmConfPath());
        backupDir = new File(backupPath + ConfigUtils.getZipYunHsmConfPath());
        FileUtils.mkdirs(backupPath + ConfigUtils.getZipYunHsmConfPath());
        configFilePath.put(dir.getAbsolutePath(), backupDir.getAbsolutePath());
        dir = new File(ConfigUtils.getSysConfPath());
        backupDir = new File(backupPath + ConfigUtils.getZipSysConfPath());
        FileUtils.mkdirs(backupPath + ConfigUtils.getZipSysConfPath());
        configFilePath.put(dir.getAbsolutePath(), backupDir.getAbsolutePath());
        dir = new File(ConfigUtils.getTomcatConfPath());
        backupDir = new File(backupPath + ConfigUtils.getZipTomcatConfPath());
        FileUtils.mkdirs(backupPath + ConfigUtils.getZipTomcatConfPath());
        configFilePath.put(dir.getAbsolutePath(), backupDir.getAbsolutePath());
        String sourceFileAbsolutePath = null;
        String targetFileAbsolutePath = null;
        for (FileHashDO fileHashDo : incFileList) {
            for (String key : configFilePath.keySet()) {
                sourceFileAbsolutePath = fileHashDo.getFileAbsolutePath();
                if (!sourceFileAbsolutePath.contains(key)) continue;
                targetFileAbsolutePath = sourceFileAbsolutePath.replace(key, (CharSequence)configFilePath.get(key));
                FileUtils.copyFiles(sourceFileAbsolutePath, targetFileAbsolutePath);
            }
        }
    }
}

