/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.util;

import com.xdja.pki.dao.EncryptUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class DataSourceUtils {
    private static String flag = "master";
    private String dbUrl;
    private String dbUsername;
    private String dbPassword;
    ApplicationContext applicationContext;

    public DataSourceUtils(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        Environment environment = applicationContext.getEnvironment();
        this.dbUrl = environment.getProperty("db.master.url");
        this.dbUsername = EncryptUtils.decrypt((String)environment.getProperty("db.master.username"));
        this.dbPassword = EncryptUtils.decrypt((String)environment.getProperty("db.master.password"));
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String[] dbUrlSplit(String dbUrl) {
        String[] returnStr = new String[3];
        String[] tmp1 = dbUrl.split("/");
        String[] tmp2 = tmp1[2].split(":");
        returnStr[0] = tmp2[0];
        returnStr[1] = tmp2[1];
        tmp2 = tmp1[3].split("\\?");
        returnStr[2] = tmp2[0];
        return returnStr;
    }
}

