/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.service.manager;

import com.xdja.pki.backup.common.Result;
import com.xdja.pki.backup.dao.BackupConfigDao;
import com.xdja.pki.backup.dao.model.BackupConfigDO;
import com.xdja.pki.backup.service.manager.BackupConfigService;
import com.xdja.pki.backup.service.manager.bean.BackupConfigReq;
import com.xdja.pki.backup.service.manager.bean.BackupConfigVO;
import com.xdja.pki.backup.util.ConfigUtils;
import com.xdja.pki.cache.RedisClient;
import com.xdja.pki.core.constants.RedisKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackupConfigServiceImpl
implements BackupConfigService {
    private Logger logger = LoggerFactory.getLogger(BackupConfigServiceImpl.class);
    @Autowired
    private BackupConfigDao backupConfigDao;
    @Autowired
    private RedisClient redisClient;

    @Override
    public Result updateBackupConfig(BackupConfigReq backupConfigReq) {
        Result result = new Result();
        BackupConfigDO backupConfigDO = new BackupConfigDO();
        BeanUtils.copyProperties((Object)backupConfigReq, (Object)backupConfigDO);
        BackupConfigDO backupConfigDoFromJson = this.backupConfigDao.getBackupConfig();
        backupConfigDO.setBackupPath(backupConfigDoFromJson.getBackupPath());
        backupConfigDO.setRecoverPath(backupConfigDoFromJson.getRecoverPath());
        this.backupConfigDao.saveBackupConfig(backupConfigDO);
        this.logger.debug("\u901a\u77e5schedule\u670d\u52a1\uff0c\u5b9a\u65f6\u8c03\u5ea6\u4efb\u52a1\u914d\u7f6e\u53d8\u66f4:[{}]:[{}]", (Object)RedisKey.CHANNEL_SYSTEM_NOTICE, (Object)"notice:backup.config.changed");
        this.redisClient.publish(RedisKey.CHANNEL_SYSTEM_NOTICE, "notice:backup.config.changed");
        return result;
    }

    @Override
    public Result getBackupConfigForView() {
        Result result = new Result();
        BackupConfigVO backupConfigVo = new BackupConfigVO();
        BeanUtils.copyProperties((Object)this.getBackupConfigModel(), (Object)backupConfigVo);
        result.setInfo(backupConfigVo);
        return result;
    }

    @Override
    public BackupConfigDO getBackupConfigModel() {
        BackupConfigDO backupConfigDO;
        try {
            backupConfigDO = this.backupConfigDao.getBackupConfig();
        }
        catch (RuntimeException e) {
            this.logger.error("\u5907\u4efd\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\u521b\u5efa\u914d\u7f6e\u6587\u4ef6\u3002");
            backupConfigDO = new BackupConfigDO();
            String[] filePath = ConfigUtils.getSysConfPath().split("/");
            backupConfigDO.setBackupPath("/home/xdja/backup/" + filePath[4]);
            backupConfigDO.setRecoverPath("/home/xdja/recover/" + filePath[4]);
            backupConfigDO.setIsOpenAutoBackup(0);
            backupConfigDO.setFileRetentionPeriod(2);
            backupConfigDO.setTotalBackupPeriod(1);
            backupConfigDO.setIncBackupPeriod(1);
            this.backupConfigDao.saveBackupConfig(backupConfigDO);
        }
        return backupConfigDO;
    }
}

