/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.backup.web.manager;

import com.xdja.pki.auditlog.service.bean.ra.AuditLogOperatorTypeEnum;
import com.xdja.pki.auth.annotation.AuditLogSign;
import com.xdja.pki.auth.service.bean.AuditSignBean;
import com.xdja.pki.backup.common.ErrorBean;
import com.xdja.pki.backup.common.ErrorEnum;
import com.xdja.pki.backup.common.Result;
import com.xdja.pki.backup.dao.model.BackupDO;
import com.xdja.pki.backup.service.manager.BackupService;
import com.xdja.pki.backup.service.manager.bean.BackupReq;
import com.xdja.pki.backup.util.JsonUtils;
import com.xdja.pki.core.bean.CoreResult;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BackupController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BackupService backupService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditLogSign
    @RequestMapping(value={"/v1/system/backup/download/{id}"}, method={RequestMethod.GET})
    public Object download(@PathVariable String id, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("download() >>>>>> id:[{}]", (Object)id);
        try {
            result = this.backupService.downloadBackupFile(id);
        }
        catch (Exception e) {
            this.logger.error("download() >>>>>> id:[" + id + "]", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            logContent.append("\u4e0b\u8f7d\u6587\u4ef6\u3010\u5931\u8d25\u3011");
        } else {
            BufferedInputStream fis = null;
            try {
                int read;
                BackupDO backupDO = (BackupDO)result.getInfo();
                result.setInfo(null);
                logContent.append("\u4e0b\u8f7d\u6587\u4ef6\u3010\u6210\u529f\u3011\uff0c\u6587\u4ef6\u540d=").append(backupDO.getBackupName());
                String[] filePath = backupDO.getBackupFilePath().split("/");
                resp.setContentType("application/octet-stream");
                resp.setCharacterEncoding("UTF-8");
                resp.setHeader("Content-Disposition", "attachment; filename=" + filePath[filePath.length - 1]);
                ServletOutputStream out = resp.getOutputStream();
                fis = new BufferedInputStream(new FileInputStream(backupDO.getBackupFilePath()));
                byte[] bytes = new byte[1024];
                while ((read = fis.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
                out.flush();
                out.close();
            }
            catch (FileNotFoundException e) {
                this.logger.error("download() >>>>>>\u5907\u4efd\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
                ErrorBean errorBean = ErrorEnum.BACKUP_DOWNLOAD_NO_SUCH_FILE.resp(resp);
                return errorBean;
            }
            catch (Exception e) {
                this.logger.error("download() >>>>>>\u8f93\u51fa\u5907\u4efd\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                ErrorBean errorBean = ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
                return errorBean;
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e) {
                    this.logger.error("download() >>>>>>\u5173\u95ed\u4e0b\u8f7d\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        CoreResult coreResult = CoreResult.getCoreResultInstance((Object)JsonUtils.object2Json(result), (int)AuditLogOperatorTypeEnum.SYSTEM_BACKUP_MANAGEMENT.type, (String)logContent.toString());
        this.logger.info("download()<<<<<<<");
        return coreResult;
    }

    @AuditLogSign
    @RequestMapping(value={"/v1/system/backup/doBackup"}, method={RequestMethod.POST})
    public Object doBackup(@RequestBody BackupReq backupReq, BindingResult bindResult, AuditSignBean bean, HttpServletResponse resp) {
        Result result;
        this.logger.info("doBackup()>>>>>>backupReq:[{}]", (Object)JsonUtils.object2Json(backupReq));
        if (bindResult.hasErrors()) {
            if (this.logger.isWarnEnabled()) {
                StringBuilder content = new StringBuilder();
                for (FieldError item : bindResult.getFieldErrors()) {
                    content.append(item.getField()).append("=").append(item.getDefaultMessage()).append(",");
                }
                this.logger.info("\u624b\u52a8\u5907\u4efd\u65f6\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5\uff0c\u539f\u56e0\uff1a[{}]", (Object)content.substring(0, content.length() - 1));
            }
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.backupService.goBackup(backupReq);
        }
        catch (Exception e) {
            this.logger.error("\u624b\u52a8\u5907\u4efd\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        StringBuilder logContent = new StringBuilder();
        if (!result.isSuccess()) {
            logContent.append("\u624b\u5de5\u5907\u4efd\u64cd\u4f5c\u5931\u8d25\uff0c\u5907\u4efd\u7c7b\u578b\uff1a");
        } else {
            logContent.append("\u624b\u5de5\u5907\u4efd\u64cd\u4f5c\u6210\u529f\uff0c\u5907\u4efd\u7c7b\u578b\uff1a");
        }
        if (0 == backupReq.getBackupType()) {
            logContent.append("\u5168\u91cf\u5907\u4efd");
        } else {
            logContent.append("\u589e\u91cf\u5907\u4efd");
        }
        CoreResult coreResult = CoreResult.getCoreResultInstance((Object)JsonUtils.object2Json(result), (int)AuditLogOperatorTypeEnum.SYSTEM_BACKUP_MANAGEMENT.type, (String)logContent.toString());
        this.logger.info("doBackup()<<<<<result:{}", (Object)JsonUtils.object2Json(result));
        return coreResult;
    }

    @RequestMapping(value={"/v1/system/backup/exitBackupOperate"}, method={RequestMethod.GET})
    public Object exitBackupOperate(@RequestParam(value="backupType") Integer backupType, HttpServletResponse resp) {
        Result result;
        this.logger.info("exitBackupOperate()>>>>>>");
        if (backupType == null) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        try {
            result = this.backupService.exitBackupOperate(backupType);
        }
        catch (Exception e) {
            this.logger.error("\u624b\u52a8\u5907\u4efd\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("exitBackupOperate()<<<<<result:{}", (Object)JsonUtils.object2Json(result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/system/backup/total"}, method={RequestMethod.GET})
    public Object total(@RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize, HttpServletResponse resp) {
        Result result;
        this.logger.info("total()>>>>>>pageNo:[{}] pageSize:[{}]", (Object)pageNo, (Object)pageSize);
        try {
            result = this.backupService.getTotalBackupByPage(pageNo, pageSize);
        }
        catch (Exception e) {
            this.logger.error("\u5206\u9875\u83b7\u53d6\u5168\u91cf\u5907\u4efd\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("total()<<<<<result:{}", (Object)JsonUtils.object2Json(result));
        return result.getInfo();
    }

    @RequestMapping(value={"/v1/system/backup/inc/{id}"}, method={RequestMethod.GET})
    public Object inc(@PathVariable Long id, HttpServletResponse resp) {
        Result result;
        this.logger.info("inc()>>>>>>parentId:[{}] id", (Object)id);
        try {
            result = this.backupService.getIncBackupByPage(id);
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u5168\u91cf\u5907\u4efd\u8bb0\u5f55ID\u83b7\u53d6\u589e\u91cf\u5907\u4efd\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
        }
        if (!result.isSuccess()) {
            return result.resp(resp, result);
        }
        this.logger.info("inc()<<<<<result:{}", (Object)JsonUtils.object2Json(result));
        return result.getInfo();
    }
}

