/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.monitor.task;

import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.monitor.bean.CpuData;
import com.xdja.pki.monitor.dao.MonitorCpuDao;
import com.xdja.pki.monitor.dao.model.MonitorCpuDO;
import com.xdja.pki.monitor.service.MonitorService;
import java.math.BigDecimal;
import java.sql.Timestamp;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Configurable
@EnableScheduling
public class PropertyTask {
    private static final Logger log = LoggerFactory.getLogger(PropertyTask.class);
    @Autowired
    private MonitorService monitorService;
    @Resource
    private MonitorCpuDao monitorCpuDao;

    @Scheduled(cron="${task.monitor.cpu.cron:0 */15 * * * ?}")
    public void monitorCpuForQuarter() {
        long current = System.currentTimeMillis();
        log.info("[PropertyTask#monitorCpuForQuarter]");
        CoreResult result = this.monitorService.monitorCpu(current);
        if (result.getInfo() != null) {
            CpuData cpuData = (CpuData)result.getInfo();
            this.monitorCpuDao.insertMonitorCpuData(new MonitorCpuDO(BigDecimal.valueOf(cpuData.getUsage()).setScale(5, 4), new Timestamp(current)));
        }
    }
}

