/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.monitor.collector;

import com.xdja.pki.monitor.bean.CpuData;
import com.xdja.pki.monitor.collector.AbstractCollector;
import com.xdja.pki.monitor.collector.CollectCallBack;
import com.xdja.pki.monitor.util.MonitorUtil;

public class CpuDataCollector
extends AbstractCollector<CpuData> {
    @Override
    void process(CollectCallBack<CpuData> callBack) {
        int osType = this.getOsType();
        try {
            if (osType == 2) {
                double cpuRate = MonitorUtil.monitorCpuRateForLinux().setScale(2, 4).doubleValue();
                CpuData cpuData = new CpuData(cpuRate, System.currentTimeMillis());
                if (callBack != null) {
                    callBack.onSuccess(cpuData);
                }
            } else {
                CpuData cpuData = MonitorUtil.monitorCpuByJdk();
                if (callBack != null) {
                    callBack.onSuccess(cpuData);
                }
            }
        }
        catch (Exception e) {
            if (callBack != null) {
                this.log.error("CpuData collector error,msg:", (Throwable)e);
            }
            this.log.info("[CpuDataCollector#process] error!", (Throwable)e);
        }
    }
}

