/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.monitor.util;

import java.math.BigDecimal;

public class BigDecimalUtil {
    private static final int DEF_DIV_SCALE = 5;

    public static double add(double value1, double value2) {
        return BigDecimalUtil.add(BigDecimal.valueOf(value1), BigDecimal.valueOf(value2)).doubleValue();
    }

    public static double add(String value1, String value2) {
        return BigDecimalUtil.add(new BigDecimal(value1), new BigDecimal(value2)).doubleValue();
    }

    public static BigDecimal add(BigDecimal value1, BigDecimal value2) {
        return value1.add(value2);
    }

    public static double sub(double value1, double value2) {
        return BigDecimalUtil.subtract(BigDecimal.valueOf(value1), BigDecimal.valueOf(value2)).doubleValue();
    }

    public static double sub(String value1, String value2) {
        return BigDecimalUtil.subtract(new BigDecimal(value1), new BigDecimal(value2)).doubleValue();
    }

    public static BigDecimal subtract(BigDecimal value1, BigDecimal value2) {
        return value1.subtract(value2);
    }

    public static double mul(double value1, double value2) {
        return BigDecimalUtil.multiply(BigDecimal.valueOf(value1), BigDecimal.valueOf(value2)).doubleValue();
    }

    public static double mul(String value1, String value2) {
        return BigDecimalUtil.multiply(new BigDecimal(value1), new BigDecimal(value2)).doubleValue();
    }

    public static BigDecimal multiply(BigDecimal value1, BigDecimal value2) {
        return value1.multiply(value2);
    }

    public static double div(double value1, double value2) throws IllegalAccessException {
        return BigDecimalUtil.divide(BigDecimal.valueOf(value1), BigDecimal.valueOf(value2), 5).doubleValue();
    }

    public static BigDecimal div(long value1, long value2) {
        try {
            return BigDecimalUtil.divide(BigDecimal.valueOf(value1), BigDecimal.valueOf(value2), 5);
        }
        catch (IllegalAccessException e) {
            return new BigDecimal(0);
        }
    }

    public static double div(String value1, String value2) throws IllegalAccessException {
        return BigDecimalUtil.divide(new BigDecimal(value1), new BigDecimal(value2), 5).doubleValue();
    }

    public static BigDecimal div(BigDecimal value1, BigDecimal value2) throws IllegalAccessException {
        return BigDecimalUtil.divide(value1, value2, 5);
    }

    public static BigDecimal divide(BigDecimal value1, BigDecimal value2, int scale) throws IllegalAccessException {
        if (scale < 0) {
            throw new IllegalAccessException("\u7cbe\u786e\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        return value1.divide(value2, scale, 4);
    }

    public static double round(double v, int scale) {
        try {
            return BigDecimalUtil.divide(BigDecimal.valueOf(v), new BigDecimal(1), scale).doubleValue();
        }
        catch (IllegalAccessException e) {
            return 0.0;
        }
    }

    public static double round(String v, int scale) throws IllegalAccessException {
        return BigDecimalUtil.divide(new BigDecimal(v), new BigDecimal(1), scale).doubleValue();
    }

    public static boolean equalTo(BigDecimal b1, BigDecimal b2) {
        if (b1 == null || b2 == null) {
            return false;
        }
        return 0 == b1.compareTo(b2);
    }
}

