/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.monitor.service;

import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.core.bean.ErrorBean;
import com.xdja.pki.core.utils.DateUtils;
import com.xdja.pki.monitor.bean.CpuData;
import com.xdja.pki.monitor.bean.DiskData;
import com.xdja.pki.monitor.bean.MemoryData;
import com.xdja.pki.monitor.bean.NicData;
import com.xdja.pki.monitor.bean.SystemRuntimeData;
import com.xdja.pki.monitor.collector.CollectCallBack;
import com.xdja.pki.monitor.collector.Collector;
import com.xdja.pki.monitor.common.ErrorEnum;
import com.xdja.pki.monitor.dao.MonitorCpuDao;
import com.xdja.pki.monitor.dao.model.MonitorCpuDO;
import com.xdja.pki.monitor.factory.CollectorFactory;
import com.xdja.pki.monitor.service.MonitorService;
import com.xdja.pki.monitor.service.bean.MonitorCpuVO;
import com.xdja.pki.monitor.util.MonitorUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class MonitorServiceImpl
implements MonitorService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(MonitorServiceImpl.class);
    @Resource
    private MonitorCpuDao monitorCpuDao;
    private Collector<CpuData> cpuCollector;
    private Collector<DiskData> diskCollector;
    private Collector<MemoryData> memoryCollector;
    private Collector<NicData> nickCollector;
    private Collector<SystemRuntimeData> systemRunTimeCollector;

    public void afterPropertiesSet() throws Exception {
        this.cpuCollector = CollectorFactory.createCollector(CpuData.class);
        this.diskCollector = CollectorFactory.createCollector(DiskData.class);
        this.memoryCollector = CollectorFactory.createCollector(MemoryData.class);
        this.nickCollector = CollectorFactory.createCollector(NicData.class);
        this.systemRunTimeCollector = CollectorFactory.createCollector(SystemRuntimeData.class);
    }

    @Override
    public CoreResult monitorMemoryData(final long current) {
        final MemoryData[] memoryData = new MemoryData[]{new MemoryData()};
        this.memoryCollector.doCollect(new CollectCallBack<MemoryData>(){

            @Override
            public void onSuccess(MemoryData data) {
                memoryData[0] = data;
            }

            @Override
            public void onError(String errorMsg) {
                log.warn("[MonitorServiceImpl#monitorMemoryData]{}| call CollectCallBack fail,{}.", (Object)current, (Object)errorMsg);
                memoryData[0] = null;
            }
        });
        if (memoryData[0] == null) {
            log.info("[MonitorServiceImpl#monitorMemoryData]{}| call AbstractCollector.process error .", (Object)current);
            return CoreResult.failure((ErrorBean)ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
        }
        return CoreResult.success((Object)memoryData[0]);
    }

    @Override
    public CoreResult monitorDiskData(final long current) {
        final DiskData[] diskData = new DiskData[]{new DiskData()};
        this.diskCollector.doCollect(new CollectCallBack<DiskData>(){

            @Override
            public void onSuccess(DiskData data) {
                diskData[0] = data;
            }

            @Override
            public void onError(String errorMsg) {
                log.info("[MonitorServiceImpl#monitorDiskData]{}| call AbstractCollector.process error {}.", (Object)current, (Object)errorMsg);
                diskData[0] = null;
            }
        });
        if (diskData[0] == null) {
            log.info("[MonitorServiceImpl#monitorDiskData]{}| call AbstractCollector.process error .", (Object)current);
            return CoreResult.failure((ErrorBean)ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
        }
        return CoreResult.success((Object)diskData[0]);
    }

    @Override
    public CoreResult getCpuData(long current) {
        List<MonitorCpuDO> monitorCpuList = this.monitorCpuDao.queryRecentThreeHourData(current);
        if (CollectionUtils.isEmpty(monitorCpuList)) {
            return CoreResult.success((Object)CollectionUtils.EMPTY_COLLECTION);
        }
        List<MonitorCpuVO> dataList = this.convertData(monitorCpuList);
        CoreResult result = CoreResult.success(dataList);
        log.info("[MonitorServiceImpl#getCpuData]{}| result-->{}.", (Object)current, (Object)result);
        return result;
    }

    @Override
    public CoreResult monitorCpu(final long current) {
        final CpuData[] cpuData = new CpuData[]{new CpuData()};
        this.cpuCollector.doCollect(new CollectCallBack<CpuData>(){

            @Override
            public void onSuccess(CpuData data) {
                cpuData[0] = data;
            }

            @Override
            public void onError(String errorMsg) {
                log.warn("[MonitorServiceImpl#monitorCpu]{}| call CollectCallBack fail,{}.", (Object)current, (Object)errorMsg);
                cpuData[0] = null;
            }
        });
        log.info("[MonitorServiceImpl#monitorCpu]{}|{}.", (Object)current, (Object)cpuData[0]);
        return CoreResult.success((Object)cpuData[0]);
    }

    @Override
    public CoreResult monitorSystemRunTimeData(final long current) {
        final SystemRuntimeData[] systemRuntimeData = new SystemRuntimeData[]{new SystemRuntimeData()};
        this.systemRunTimeCollector.doCollect(new CollectCallBack<SystemRuntimeData>(){

            @Override
            public void onSuccess(SystemRuntimeData data) {
                systemRuntimeData[0] = data;
            }

            @Override
            public void onError(String errorMsg) {
                log.warn("[MonitorServiceImpl#monitorSystemRunTimeData]{}| call AbstractCollector.process error {}.", (Object)current, (Object)errorMsg);
                systemRuntimeData[0] = null;
            }
        });
        if (systemRuntimeData[0] == null) {
            log.info("[MonitorServiceImpl#monitorSystemRunTimeData]{}| call AbstractCollector.process error .", (Object)current);
            return CoreResult.failure((ErrorBean)ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(4);
        resultMap.put("runTime", MonitorUtil.secondToDate(systemRuntimeData[0].getRuntime()));
        resultMap.put("lastCollectTime", DateUtils.longToStr((long)current));
        return CoreResult.success(resultMap);
    }

    @Override
    public CoreResult monitorNickData(final long current) {
        final NicData[] nicData = new NicData[]{new NicData()};
        this.nickCollector.doCollect(new CollectCallBack<NicData>(){

            @Override
            public void onSuccess(NicData data) {
                nicData[0] = data;
            }

            @Override
            public void onError(String errorMsg) {
                log.warn("[MonitorServiceImpl#monitorNickData]{}| call AbstractCollector.process error {}.", (Object)current, (Object)errorMsg);
                nicData[0] = null;
            }
        });
        if (nicData[0] == null) {
            log.info("[MonitorServiceImpl#monitorNickData]{}| call AbstractCollector.process error .", (Object)current);
            return CoreResult.failure((ErrorBean)ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
        }
        return CoreResult.success((Object)nicData[0]);
    }

    private List<MonitorCpuVO> convertData(List<MonitorCpuDO> monitorCpuList) {
        ArrayList<MonitorCpuVO> dataList = new ArrayList<MonitorCpuVO>(monitorCpuList.size());
        for (MonitorCpuDO monitorCpuDO : monitorCpuList) {
            dataList.add(new MonitorCpuVO(monitorCpuDO.getUtilization().setScale(2, 4), DateUtils.dateToString((Date)monitorCpuDO.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss")));
        }
        return dataList;
    }
}

