/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.monitor.web.manager;

import com.xdja.pki.core.bean.CoreResult;
import com.xdja.pki.core.bean.ErrorBean;
import com.xdja.pki.monitor.common.ErrorEnum;
import com.xdja.pki.monitor.service.MonitorService;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MonitorSystemController {
    private final Logger log = LoggerFactory.getLogger(MonitorSystemController.class);
    @Autowired
    private MonitorService monitorService;

    @PostMapping(value={"/v1/monitor/getMemoryData"})
    public Object getMemoryData(HttpServletResponse resp) {
        CoreResult result;
        long current = System.currentTimeMillis();
        try {
            result = this.monitorService.monitorMemoryData(current);
        }
        catch (Exception e) {
            this.log.warn("[MonitorSystemController#getMemoryData] error", (Throwable)e);
            return CoreResult.failure((ErrorBean)ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
        }
        this.log.info("[MonitorSystemController#getMemoryData]|{}|{}", (Object)current, (Object)result);
        return result.getInfo();
    }

    @PostMapping(value={"/v1/monitor/getDiskData"})
    public Object getDiskData(HttpServletResponse resp) {
        CoreResult result;
        long current = System.currentTimeMillis();
        try {
            result = this.monitorService.monitorDiskData(current);
        }
        catch (Exception e) {
            this.log.warn("[MonitorSystemController#getDiskData] error", (Throwable)e);
            return CoreResult.failure((ErrorBean)ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
        }
        this.log.info("[MonitorSystemController#getDiskData]|{}|{}", (Object)current, (Object)result);
        return result.getInfo();
    }

    @PostMapping(value={"/v1/monitor/getCpuData"})
    public Object getCpuData(HttpServletResponse resp) {
        CoreResult result;
        long current = System.currentTimeMillis();
        try {
            result = this.monitorService.getCpuData(current);
        }
        catch (Exception e) {
            this.log.warn("[MonitorSystemController#getCpuData] error", (Throwable)e);
            return CoreResult.failure((ErrorBean)ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
        }
        this.log.info("[MonitorSystemController#getCpuData]|{}|{}", (Object)current, (Object)result);
        return result.getInfo();
    }

    @PostMapping(value={"/v1/monitor/getSystemRunTimeData"})
    public Object getSystemRunTimeData(HttpServletResponse resp) {
        CoreResult result;
        long current = System.currentTimeMillis();
        try {
            result = this.monitorService.monitorSystemRunTimeData(current);
        }
        catch (Exception e) {
            this.log.warn("[MonitorSystemController#getSystemRunTimeData] error", (Throwable)e);
            return CoreResult.failure((ErrorBean)ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
        }
        this.log.info("[MonitorSystemController#getSystemRunTimeData]|{}|{}", (Object)current, (Object)result);
        return result.getInfo();
    }

    @PostMapping(value={"/v1/monitor/getNicData"})
    public Object getNicData(HttpServletResponse resp) {
        CoreResult result;
        long current = System.currentTimeMillis();
        try {
            result = this.monitorService.monitorNickData(current);
        }
        catch (Exception e) {
            this.log.warn("[MonitorSystemController#getNicData] error", (Throwable)e);
            return CoreResult.failure((ErrorBean)ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp());
        }
        this.log.info("[MonitorSystemController#getNicData]|{}|{}", (Object)current, (Object)result);
        return result.getInfo();
    }
}

