package com.xdja.pki.dynamic.task;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/**
 * @Description: TODO
 * @Author: songxuetao
 * @ModifiedBy:
**/
@Configuration
public class ScheduledConfig implements SchedulingConfigurer {

	/**
	 * 调度任务线程池线程数量
	 */
	@Value("${task.thread.pool.size}")
	private int poolSize;

	@Override
	public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
		scheduledTaskRegistrar.setScheduler(setTaskExecutors());
	}

	/**
	 * 设置任务执行器线程池线程数量
	 *
	 * @return
	 */
	@Bean
	public Executor setTaskExecutors() {
		return Executors.newScheduledThreadPool(poolSize);
	}


	/**
	 * @MethodName: taskScheduler
	 * @Description: 用于动态定时任务的调用
	 * @Return: org.springframework.scheduling.TaskScheduler
	 * @Author: songxuetao
	**/
	@Bean
	public TaskScheduler taskScheduler() {
		ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
		// 定时任务执行线程池核心线程数，此处设为2，是暂时用于自动归档操作日志（动态）和备份恢复，后续可扩展
		taskScheduler.setPoolSize(2);
		taskScheduler.setRemoveOnCancelPolicy(true);
		taskScheduler.setThreadNamePrefix("TaskSchedulerThreadPool-");
		return taskScheduler;
	}
}
