/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.exception;

import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.RAJsonException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={Exception.class})
    public Object handleException(Exception exception, HttpServletResponse resp) {
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7-\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef", (Throwable)exception);
        return ErrorEnum.SERVER_INTERNAL_EXCEPTION.resp(resp);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Object handleException(HttpMessageNotReadableException exception, HttpServletResponse resp) {
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7-\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    public Object handleException(TypeMismatchException exception, HttpServletResponse resp) {
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7-\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Object handleException(MissingServletRequestParameterException exception, HttpServletResponse resp) {
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7-\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Object handleException(IllegalArgumentException exception, HttpServletResponse resp) {
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7-\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Object handleException(HttpRequestMethodNotSupportedException exception, HttpServletResponse resp) {
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7-\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5408\u6cd5", (Throwable)exception);
        return ErrorEnum.REQUEST_METHOD_NOT_SUPPORTED.resp(resp);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Object handleException(HttpMediaTypeNotSupportedException exception, HttpServletResponse resp) {
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7-\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5408\u6cd5", (Throwable)exception);
        return ErrorEnum.REQUEST_METHOD_NOT_SUPPORTED.resp(resp);
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    public Object handleException(ServletRequestBindingException exception, HttpServletResponse resp) {
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7-\u8bf7\u6c42\u53c2\u6570\u975e\u6cd5", (Throwable)exception);
        return ErrorEnum.MISSING_REQUIRED_PARAMETERS.resp(resp);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Object handleException(NoHandlerFoundException exception, HttpServletRequest request, HttpServletResponse resp) {
        this.logger.error(String.format("\u5168\u5c40\u5f02\u5e38\u6355\u83b7-\u3010{}\u3011\u8bf7\u6c42\u7684URI\u4e0d\u5b58\u5728", request.getRemoteHost()), (Throwable)exception);
        return ErrorEnum.URI_NOT_EXIST.resp(resp);
    }

    @ExceptionHandler(value={RAJsonException.class})
    public Object handleException(RAJsonException exception, HttpServletResponse resp) {
        this.logger.error("\u5168\u5c40\u5f02\u5e38\u6355\u83b7-\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u975e\u6cd5", (Throwable)exception);
        return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
    }
}

