/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.ra.core.exception.DAOException;
import com.xdja.pki.ra.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.AuditLogDO;
import com.xdja.pki.ra.manager.dao.model.AuditLogListDO;
import com.xdja.pki.ra.manager.page.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.stereotype.Repository;

@Repository
public class AuditLogDao
extends BaseJdbcDao {
    public AuditLogDO saveLog(AuditLogDO logDO) {
        return (AuditLogDO)this.daoTemplate.insert((Object)logDO);
    }

    public AuditLogDO getLogById(int id) {
        Cnd cnd = Cnd.where((String)"id", (String)"=", (Object)id);
        cnd.orderBy("gmt_create", "desc");
        try {
            List list = this.daoTemplate.query(AuditLogDO.class, (Condition)cnd);
            if (list.size() != 1) {
                throw new DAOException("\u6839\u636eID\u83b7\u53d6\u5230:" + list.size() + "\u4e2a\u6570\u636e!");
            }
            return (AuditLogDO)list.get(0);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636eid\u67e5\u8be2\u5ba1\u8ba1\u65e5\u5fd7\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int updateLog(AuditLogDO logDO) {
        return this.daoTemplate.update((Object)logDO);
    }

    public Object getLogList(Integer pageNo, Integer pageSize, String operatorSubject, Integer operatorType, Integer isAudit, String startTime, String endTime) {
        Cnd cnd = Cnd.NEW();
        if (StringUtils.isNotBlank((CharSequence)operatorSubject)) {
            cnd.and("operator_subject", "LIKE", (Object)("%" + operatorSubject + "%"));
        }
        if (null != operatorType) {
            cnd.and("operator_type", "=", (Object)operatorType);
        }
        if (null != isAudit) {
            cnd.and("is_audit", "=", (Object)isAudit);
        }
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            cnd.and("gmt_create", ">=", (Object)(startTime + " 00:00:00"));
            cnd.and("gmt_create", "<=", (Object)(endTime + " 23:59:59"));
        }
        cnd.orderBy("id", "desc");
        try {
            if (pageNo == 0 && pageSize == 0) {
                return this.daoTemplate.query(AuditLogListDO.class, (Condition)cnd);
            }
            PageInfo pageInfo = new PageInfo(pageNo, pageSize, this.daoTemplate.count(AuditLogListDO.class, (Condition)cnd));
            pageInfo.setList(this.daoTemplate.query(AuditLogListDO.class, (Condition)cnd, this.createPager(pageNo, pageSize)));
            this.logger.debug("list page info {} ", pageInfo);
            return pageInfo;
        }
        catch (Exception e) {
            throw new DAOException("\u5206\u9875\u67e5\u8be2\u6a21\u677f\u4fe1\u606f\u5217\u8868\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }
}

