/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dto.SystemInfo;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class BaseUserDao
extends BaseJdbcDao {
    public String getSystemNameByFlag(String systemFlag) {
        String sql = "SELECT customer_sys_name FROM customer_sys WHERE customer_sys_number = :systemFlag";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("systemFlag", (Object)systemFlag);
        return this.daoTemplate.queryForString(sql, (SqlParameterSource)params);
    }

    public String getSystemFlagByName(String systemName) {
        String sql = "SELECT customer_sys_number FROM customer_sys WHERE customer_sys_name = :systemName";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("systemName", (Object)systemName);
        return this.daoTemplate.queryForString(sql, (SqlParameterSource)params);
    }

    public int querySystemName(String systemName) {
        String sql = "SELECT COUNT(*) FROM customer_sys WHERE customer_sys_name = :systemName";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("systemName", (Object)systemName);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public List<SystemInfo> getAllSystemName() {
        String sql = "SELECT customer_sys_name AS systemName, customer_sys_number AS systemFalg FROM customer_sys WHERE is_inner != 1  ";
        return this.daoTemplate.queryForList(sql, null, (RowMapper)BeanPropertyRowMapper.newInstance(SystemInfo.class));
    }

    public String getLicenseNumberById(long userId) {
        String sql = "SELECT license_number from base_user where id = :userId";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("userId", (Object)userId);
        return this.daoTemplate.queryForString(sql, (SqlParameterSource)params);
    }

    public BaseUserDO addApplyRecord(BaseUserDO baseUserDO) {
        return (BaseUserDO)this.daoTemplate.insert((Object)baseUserDO);
    }

    public int updateBaseUser(BaseUserDO baseUserDO) {
        return this.daoTemplate.updateIgnoreNull((Object)baseUserDO);
    }

    public int queryUser(Integer licenseType, String licenseNumber, Integer userType, String systemFlag, int personId) {
        systemFlag = systemFlag == null ? Constants.SYSTEM_FLAG_DEFAULT : systemFlag;
        String sql = "SELECT count(*)  FROM base_user b,person_user p WHERE p.user_id = b.id  AND b.license_number = :licenseNumber AND b.license_type = :licenseType AND b.user_type = :userType AND b.system_flag = :systemFlag AND p.user_id != :personId";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("licenseType", (Object)licenseType);
        params.addValue("licenseNumber", (Object)licenseNumber);
        params.addValue("userType", (Object)userType);
        params.addValue("systemFlag", (Object)systemFlag);
        params.addValue("personId", (Object)personId);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public int queryUser(Integer licenseType, String licenseNumber, Integer userType, String systemFlag) {
        systemFlag = systemFlag == null ? Constants.SYSTEM_FLAG_DEFAULT : systemFlag;
        String sql = "SELECT count(*)  FROM base_user WHERE license_number = :licenseNumber AND license_type = :licenseType AND user_type = :userType AND system_flag = :systemFlag ";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("licenseType", (Object)licenseType);
        params.addValue("licenseNumber", (Object)licenseNumber);
        params.addValue("userType", (Object)userType);
        params.addValue("systemFlag", (Object)systemFlag);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public boolean isAuthorize(String systemFlag, Integer userId) {
        String sql = "SELECT count(*) From base_user WHERE id = :userId AND system_flag = :systemFlag";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("userId", (Object)userId);
        params.addValue("systemFlag", (Object)systemFlag);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params) == 1;
    }

    public boolean isAuthorize(String systemFlag, String certSn) {
        String sql = "SELECT count(*) FROM base_user a left join user_cert b ON a.id = b.user_id WHERE a.system_flag = :systemFlag AND b.cert_sn = :certSn ";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("systemFlag", (Object)systemFlag);
        params.addValue("certSn", (Object)certSn);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params) == 1;
    }

    public boolean isAuthorizeByApplyNo(String systemFlag, String applyNo) {
        String sql = "SELECT count(*) FROM base_user a left join cert_apply b ON a.id = b.user_id WHERE a.system_flag = :systemFlag AND b.apply_no = :applyNo ";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("systemFlag", (Object)systemFlag);
        params.addValue("applyNo", (Object)applyNo);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params) == 1;
    }

    public Long getUserId(int userType, String systemFlag, Integer licenseType, String licenseNumber) {
        try {
            String sql = "select id from base_user where system_flag = :systemFlag AND user_type = :userType AND license_number = :licenseNumber AND license_type = :licenseType ";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("userType", (Object)userType);
            params.addValue("systemFlag", (Object)systemFlag);
            params.addValue("licenseNumber", (Object)licenseNumber);
            params.addValue("licenseType", (Object)licenseType);
            return this.daoTemplate.queryForLong(sql, (SqlParameterSource)params);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public int updateUser(Long id, Integer licenseType, String licenseNumber) {
        String sql = "SELECT count(*)  FROM organ_user WHERE license_number = :licenseNumber AND license_type = :licenseType AND id != :id";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("licenseType", (Object)licenseType);
        params.addValue("licenseNumber", (Object)licenseNumber);
        params.addValue("id", (Object)id);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public int countUser(long deviceId, Integer licenseType, String licenseNumber) {
        String sql = "SELECT count(*)  FROM person_user WHERE license_number = :licenseNumber AND license_type = :licenseType AND user_id != :deviceId;";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("licenseType", (Object)licenseType);
        params.addValue("licenseNumber", (Object)licenseNumber);
        params.addValue("deviceId", (Object)deviceId);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public BaseUserDO saveBaseUserInfo(BaseUserDO baseUser) {
        return (BaseUserDO)this.daoTemplate.insert((Object)baseUser);
    }

    public int updateBaseUserInfo(BaseUserDO baseUserDO) {
        return this.daoTemplate.update((Object)baseUserDO);
    }

    public int updateUserStatus(Integer userId, int status) {
        String sql = "UPDATE base_user SET status = :status WHERE id = :userId";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("status", (Object)status);
        params.addValue("userId", (Object)userId);
        return this.daoTemplate.update(sql, (SqlParameterSource)params);
    }

    public long getId(Integer userType, Integer identType, String licenseNumber) {
        String sql = "SELECT id from base_user where user_type = :userType and license_type = :licenseType and license_number = :licenseNumber";
        try {
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("licenseType", (Object)identType);
            params.addValue("licenseNumber", (Object)licenseNumber);
            params.addValue("userType", (Object)userType);
            return this.daoTemplate.queryForLong(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public BaseUserDO getBaseUserInfo(long userId) {
        try {
            return (BaseUserDO)this.daoTemplate.fetch(BaseUserDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)userId));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public BaseUserDO getBaseUserInfo(long userId, String systemFlag) {
        try {
            return (BaseUserDO)this.daoTemplate.fetch(BaseUserDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)userId).and("system_flag", "=", (Object)systemFlag));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public BaseUserDO queryUserByUserType(String licenseNumber, int userType) {
        String sql = "SELECT id as id , user_no AS userNo, user_name AS userName, license_number , license_type AS licenseType, user_type AS userType,status AS status,system_flag AS systemFlag FROM base_user WHERE license_number = :licenseNumber  AND user_type =:userType AND system_flag = 'V2X' ";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("licenseNumber", (Object)licenseNumber);
        params.addValue("userType", (Object)userType);
        return (BaseUserDO)this.daoTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(BaseUserDO.class));
    }
}

