/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.CustomerSysCertDO;
import com.xdja.pki.ra.manager.dto.CustomerCertDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerCertDao
extends BaseJdbcDao {
    public CustomerSysCertDO insertCustomerCertInfo(CustomerSysCertDO customerSysCertDO) {
        return (CustomerSysCertDO)this.daoTemplate.insert((Object)customerSysCertDO);
    }

    public void deleteCustomerCert(long certSn) {
        String sql = "DELETE FROM customer_sys_cert WHERE certSn = :certSn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certSn", (Object)certSn);
        this.daoTemplate.deleteBySql(sql, (SqlParameterSource)params);
    }

    public int updateCustomerCertStatus(int certStatus, String certSn) {
        String sql = "UPDATE customer_sys_cert SET cert_status = :certStatus WHERE cert_sn = :certSn OR sign_cert_sn = :certSn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certSn", (Object)certSn);
        params.addValue("certStatus", (Object)certStatus);
        return this.daoTemplate.executeSql(sql, (SqlParameterSource)params);
    }

    public PageInfo<CustomerCertDTO> getSystemCertInfoList(String systemNumber, String certDn, String status, String order, Integer pageSize, Integer pageNo) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT  a.id,c.`cert_patterm` AS certPatterm ,a.cert_type AS certType,a.customer_sys_number AS customerSysNumber,\na.cert_dn AS certDn,a.cert_sn AS signCertSn, d.cert_sn AS encCertSn, a.cert_status AS certStatus, a.effective_time AS effectiveTime,a.failure_time AS failureTime");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM customer_sys_cert a, cert_template c, customer_sys_cert d WHERE a.`temp_id` = c.`id` AND a.cert_status != 0 AND \n((a.`cert_type`=2 AND d.`cert_type`=3 AND a.`pair_cert_index` = d.`pair_cert_index`) \n OR (a.`cert_type`=1 AND d.`cert_type`=1 AND a.`pair_cert_index`= d.`pair_cert_index`) )\n");
        if (StringUtils.isNotBlank((CharSequence)systemNumber)) {
            fromSql.append(" AND a.customer_sys_number like :systemNumber");
            params.addValue("systemNumber", (Object)("%" + systemNumber + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)certDn)) {
            fromSql.append(" AND a.cert_dn like :certDn");
            params.addValue("certDn", (Object)("%" + certDn + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            long nowDateMillis = System.currentTimeMillis();
            String nowDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(nowDateMillis);
            if (Integer.valueOf(status).equals(Constants.CERT_STATUS_EXPIRED_2)) {
                fromSql.append(" AND a.failure_time <= :nowDate");
                params.addValue("nowDate", (Object)nowDate);
            } else if (Integer.valueOf(status).equals(Constants.CERT_STATUS_NORMAL_1)) {
                fromSql.append(" AND a.failure_time >= :nowDate");
                params.addValue("nowDate", (Object)nowDate);
                fromSql.append(" AND a.cert_status = :status");
                params.addValue("status", (Object)status);
            } else if (Integer.valueOf(status).equals(Constants.CERT_STATUS_REVOKED_3)) {
                fromSql.append(" AND a.cert_status = :status");
                fromSql.append(" AND a.failure_time >= :nowDate");
                params.addValue("nowDate", (Object)nowDate);
                params.addValue("status", (Object)status);
            }
        }
        if (StringUtils.isBlank((CharSequence)order)) {
            fromSql.append(" ORDER BY a.effective_time DESC ");
        } else if (order.equals(Constants.ORDER_DESC)) {
            fromSql.append(" ORDER BY a.failure_time DESC ");
        } else if (order.equals(Constants.ORDER_ASC)) {
            fromSql.append(" ORDER BY a.failure_time ASC ");
        }
        countSql.append((CharSequence)fromSql);
        PageInfo<CustomerCertDTO> page = new PageInfo<CustomerCertDTO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerCertDTO.class)));
        return page;
    }

    public List<CustomerSysCertDO> queryClientCertByCertDn(String systemFlag, String certDn) {
        String sql = "SELECT * FROM customer_sys_cert WHERE cert_dn = :certDn and customer_sys_number != :systemFlag";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certDn", (Object)certDn);
        params.addValue("systemFlag", (Object)systemFlag);
        List customerSysCertDOS = this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerSysCertDO.class));
        return customerSysCertDOS;
    }
}

