/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.ra.core.exception.DAOException;
import com.xdja.pki.ra.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dao.model.CustomerSysCertDO;
import com.xdja.pki.ra.manager.dao.model.CustomerSysDO;
import com.xdja.pki.ra.manager.page.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerDao
extends BaseJdbcDao {
    public CustomerSysDO insertSystemInfo(CustomerSysDO customerSysDO) {
        return (CustomerSysDO)this.daoTemplate.insert((Object)customerSysDO);
    }

    public int getSystemIdentifier(Boolean isUpdate, Integer id, String identifier) {
        StringBuilder sql = new StringBuilder("SELECT  COUNT(0) FROM customer_sys WHERE customer_sys.customer_sys_name =:identifier");
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (isUpdate.booleanValue()) {
            sql.append(" AND customer_sys.id !=:id");
            params.addValue("id", (Object)id);
        }
        params.addValue("identifier", (Object)identifier);
        return this.daoTemplate.queryForInt(sql.toString(), (SqlParameterSource)params);
    }

    public int getSystemIdentifier(String identifier) {
        String sql = "SELECT  COUNT(0) FROM customer_sys WHERE customer_sys.customer_sys_number =:identifier";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("identifier", (Object)identifier);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public CustomerSysDO getSystemInfo(Integer id) {
        String sql = "SELECT c.id AS id,c.gmt_create AS gmtCreate, c.customer_sys_number AS customerSysNumber ,c.customer_sys_name AS customerSysName,c.customer_sys_ip AS customerSysIp, c.customer_sys_contact AS customerSysContact FROM customer_sys AS c WHERE c.id =:id";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("id", (Object)id);
        CustomerSysDO customerSysDO = (CustomerSysDO)this.daoTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerSysDO.class));
        return customerSysDO;
    }

    public int updateSystemInfo(CustomerSysDO customerSysDO) {
        return this.daoTemplate.update((Object)customerSysDO);
    }

    public PageInfo<CustomerSysDO> getSystemInfoList(String systemNumber, String systemName, Integer pageSize, Integer pageNo) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT c.id AS id , c.customer_sys_number AS customerSysNumber, c.customer_sys_name AS customerSysName, c.customer_sys_ip AS customerSysIp, c.customer_sys_contact AS customerSysContact, c.gmt_create AS gmtCreate");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM customer_sys AS c");
        fromSql.append(" WHERE c.is_inner != 1 ");
        if (StringUtils.isNotBlank((CharSequence)systemNumber)) {
            fromSql.append(" AND c.customer_sys_number like :systemNumber");
            params.addValue("systemNumber", (Object)("%" + systemNumber + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)systemName)) {
            fromSql.append(" AND c.customer_sys_name like :systemName");
            params.addValue("systemName", (Object)("%" + systemName + "%"));
        }
        fromSql.append(" ORDER BY c.gmt_create DESC ");
        countSql.append((CharSequence)fromSql);
        PageInfo<CustomerSysDO> page = new PageInfo<CustomerSysDO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerSysDO.class)));
        return page;
    }

    public CustomerSysCertDO getSysCertBySysNumber(String sysNumber, String certSn) {
        String sql = "SELECT * FROM customer_sys_cert WHERE customer_sys_number = :sysNumber and cert_sn =:certSn ";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("sysNumber", (Object)sysNumber);
        params.addValue("certSn", (Object)certSn);
        CustomerSysCertDO customerSysCert = (CustomerSysCertDO)this.daoTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerSysCertDO.class));
        return customerSysCert;
    }

    public String getSysCertBySystemFlagAndSn(String systemFlag, String signSn) {
        try {
            String sql = "SELECT cert_info FROM customer_sys_cert WHERE customer_sys_number = :systemFlag AND cert_type in (1,2) AND cert_status = 1 AND cert_sn = :sn";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("systemFlag", (Object)systemFlag);
            params.addValue("sn", (Object)signSn);
            return this.daoTemplate.queryForString(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u901a\u8fc7\u7b2c\u4e09\u65b9\u6807\u8bc6\u548c\u7b7e\u540d\u8bc1\u4e66sn\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
        }
    }

    public List<CertTempDO> getTempNoList(String systemFlag) {
        try {
            String sql = "SELECT * FROM cert_template c WHERE c.temp_status=2 AND is_newest_temp=1 AND c.`temp_no` IN ( SELECT b.temp_no FROM customer_sys a ,customer_sys_temp b WHERE a.`id`=b.`customer_sys_id` AND  customer_sys_number = :systemFlag);";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("systemFlag", (Object)systemFlag);
            List ts = this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CertTempDO.class));
            return ts;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}

