/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.ra.core.exception.DAOException;
import com.xdja.pki.ra.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.UserCertDO;
import com.xdja.pki.ra.manager.dto.UserCertDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class UserCertDao
extends BaseJdbcDao {
    public PageInfo<UserCertDTO> listPageUserCert(String certDn, int userType, String userName, int pageNo, int pageSize, Boolean effectiveTimeAsc, Boolean failureTimeAsc, int leftDate) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT  a.id ,a.user_id AS userId, a.temp_id AS tempId, c.`cert_patterm` AS certPatterm , b.system_flag AS systemFlag, c.temp_no AS tempNo,a.cert_dn AS certDn,a.cert_sn AS signSn, d.cert_sn AS encSn,a.sign_alg AS signAlg, a.private_key_length AS privateKeyLength,  b.user_name AS userName, c.temp_name AS tempName, b.user_type AS userType, a.cert_status AS certStatus, a.effective_time AS effectiveTime,a.failure_time AS failureTime,a.cert_validity AS certValidity,a.is_recovery AS isRecovery,e.customer_sys_name AS systemName");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM user_cert a,base_user b ,cert_template c, user_cert d, customer_sys e WHERE b.system_flag = e.customer_sys_number AND a.`temp_id` = c.`id` AND a.`user_id`= b.`id` AND a.cert_status != 0 AND \n((a.`cert_type`=2 AND d.`cert_type`=3 AND a.`pair_cert_index` = d.`pair_cert_index`) \nOR (a.`cert_type`=1 AND d.`cert_type`=1 AND a.`pair_cert_index`= d.`pair_cert_index`)OR (a.`cert_type`=2 AND d.`cert_type`=2 AND a.`pair_cert_index` = d.`pair_cert_index` AND a.`is_recovery`=1 )) ");
        if (leftDate > 0) {
            fromSql.append(" AND DATEDIFF(a.failure_time, NOW()) <= :leftDate");
            fromSql.append(" AND a.cert_status = 1");
            fromSql.append(" AND a.failure_time>NOW()");
            params.addValue("leftDate", (Object)leftDate);
        }
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            fromSql.append(" AND b.user_name like :userName");
            params.addValue("userName", (Object)("%" + userName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)certDn)) {
            fromSql.append(" AND a.cert_dn like :certDn");
            params.addValue("certDn", (Object)("%" + certDn + "%"));
        }
        if (userType != 0) {
            fromSql.append(" AND b.user_type = :userType");
            params.addValue("userType", (Object)userType);
        }
        if (effectiveTimeAsc == null && failureTimeAsc == null) {
            fromSql.append(" ORDER BY a.gmt_create DESC");
        }
        if (effectiveTimeAsc != null) {
            if (effectiveTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.effective_time ASC");
            }
            if (!effectiveTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.effective_time DESC");
            }
        }
        if (failureTimeAsc != null) {
            if (failureTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.failure_time ASC");
            }
            if (!failureTimeAsc.booleanValue()) {
                fromSql.append(" ORDER BY a.failure_time DESC");
            }
        }
        countSql.append((CharSequence)fromSql);
        PageInfo<UserCertDTO> page = new PageInfo<UserCertDTO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(UserCertDTO.class)));
        return page;
    }

    public UserCertDO getUserCertBaseInfo(String signSn) {
        return (UserCertDO)this.daoTemplate.fetch(UserCertDO.class, (Condition)Cnd.where((String)"cert_sn", (String)"=", (Object)signSn));
    }

    public int getUserIsHave(String signSn) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String sql = "SELECT COUNT(*)  FROM base_user WHERE id =(\nSELECT user_id FROM user_cert WHERE  cert_sn = :signSn\n) AND system_flag = 'V2X'";
        params.addValue("signSn", (Object)signSn);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public UserCertDO getUserCertBaseInfoBySignSn(String signSn) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(2);
        return (UserCertDO)this.daoTemplate.fetch(UserCertDO.class, (Condition)Cnd.where((String)"cert_sn", (String)"=", (Object)signSn).and("cert_type", "in", list));
    }

    public UserCertDO insertUserCertInfo(UserCertDO userCertDO) {
        return (UserCertDO)this.daoTemplate.insert((Object)userCertDO);
    }

    public void insertUserCertInfoList(List<UserCertDO> userCertList) {
        this.daoTemplate.insert(userCertList);
    }

    public int insertUserCertInfo2(UserCertDO encCertDO, UserCertDO signCertDO) {
        String sql = "insert  into `user_cert`(`user_id`,`pair_cert_index`,`ca_cert_id`,`apply_id`,`cert_dn`,`cert_type`,`cert_sn`,`sign_cert_sn`,`temp_id`,`temp_no`,`cert_status`,`sign_alg`,`private_key_length`,`cert_validity`,`enc_key_validity`,`effective_time`,`failure_time`) values \n( :userId, :pairCertIndex, :caCertId, :applyId, :certDn, :certType, :certSn, :signCertSn, :tempId, :tempNo, :certStatus, :signAlg, :privateKeyLength,:certValidity, :encKeyValidity, :effectiveTime, :failureTime),\n( :userId, :pairCertIndex, :caCertId, :applyId, :certDn, :signCertType, :signCertSn, NULL, :tempId, :tempNo, :certStatus, :signAlg, :privateKeyLength,:certValidity, :encKeyValidity, :effectiveTime, :failureTime)\n";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("userId", (Object)encCertDO.getUserId());
        params.addValue("pairCertIndex", (Object)encCertDO.getPairCertIndex());
        params.addValue("caCertId", (Object)encCertDO.getCaCertId());
        params.addValue("applyId", (Object)encCertDO.getApplyId());
        params.addValue("certDn", (Object)encCertDO.getCertDn());
        params.addValue("certType", (Object)encCertDO.getCertType());
        params.addValue("certSn", (Object)encCertDO.getCertSn());
        params.addValue("signCertSn", (Object)signCertDO.getCertSn());
        params.addValue("tempId", (Object)encCertDO.getTempId());
        params.addValue("tempNo", (Object)encCertDO.getTempNo());
        params.addValue("certStatus", (Object)encCertDO.getCertStatus());
        params.addValue("signAlg", (Object)encCertDO.getSignAlg());
        params.addValue("privateKeyLength", (Object)encCertDO.getPrivateKeyLength());
        params.addValue("certValidity", (Object)encCertDO.getCertValidity());
        params.addValue("encKeyValidity", (Object)encCertDO.getEncKeyValidity());
        params.addValue("effectiveTime", (Object)encCertDO.getEffectiveTime());
        params.addValue("failureTime", (Object)encCertDO.getFailureTime());
        params.addValue("signCertType", (Object)signCertDO.getCertType());
        return this.daoTemplate.update(sql, (SqlParameterSource)params);
    }

    public void deleteUserCert(long certSn) {
        String sql = "DELETE FROM user_cert WHERE certSn = :certSn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certSn", (Object)certSn);
        this.daoTemplate.deleteBySql(sql, (SqlParameterSource)params);
    }

    public int getUserCertByUserIdAndCertDN(String certDn, long userId) {
        String sql = "SELECT count(*) FROM user_cert WHERE cert_dn = :certDn AND user_id!=:userId";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certDn", (Object)certDn);
        params.addValue("userId", (Object)userId);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public int updateUserCertStatus(int certStatus, String certSn) {
        String sql = "UPDATE user_cert SET cert_status = :certStatus WHERE cert_sn = :certSn OR sign_cert_sn = :certSn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certSn", (Object)certSn);
        params.addValue("certStatus", (Object)certStatus);
        return this.daoTemplate.executeSql(sql, (SqlParameterSource)params);
    }

    public int updateDoubleUserCertStatus(int certStatus, String signCertSn) {
        String sql = "UPDATE user_cert SET cert_status = :certStatus WHERE pair_cert_index = (SELECT a.pair_cert_index FROM (SELECT pair_cert_index FROM user_cert WHERE cert_sn = :certSn  AND cert_type in(1, 2)) a )";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certSn", (Object)signCertSn);
        params.addValue("certStatus", (Object)certStatus);
        return this.daoTemplate.executeSql(sql, (SqlParameterSource)params);
    }

    public List<UserCertDO> getUserCertList(long userId) {
        try {
            String sql = "SELECT * FROM user_cert WHERE user_id=:userId and sign_cert_sn is not null";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("userId", (Object)userId);
            return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(UserCertDO.class));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
    }

    public UserCertDO getUserDetail(String certSn) {
        try {
            return (UserCertDO)this.daoTemplate.fetch(UserCertDO.class, (Condition)Cnd.where((String)"cert_sn", (String)"=", (Object)certSn));
        }
        catch (Exception e) {
            throw new DAOException("\u67e5\u8be2\u8bc1\u4e66\u8be6\u60c5\u5f02\u5e38", (Throwable)e);
        }
    }

    public Long getUserId(String signSn) {
        try {
            String sql = "SELECT user_id FROM user_cert WHERE cert_sn = :sn ";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("sn", (Object)signSn);
            return this.daoTemplate.queryForLong(sql, (SqlParameterSource)params);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public String getEncSnBySignSn(String signSn) {
        try {
            String sql = "SELECT cert_sn FROM user_cert WHERE pair_cert_index = (SELECT pair_cert_index FROM user_cert WHERE cert_sn = :signSn ) AND cert_type =3";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("signSn", (Object)signSn);
            return this.daoTemplate.queryForString(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int updateUserCert(UserCertDO userCertDO) {
        return this.daoTemplate.update((Object)userCertDO);
    }
}

